@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin

import com.pulumi.alicloud.eventbridge.EventBusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Event Bridge Event Bus resource.
 * For information about Event Bridge Event Bus and how to use it, see [What is Event Bus](https://www.alibabacloud.com/help/en/eventbridge/latest/api-eventbridge-2020-04-01-createeventbus).
 * > **NOTE:** Available since v1.129.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.eventbridge.EventBus("example", {eventBusName: name});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.eventbridge.EventBus("example", event_bus_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.EventBridge.EventBus("example", new()
 *     {
 *         EventBusName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eventbridge"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := eventbridge.NewEventBus(ctx, "example", &eventbridge.EventBusArgs{
 * 			EventBusName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eventbridge.EventBus;
 * import com.pulumi.alicloud.eventbridge.EventBusArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new EventBus("example", EventBusArgs.builder()
 *             .eventBusName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:eventbridge:EventBus
 *     properties:
 *       eventBusName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Event Bridge Event Bus can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eventbridge/eventBus:EventBus example <event_bus_name>
 * ```
 * @property description The description of event bus.
 * @property eventBusName The name of event bus. The length is limited to 2 ~ 127 characters, which can be composed of letters, numbers or hyphens (-)
 */
public data class EventBusArgs(
    public val description: Output<String>? = null,
    public val eventBusName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eventbridge.EventBusArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.EventBusArgs =
        com.pulumi.alicloud.eventbridge.EventBusArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .eventBusName(eventBusName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventBusArgs].
 */
@PulumiTagMarker
public class EventBusArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var eventBusName: Output<String>? = null

    /**
     * @param value The description of event bus.
     */
    @JvmName("tqshwlmqludthpfg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of event bus. The length is limited to 2 ~ 127 characters, which can be composed of letters, numbers or hyphens (-)
     */
    @JvmName("mrrjfxftvcflurrg")
    public suspend fun eventBusName(`value`: Output<String>) {
        this.eventBusName = value
    }

    /**
     * @param value The description of event bus.
     */
    @JvmName("ywcflialspasyrys")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of event bus. The length is limited to 2 ~ 127 characters, which can be composed of letters, numbers or hyphens (-)
     */
    @JvmName("vuqxcwxaotsnwqty")
    public suspend fun eventBusName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBusName = mapped
    }

    internal fun build(): EventBusArgs = EventBusArgs(
        description = description,
        eventBusName = eventBusName,
    )
}
