@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EventSource].
 */
@PulumiTagMarker
public class EventSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventSourceArgs = EventSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventSourceArgsBuilder.() -> Unit) {
        val builder = EventSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventSource {
        val builtJavaResource = com.pulumi.alicloud.eventbridge.EventSource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventSource(builtJavaResource)
    }
}

/**
 * Provides a Event Bridge Event Source resource.
 * For information about Event Bridge Event Source and how to use it, see [What is Event Source](https://www.alibabacloud.com/help/en/eventbridge/latest/api-eventbridge-2020-04-01-createeventsource).
 * > **NOTE:** Available since v1.130.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = new alicloud.eventbridge.EventBus("example", {eventBusName: name});
 * const exampleQueue = new alicloud.mns.Queue("example", {name: `${name}-${_default.result}`});
 * const exampleEventSource = new alicloud.eventbridge.EventSource("example", {
 *     eventBusName: example.eventBusName,
 *     eventSourceName: name,
 *     description: name,
 *     linkedExternalSource: true,
 *     externalSourceType: "MNS",
 *     externalSourceConfig: {
 *         QueueName: exampleQueue.name,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.eventbridge.EventBus("example", event_bus_name=name)
 * example_queue = alicloud.mns.Queue("example", name=f"{name}-{default['result']}")
 * example_event_source = alicloud.eventbridge.EventSource("example",
 *     event_bus_name=example.event_bus_name,
 *     event_source_name=name,
 *     description=name,
 *     linked_external_source=True,
 *     external_source_type="MNS",
 *     external_source_config={
 *         "QueueName": example_queue.name,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = new AliCloud.EventBridge.EventBus("example", new()
 *     {
 *         EventBusName = name,
 *     });
 *     var exampleQueue = new AliCloud.Mns.Queue("example", new()
 *     {
 *         Name = $"{name}-{@default.Result}",
 *     });
 *     var exampleEventSource = new AliCloud.EventBridge.EventSource("example", new()
 *     {
 *         EventBusName = example.EventBusName,
 *         EventSourceName = name,
 *         Description = name,
 *         LinkedExternalSource = true,
 *         ExternalSourceType = "MNS",
 *         ExternalSourceConfig =
 *         {
 *             { "QueueName", exampleQueue.Name },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eventbridge"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mns"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := eventbridge.NewEventBus(ctx, "example", &eventbridge.EventBusArgs{
 * 			EventBusName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleQueue, err := mns.NewQueue(ctx, "example", &mns.QueueArgs{
 * 			Name: pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eventbridge.NewEventSource(ctx, "example", &eventbridge.EventSourceArgs{
 * 			EventBusName:         example.EventBusName,
 * 			EventSourceName:      pulumi.String(name),
 * 			Description:          pulumi.String(name),
 * 			LinkedExternalSource: pulumi.Bool(true),
 * 			ExternalSourceType:   pulumi.String("MNS"),
 * 			ExternalSourceConfig: pulumi.StringMap{
 * 				"QueueName": exampleQueue.Name,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.eventbridge.EventBus;
 * import com.pulumi.alicloud.eventbridge.EventBusArgs;
 * import com.pulumi.alicloud.mns.Queue;
 * import com.pulumi.alicloud.mns.QueueArgs;
 * import com.pulumi.alicloud.eventbridge.EventSource;
 * import com.pulumi.alicloud.eventbridge.EventSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var example = new EventBus("example", EventBusArgs.builder()
 *             .eventBusName(name)
 *             .build());
 *         var exampleQueue = new Queue("exampleQueue", QueueArgs.builder()
 *             .name(String.format("%s-%s", name,default_.result()))
 *             .build());
 *         var exampleEventSource = new EventSource("exampleEventSource", EventSourceArgs.builder()
 *             .eventBusName(example.eventBusName())
 *             .eventSourceName(name)
 *             .description(name)
 *             .linkedExternalSource(true)
 *             .externalSourceType("MNS")
 *             .externalSourceConfig(Map.of("QueueName", exampleQueue.name()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:eventbridge:EventBus
 *     properties:
 *       eventBusName: ${name}
 *   exampleQueue:
 *     type: alicloud:mns:Queue
 *     name: example
 *     properties:
 *       name: ${name}-${default.result}
 *   exampleEventSource:
 *     type: alicloud:eventbridge:EventSource
 *     name: example
 *     properties:
 *       eventBusName: ${example.eventBusName}
 *       eventSourceName: ${name}
 *       description: ${name}
 *       linkedExternalSource: true
 *       externalSourceType: MNS
 *       externalSourceConfig:
 *         QueueName: ${exampleQueue.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Event Bridge Event Source can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eventbridge/eventSource:EventSource example <event_source_name>
 * ```
 */
public class EventSource internal constructor(
    override val javaResource: com.pulumi.alicloud.eventbridge.EventSource,
) : KotlinCustomResource(javaResource, EventSourceMapper) {
    /**
     * The detail describe of event source.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of event bus.
     */
    public val eventBusName: Output<String>
        get() = javaResource.eventBusName().applyValue({ args0 -> args0 })

    /**
     * The code name of event source.
     */
    public val eventSourceName: Output<String>
        get() = javaResource.eventSourceName().applyValue({ args0 -> args0 })

    /**
     * The config of external source.
     * When `external_source_type` is `RabbitMQ`, The following attributes are supported:
     * `RegionId` - The region ID of RabbitMQ.
     * `InstanceId` - The instance ID of RabbitMQ.
     * `VirtualHostName` - The virtual host name of RabbitMQ.
     * `QueueName` - The queue name of RabbitMQ.
     * When `external_source_type` is `RabbitMQ`, The following attributes are supported:
     * `RegionId` - The region ID of RabbitMQ.
     * `InstanceId` - The instance ID of RabbitMQ.
     * `Topic` - The topic of RabbitMQ.
     * `Offset` -  The offset of RabbitMQ, valid values: `CONSUME_FROM_FIRST_OFFSET`, `CONSUME_FROM_LAST_OFFSET` and `CONSUME_FROM_TIMESTAMP`.
     * `GroupID` - The group ID of consumer.
     * When `external_source_type` is `MNS`, The following attributes are supported:
     * `QueueName` - The queue name of MNS.
     */
    public val externalSourceConfig: Output<Map<String, String>>?
        get() = javaResource.externalSourceConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The type of external data source. Valid value : `RabbitMQ`, `RocketMQ` and `MNS`. **NOTE:** Only When `linked_external_source` is `true`, This field is valid.
     */
    public val externalSourceType: Output<String>?
        get() = javaResource.externalSourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to connect to an external data source. Default value: `false`
     */
    public val linkedExternalSource: Output<Boolean>
        get() = javaResource.linkedExternalSource().applyValue({ args0 -> args0 })
}

public object EventSourceMapper : ResourceMapper<EventSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.eventbridge.EventSource::class == javaResource::class

    override fun map(javaResource: Resource): EventSource = EventSource(
        javaResource as
            com.pulumi.alicloud.eventbridge.EventSource,
    )
}

/**
 * @see [EventSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventSource].
 */
public suspend fun eventSource(name: String, block: suspend EventSourceResourceBuilder.() -> Unit): EventSource {
    val builder = EventSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventSource(name: String): EventSource {
    val builder = EventSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
