@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin

import com.pulumi.alicloud.eventbridge.EventSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Event Bridge Event Source resource.
 * For information about Event Bridge Event Source and how to use it, see [What is Event Source](https://www.alibabacloud.com/help/en/eventbridge/latest/api-eventbridge-2020-04-01-createeventsource).
 * > **NOTE:** Available since v1.130.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = new alicloud.eventbridge.EventBus("example", {eventBusName: name});
 * const exampleQueue = new alicloud.mns.Queue("example", {name: `${name}-${_default.result}`});
 * const exampleEventSource = new alicloud.eventbridge.EventSource("example", {
 *     eventBusName: example.eventBusName,
 *     eventSourceName: name,
 *     description: name,
 *     linkedExternalSource: true,
 *     externalSourceType: "MNS",
 *     externalSourceConfig: {
 *         QueueName: exampleQueue.name,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.eventbridge.EventBus("example", event_bus_name=name)
 * example_queue = alicloud.mns.Queue("example", name=f"{name}-{default['result']}")
 * example_event_source = alicloud.eventbridge.EventSource("example",
 *     event_bus_name=example.event_bus_name,
 *     event_source_name=name,
 *     description=name,
 *     linked_external_source=True,
 *     external_source_type="MNS",
 *     external_source_config={
 *         "QueueName": example_queue.name,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = new AliCloud.EventBridge.EventBus("example", new()
 *     {
 *         EventBusName = name,
 *     });
 *     var exampleQueue = new AliCloud.Mns.Queue("example", new()
 *     {
 *         Name = $"{name}-{@default.Result}",
 *     });
 *     var exampleEventSource = new AliCloud.EventBridge.EventSource("example", new()
 *     {
 *         EventBusName = example.EventBusName,
 *         EventSourceName = name,
 *         Description = name,
 *         LinkedExternalSource = true,
 *         ExternalSourceType = "MNS",
 *         ExternalSourceConfig =
 *         {
 *             { "QueueName", exampleQueue.Name },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eventbridge"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mns"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := eventbridge.NewEventBus(ctx, "example", &eventbridge.EventBusArgs{
 * 			EventBusName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleQueue, err := mns.NewQueue(ctx, "example", &mns.QueueArgs{
 * 			Name: pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eventbridge.NewEventSource(ctx, "example", &eventbridge.EventSourceArgs{
 * 			EventBusName:         example.EventBusName,
 * 			EventSourceName:      pulumi.String(name),
 * 			Description:          pulumi.String(name),
 * 			LinkedExternalSource: pulumi.Bool(true),
 * 			ExternalSourceType:   pulumi.String("MNS"),
 * 			ExternalSourceConfig: pulumi.StringMap{
 * 				"QueueName": exampleQueue.Name,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.eventbridge.EventBus;
 * import com.pulumi.alicloud.eventbridge.EventBusArgs;
 * import com.pulumi.alicloud.mns.Queue;
 * import com.pulumi.alicloud.mns.QueueArgs;
 * import com.pulumi.alicloud.eventbridge.EventSource;
 * import com.pulumi.alicloud.eventbridge.EventSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var example = new EventBus("example", EventBusArgs.builder()
 *             .eventBusName(name)
 *             .build());
 *         var exampleQueue = new Queue("exampleQueue", QueueArgs.builder()
 *             .name(String.format("%s-%s", name,default_.result()))
 *             .build());
 *         var exampleEventSource = new EventSource("exampleEventSource", EventSourceArgs.builder()
 *             .eventBusName(example.eventBusName())
 *             .eventSourceName(name)
 *             .description(name)
 *             .linkedExternalSource(true)
 *             .externalSourceType("MNS")
 *             .externalSourceConfig(Map.of("QueueName", exampleQueue.name()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:eventbridge:EventBus
 *     properties:
 *       eventBusName: ${name}
 *   exampleQueue:
 *     type: alicloud:mns:Queue
 *     name: example
 *     properties:
 *       name: ${name}-${default.result}
 *   exampleEventSource:
 *     type: alicloud:eventbridge:EventSource
 *     name: example
 *     properties:
 *       eventBusName: ${example.eventBusName}
 *       eventSourceName: ${name}
 *       description: ${name}
 *       linkedExternalSource: true
 *       externalSourceType: MNS
 *       externalSourceConfig:
 *         QueueName: ${exampleQueue.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Event Bridge Event Source can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eventbridge/eventSource:EventSource example <event_source_name>
 * ```
 * @property description The detail describe of event source.
 * @property eventBusName The name of event bus.
 * @property eventSourceName The code name of event source.
 * @property externalSourceConfig The config of external source.
 * When `external_source_type` is `RabbitMQ`, The following attributes are supported:
 * `RegionId` - The region ID of RabbitMQ.
 * `InstanceId` - The instance ID of RabbitMQ.
 * `VirtualHostName` - The virtual host name of RabbitMQ.
 * `QueueName` - The queue name of RabbitMQ.
 * When `external_source_type` is `RabbitMQ`, The following attributes are supported:
 * `RegionId` - The region ID of RabbitMQ.
 * `InstanceId` - The instance ID of RabbitMQ.
 * `Topic` - The topic of RabbitMQ.
 * `Offset` -  The offset of RabbitMQ, valid values: `CONSUME_FROM_FIRST_OFFSET`, `CONSUME_FROM_LAST_OFFSET` and `CONSUME_FROM_TIMESTAMP`.
 * `GroupID` - The group ID of consumer.
 * When `external_source_type` is `MNS`, The following attributes are supported:
 * `QueueName` - The queue name of MNS.
 * @property externalSourceType The type of external data source. Valid value : `RabbitMQ`, `RocketMQ` and `MNS`. **NOTE:** Only When `linked_external_source` is `true`, This field is valid.
 * @property linkedExternalSource Whether to connect to an external data source. Default value: `false`
 */
public data class EventSourceArgs(
    public val description: Output<String>? = null,
    public val eventBusName: Output<String>? = null,
    public val eventSourceName: Output<String>? = null,
    public val externalSourceConfig: Output<Map<String, String>>? = null,
    public val externalSourceType: Output<String>? = null,
    public val linkedExternalSource: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eventbridge.EventSourceArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.EventSourceArgs =
        com.pulumi.alicloud.eventbridge.EventSourceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .eventBusName(eventBusName?.applyValue({ args0 -> args0 }))
            .eventSourceName(eventSourceName?.applyValue({ args0 -> args0 }))
            .externalSourceConfig(
                externalSourceConfig?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .externalSourceType(externalSourceType?.applyValue({ args0 -> args0 }))
            .linkedExternalSource(linkedExternalSource?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventSourceArgs].
 */
@PulumiTagMarker
public class EventSourceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var eventBusName: Output<String>? = null

    private var eventSourceName: Output<String>? = null

    private var externalSourceConfig: Output<Map<String, String>>? = null

    private var externalSourceType: Output<String>? = null

    private var linkedExternalSource: Output<Boolean>? = null

    /**
     * @param value The detail describe of event source.
     */
    @JvmName("gkhlxyjrjnnxnwqx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of event bus.
     */
    @JvmName("plixquefgjrxueqm")
    public suspend fun eventBusName(`value`: Output<String>) {
        this.eventBusName = value
    }

    /**
     * @param value The code name of event source.
     */
    @JvmName("xmkvpqddpxatpnfb")
    public suspend fun eventSourceName(`value`: Output<String>) {
        this.eventSourceName = value
    }

    /**
     * @param value The config of external source.
     * When `external_source_type` is `RabbitMQ`, The following attributes are supported:
     * `RegionId` - The region ID of RabbitMQ.
     * `InstanceId` - The instance ID of RabbitMQ.
     * `VirtualHostName` - The virtual host name of RabbitMQ.
     * `QueueName` - The queue name of RabbitMQ.
     * When `external_source_type` is `RabbitMQ`, The following attributes are supported:
     * `RegionId` - The region ID of RabbitMQ.
     * `InstanceId` - The instance ID of RabbitMQ.
     * `Topic` - The topic of RabbitMQ.
     * `Offset` -  The offset of RabbitMQ, valid values: `CONSUME_FROM_FIRST_OFFSET`, `CONSUME_FROM_LAST_OFFSET` and `CONSUME_FROM_TIMESTAMP`.
     * `GroupID` - The group ID of consumer.
     * When `external_source_type` is `MNS`, The following attributes are supported:
     * `QueueName` - The queue name of MNS.
     */
    @JvmName("bwetjmijmhavwcaj")
    public suspend fun externalSourceConfig(`value`: Output<Map<String, String>>) {
        this.externalSourceConfig = value
    }

    /**
     * @param value The type of external data source. Valid value : `RabbitMQ`, `RocketMQ` and `MNS`. **NOTE:** Only When `linked_external_source` is `true`, This field is valid.
     */
    @JvmName("oatxqjlnhjkwxait")
    public suspend fun externalSourceType(`value`: Output<String>) {
        this.externalSourceType = value
    }

    /**
     * @param value Whether to connect to an external data source. Default value: `false`
     */
    @JvmName("jmbakljqnglkewls")
    public suspend fun linkedExternalSource(`value`: Output<Boolean>) {
        this.linkedExternalSource = value
    }

    /**
     * @param value The detail describe of event source.
     */
    @JvmName("uwkfkpjjeidujoiw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of event bus.
     */
    @JvmName("iyiyvuddvclgrxsi")
    public suspend fun eventBusName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBusName = mapped
    }

    /**
     * @param value The code name of event source.
     */
    @JvmName("cpdhllfyfscnbjhn")
    public suspend fun eventSourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSourceName = mapped
    }

    /**
     * @param value The config of external source.
     * When `external_source_type` is `RabbitMQ`, The following attributes are supported:
     * `RegionId` - The region ID of RabbitMQ.
     * `InstanceId` - The instance ID of RabbitMQ.
     * `VirtualHostName` - The virtual host name of RabbitMQ.
     * `QueueName` - The queue name of RabbitMQ.
     * When `external_source_type` is `RabbitMQ`, The following attributes are supported:
     * `RegionId` - The region ID of RabbitMQ.
     * `InstanceId` - The instance ID of RabbitMQ.
     * `Topic` - The topic of RabbitMQ.
     * `Offset` -  The offset of RabbitMQ, valid values: `CONSUME_FROM_FIRST_OFFSET`, `CONSUME_FROM_LAST_OFFSET` and `CONSUME_FROM_TIMESTAMP`.
     * `GroupID` - The group ID of consumer.
     * When `external_source_type` is `MNS`, The following attributes are supported:
     * `QueueName` - The queue name of MNS.
     */
    @JvmName("jopjrjpyjasyqqdy")
    public suspend fun externalSourceConfig(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalSourceConfig = mapped
    }

    /**
     * @param values The config of external source.
     * When `external_source_type` is `RabbitMQ`, The following attributes are supported:
     * `RegionId` - The region ID of RabbitMQ.
     * `InstanceId` - The instance ID of RabbitMQ.
     * `VirtualHostName` - The virtual host name of RabbitMQ.
     * `QueueName` - The queue name of RabbitMQ.
     * When `external_source_type` is `RabbitMQ`, The following attributes are supported:
     * `RegionId` - The region ID of RabbitMQ.
     * `InstanceId` - The instance ID of RabbitMQ.
     * `Topic` - The topic of RabbitMQ.
     * `Offset` -  The offset of RabbitMQ, valid values: `CONSUME_FROM_FIRST_OFFSET`, `CONSUME_FROM_LAST_OFFSET` and `CONSUME_FROM_TIMESTAMP`.
     * `GroupID` - The group ID of consumer.
     * When `external_source_type` is `MNS`, The following attributes are supported:
     * `QueueName` - The queue name of MNS.
     */
    @JvmName("hydcyaxeopoclywt")
    public fun externalSourceConfig(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalSourceConfig = mapped
    }

    /**
     * @param value The type of external data source. Valid value : `RabbitMQ`, `RocketMQ` and `MNS`. **NOTE:** Only When `linked_external_source` is `true`, This field is valid.
     */
    @JvmName("ftflfwwupipenniv")
    public suspend fun externalSourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalSourceType = mapped
    }

    /**
     * @param value Whether to connect to an external data source. Default value: `false`
     */
    @JvmName("fpjrtwenkxbvpfdj")
    public suspend fun linkedExternalSource(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedExternalSource = mapped
    }

    internal fun build(): EventSourceArgs = EventSourceArgs(
        description = description,
        eventBusName = eventBusName,
        eventSourceName = eventSourceName,
        externalSourceConfig = externalSourceConfig,
        externalSourceType = externalSourceType,
        linkedExternalSource = linkedExternalSource,
    )
}
