@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin

import com.pulumi.alicloud.eventbridge.EventbridgeFunctions.getEventBusesPlain
import com.pulumi.alicloud.eventbridge.EventbridgeFunctions.getEventSourcesPlain
import com.pulumi.alicloud.eventbridge.EventbridgeFunctions.getRulesPlain
import com.pulumi.alicloud.eventbridge.EventbridgeFunctions.getServicePlain
import com.pulumi.alicloud.eventbridge.kotlin.inputs.GetEventBusesPlainArgs
import com.pulumi.alicloud.eventbridge.kotlin.inputs.GetEventBusesPlainArgsBuilder
import com.pulumi.alicloud.eventbridge.kotlin.inputs.GetEventSourcesPlainArgs
import com.pulumi.alicloud.eventbridge.kotlin.inputs.GetEventSourcesPlainArgsBuilder
import com.pulumi.alicloud.eventbridge.kotlin.inputs.GetRulesPlainArgs
import com.pulumi.alicloud.eventbridge.kotlin.inputs.GetRulesPlainArgsBuilder
import com.pulumi.alicloud.eventbridge.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.eventbridge.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.eventbridge.kotlin.outputs.GetEventBusesResult
import com.pulumi.alicloud.eventbridge.kotlin.outputs.GetEventSourcesResult
import com.pulumi.alicloud.eventbridge.kotlin.outputs.GetRulesResult
import com.pulumi.alicloud.eventbridge.kotlin.outputs.GetServiceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.eventbridge.kotlin.outputs.GetEventBusesResult.Companion.toKotlin as getEventBusesResultToKotlin
import com.pulumi.alicloud.eventbridge.kotlin.outputs.GetEventSourcesResult.Companion.toKotlin as getEventSourcesResultToKotlin
import com.pulumi.alicloud.eventbridge.kotlin.outputs.GetRulesResult.Companion.toKotlin as getRulesResultToKotlin
import com.pulumi.alicloud.eventbridge.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin

public object EventbridgeFunctions {
    /**
     * This data source provides the Event Bridge Event Buses of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.129.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.eventbridge.getEventBuses({});
     * export const eventBridgeEventBusId1 = ids.then(ids => ids.buses?.[0]?.id);
     * const nameRegex = alicloud.eventbridge.getEventBuses({
     *     nameRegex: "^my-EventBus",
     * });
     * export const eventBridgeEventBusId2 = nameRegex.then(nameRegex => nameRegex.buses?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.eventbridge.get_event_buses()
     * pulumi.export("eventBridgeEventBusId1", ids.buses[0].id)
     * name_regex = alicloud.eventbridge.get_event_buses(name_regex="^my-EventBus")
     * pulumi.export("eventBridgeEventBusId2", name_regex.buses[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.EventBridge.GetEventBuses.Invoke();
     *     var nameRegex = AliCloud.EventBridge.GetEventBuses.Invoke(new()
     *     {
     *         NameRegex = "^my-EventBus",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["eventBridgeEventBusId1"] = ids&#46;Apply(getEventBusesResult => getEventBusesResult&#46;Buses[0]?.Id),
     *         ["eventBridgeEventBusId2"] = nameRegex&#46;Apply(getEventBusesResult => getEventBusesResult&#46;Buses[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eventbridge"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := eventbridge.GetEventBuses(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("eventBridgeEventBusId1", ids.Buses[0].Id)
     * 		nameRegex, err := eventbridge.GetEventBuses(ctx, &eventbridge.GetEventBusesArgs{
     * 			NameRegex: pulumi.StringRef("^my-EventBus"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("eventBridgeEventBusId2", nameRegex.Buses[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eventbridge.EventbridgeFunctions;
     * import com.pulumi.alicloud.eventbridge.inputs.GetEventBusesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EventbridgeFunctions.getEventBuses();
     *         ctx.export("eventBridgeEventBusId1", ids.applyValue(getEventBusesResult -> getEventBusesResult.buses()[0].id()));
     *         final var nameRegex = EventbridgeFunctions.getEventBuses(GetEventBusesArgs.builder()
     *             .nameRegex("^my-EventBus")
     *             .build());
     *         ctx.export("eventBridgeEventBusId2", nameRegex.applyValue(getEventBusesResult -> getEventBusesResult.buses()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:eventbridge:getEventBuses
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:eventbridge:getEventBuses
     *       Arguments:
     *         nameRegex: ^my-EventBus
     * outputs:
     *   eventBridgeEventBusId1: ${ids.buses[0].id}
     *   eventBridgeEventBusId2: ${nameRegex.buses[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEventBuses.
     * @return A collection of values returned by getEventBuses.
     */
    public suspend fun getEventBuses(argument: GetEventBusesPlainArgs): GetEventBusesResult =
        getEventBusesResultToKotlin(getEventBusesPlain(argument.toJava()).await())

    /**
     * @see [getEventBuses].
     * @param eventBusType The event bus type.
     * @param ids A list of Event Bus IDs. Its element value is same as Event Bus Name.
     * @param namePrefix The name prefix.
     * @param nameRegex A regex string to filter results by Event Bus name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getEventBuses.
     */
    public suspend fun getEventBuses(
        eventBusType: String? = null,
        ids: List<String>? = null,
        namePrefix: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetEventBusesResult {
        val argument = GetEventBusesPlainArgs(
            eventBusType = eventBusType,
            ids = ids,
            namePrefix = namePrefix,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getEventBusesResultToKotlin(getEventBusesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventBuses].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eventbridge&#46;kotlin&#46;inputs&#46;GetEventBusesPlainArgs].
     * @return A collection of values returned by getEventBuses.
     */
    public suspend fun getEventBuses(argument: suspend GetEventBusesPlainArgsBuilder.() -> Unit): GetEventBusesResult {
        val builder = GetEventBusesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventBusesResultToKotlin(getEventBusesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Event Bridge Event Sources of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.130.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.eventbridge.getEventSources({
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstEventBridgeEventSourceId = example.then(example => example.sources?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.eventbridge.get_event_sources(ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstEventBridgeEventSourceId", example.sources[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.EventBridge.GetEventSources.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEventBridgeEventSourceId"] = example&#46;Apply(getEventSourcesResult => getEventSourcesResult&#46;Sources[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eventbridge"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := eventbridge.GetEventSources(ctx, &eventbridge.GetEventSourcesArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEventBridgeEventSourceId", example.Sources[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eventbridge.EventbridgeFunctions;
     * import com.pulumi.alicloud.eventbridge.inputs.GetEventSourcesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EventbridgeFunctions.getEventSources(GetEventSourcesArgs.builder()
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstEventBridgeEventSourceId", example.applyValue(getEventSourcesResult -> getEventSourcesResult.sources()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:eventbridge:getEventSources
     *       Arguments:
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstEventBridgeEventSourceId: ${example.sources[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEventSources.
     * @return A collection of values returned by getEventSources.
     */
    public suspend fun getEventSources(argument: GetEventSourcesPlainArgs): GetEventSourcesResult =
        getEventSourcesResultToKotlin(getEventSourcesPlain(argument.toJava()).await())

    /**
     * @see [getEventSources].
     * @param ids A list of Event Source IDs.
     * @param nameRegex A regex string to filter results by Event Source name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getEventSources.
     */
    public suspend fun getEventSources(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetEventSourcesResult {
        val argument = GetEventSourcesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getEventSourcesResultToKotlin(getEventSourcesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventSources].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eventbridge&#46;kotlin&#46;inputs&#46;GetEventSourcesPlainArgs].
     * @return A collection of values returned by getEventSources.
     */
    public suspend fun getEventSources(argument: suspend GetEventSourcesPlainArgsBuilder.() -> Unit): GetEventSourcesResult {
        val builder = GetEventSourcesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventSourcesResultToKotlin(getEventSourcesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Event Bridge Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.129.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.eventbridge.getRules({
     *     eventBusName: "example_value",
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstEventBridgeRuleId = example.then(example => example.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.eventbridge.get_rules(event_bus_name="example_value",
     *     ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstEventBridgeRuleId", example.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.EventBridge.GetRules.Invoke(new()
     *     {
     *         EventBusName = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEventBridgeRuleId"] = example&#46;Apply(getRulesResult => getRulesResult&#46;Rules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eventbridge"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := eventbridge.GetRules(ctx, &eventbridge.GetRulesArgs{
     * 			EventBusName: "example_value",
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEventBridgeRuleId", example.Rules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eventbridge.EventbridgeFunctions;
     * import com.pulumi.alicloud.eventbridge.inputs.GetRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EventbridgeFunctions.getRules(GetRulesArgs.builder()
     *             .eventBusName("example_value")
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstEventBridgeRuleId", example.applyValue(getRulesResult -> getRulesResult.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:eventbridge:getRules
     *       Arguments:
     *         eventBusName: example_value
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstEventBridgeRuleId: ${example.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRules.
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(argument: GetRulesPlainArgs): GetRulesResult =
        getRulesResultToKotlin(getRulesPlain(argument.toJava()).await())

    /**
     * @see [getRules].
     * @param eventBusName The name of event bus.
     * @param ids A list of Rule IDs.
     * @param nameRegex A regex string to filter results by Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param ruleNamePrefix The rule name prefix.
     * @param status Rule status, either Enable or Disable. Valid values: `DISABLE`, `ENABLE`.
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(
        eventBusName: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        ruleNamePrefix: String? = null,
        status: String? = null,
    ): GetRulesResult {
        val argument = GetRulesPlainArgs(
            eventBusName = eventBusName,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            ruleNamePrefix = ruleNamePrefix,
            status = status,
        )
        return getRulesResultToKotlin(getRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eventbridge&#46;kotlin&#46;inputs&#46;GetRulesPlainArgs].
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(argument: suspend GetRulesPlainArgsBuilder.() -> Unit): GetRulesResult {
        val builder = GetRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRulesResultToKotlin(getRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open Event Bridge service automatically. If the service has been opened, it will return opened.
     * For information about Event Bridge and how to use it, see [What is Event Bridge](https://www.alibabacloud.com/help/en/doc-detail/163239.htm).
     * > **NOTE:** Available in v1.126.0+
     * > **NOTE:** This data source supports `cn-shanghai`, `cn-hangzhou` and `ap-southeast-1` regions.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.eventbridge.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.eventbridge.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.EventBridge.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eventbridge"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := eventbridge.GetService(ctx, &eventbridge.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eventbridge.EventbridgeFunctions;
     * import com.pulumi.alicloud.eventbridge.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = EventbridgeFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:eventbridge:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the Event Bridge service that means you have read and agreed the [Event Bridge Terms of Service](https://help.aliyun.com/document_detail/163911.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eventbridge&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }
}
