@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin

import com.pulumi.alicloud.eventbridge.RuleArgs.builder
import com.pulumi.alicloud.eventbridge.kotlin.inputs.RuleTargetArgs
import com.pulumi.alicloud.eventbridge.kotlin.inputs.RuleTargetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Event Bridge Rule resource.
 * For information about Event Bridge Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/eventbridge/latest/createrule-6).
 * > **NOTE:** Available since v1.129.0.
 * ## Import
 * Event Bridge Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eventbridge/rule:Rule example <event_bus_name>:<rule_name>
 * ```
 * @property description The description of the event rule.
 * @property eventBusName The name of the event bus.
 * @property filterPattern The pattern to match interested events. Event mode, JSON format. The value description is as follows: `stringEqual` mode. `stringExpression` mode. Each field has up to 5 expressions (map structure).
 * @property ruleName The name of the event rule.
 * @property status The status of the event rule. Valid values: `ENABLE`, `DISABLE`.
 * @property targets The targets of rule. See `targets` below.
 */
public data class RuleArgs(
    public val description: Output<String>? = null,
    public val eventBusName: Output<String>? = null,
    public val filterPattern: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val status: Output<String>? = null,
    public val targets: Output<List<RuleTargetArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eventbridge.RuleArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.RuleArgs =
        com.pulumi.alicloud.eventbridge.RuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .eventBusName(eventBusName?.applyValue({ args0 -> args0 }))
            .filterPattern(filterPattern?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .targets(
                targets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleArgs].
 */
@PulumiTagMarker
public class RuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var eventBusName: Output<String>? = null

    private var filterPattern: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var status: Output<String>? = null

    private var targets: Output<List<RuleTargetArgs>>? = null

    /**
     * @param value The description of the event rule.
     */
    @JvmName("tpwgvmryeugthfuh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the event bus.
     */
    @JvmName("vxeiclnpawgsbuyl")
    public suspend fun eventBusName(`value`: Output<String>) {
        this.eventBusName = value
    }

    /**
     * @param value The pattern to match interested events. Event mode, JSON format. The value description is as follows: `stringEqual` mode. `stringExpression` mode. Each field has up to 5 expressions (map structure).
     */
    @JvmName("dyvnlohetogltvsq")
    public suspend fun filterPattern(`value`: Output<String>) {
        this.filterPattern = value
    }

    /**
     * @param value The name of the event rule.
     */
    @JvmName("mrqblrpwpygojhgv")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value The status of the event rule. Valid values: `ENABLE`, `DISABLE`.
     */
    @JvmName("jncjelikmsymkkyf")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The targets of rule. See `targets` below.
     */
    @JvmName("bpebntbkqwmacmph")
    public suspend fun targets(`value`: Output<List<RuleTargetArgs>>) {
        this.targets = value
    }

    @JvmName("qymhvgqvrvqupjhx")
    public suspend fun targets(vararg values: Output<RuleTargetArgs>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values The targets of rule. See `targets` below.
     */
    @JvmName("kjfjupvauspcytyj")
    public suspend fun targets(values: List<Output<RuleTargetArgs>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value The description of the event rule.
     */
    @JvmName("xbfvvmttlmrjmeii")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the event bus.
     */
    @JvmName("aksyttauyugoktja")
    public suspend fun eventBusName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBusName = mapped
    }

    /**
     * @param value The pattern to match interested events. Event mode, JSON format. The value description is as follows: `stringEqual` mode. `stringExpression` mode. Each field has up to 5 expressions (map structure).
     */
    @JvmName("iocptpnychnbhnsb")
    public suspend fun filterPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterPattern = mapped
    }

    /**
     * @param value The name of the event rule.
     */
    @JvmName("ktfwcblbgdfpvcqb")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value The status of the event rule. Valid values: `ENABLE`, `DISABLE`.
     */
    @JvmName("vuuvovkuqbyvuebb")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The targets of rule. See `targets` below.
     */
    @JvmName("qioorywwoqpbjvur")
    public suspend fun targets(`value`: List<RuleTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param argument The targets of rule. See `targets` below.
     */
    @JvmName("nduybkqfpjktyayy")
    public suspend fun targets(argument: List<suspend RuleTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { RuleTargetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument The targets of rule. See `targets` below.
     */
    @JvmName("pmjmhdfyvqycynew")
    public suspend fun targets(vararg argument: suspend RuleTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { RuleTargetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument The targets of rule. See `targets` below.
     */
    @JvmName("ovoiprwlyjfrmeda")
    public suspend fun targets(argument: suspend RuleTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param values The targets of rule. See `targets` below.
     */
    @JvmName("sjkfbslogkbqnfkf")
    public suspend fun targets(vararg values: RuleTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    internal fun build(): RuleArgs = RuleArgs(
        description = description,
        eventBusName = eventBusName,
        filterPattern = filterPattern,
        ruleName = ruleName,
        status = status,
        targets = targets,
    )
}
