@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Slr].
 */
@PulumiTagMarker
public class SlrResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SlrArgs = SlrArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SlrArgsBuilder.() -> Unit) {
        val builder = SlrArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Slr {
        val builtJavaResource = com.pulumi.alicloud.eventbridge.Slr(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Slr(builtJavaResource)
    }
}

public class Slr internal constructor(
    override val javaResource: com.pulumi.alicloud.eventbridge.Slr,
) : KotlinCustomResource(javaResource, SlrMapper) {
    public val productName: Output<String>
        get() = javaResource.productName().applyValue({ args0 -> args0 })
}

public object SlrMapper : ResourceMapper<Slr> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.eventbridge.Slr::class == javaResource::class

    override fun map(javaResource: Resource): Slr = Slr(
        javaResource as
            com.pulumi.alicloud.eventbridge.Slr,
    )
}

/**
 * @see [Slr].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Slr].
 */
public suspend fun slr(name: String, block: suspend SlrResourceBuilder.() -> Unit): Slr {
    val builder = SlrResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Slr].
 * @param name The _unique_ name of the resulting resource.
 */
public fun slr(name: String): Slr {
    val builder = SlrResourceBuilder()
    builder.name(name)
    return builder.build()
}
