@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin

import com.pulumi.alicloud.eventbridge.SlrArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property productName
 */
public data class SlrArgs(
    public val productName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eventbridge.SlrArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.SlrArgs =
        com.pulumi.alicloud.eventbridge.SlrArgs.builder()
            .productName(productName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SlrArgs].
 */
@PulumiTagMarker
public class SlrArgsBuilder internal constructor() {
    private var productName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("cehqcwelhidhxjos")
    public suspend fun productName(`value`: Output<String>) {
        this.productName = value
    }

    /**
     * @param value
     */
    @JvmName("jjlskuplfnluskiy")
    public suspend fun productName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productName = mapped
    }

    internal fun build(): SlrArgs = SlrArgs(
        productName = productName,
    )
}
