@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.inputs

import com.pulumi.alicloud.eventbridge.inputs.ApiDestinationHttpApiParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpoint The endpoint of the API destination.
 * @property method The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
 */
public data class ApiDestinationHttpApiParametersArgs(
    public val endpoint: Output<String>,
    public val method: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.eventbridge.inputs.ApiDestinationHttpApiParametersArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.inputs.ApiDestinationHttpApiParametersArgs = com.pulumi.alicloud.eventbridge.inputs.ApiDestinationHttpApiParametersArgs.builder()
        .endpoint(endpoint.applyValue({ args0 -> args0 }))
        .method(method.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiDestinationHttpApiParametersArgs].
 */
@PulumiTagMarker
public class ApiDestinationHttpApiParametersArgsBuilder internal constructor() {
    private var endpoint: Output<String>? = null

    private var method: Output<String>? = null

    /**
     * @param value The endpoint of the API destination.
     */
    @JvmName("ytxgwcmwocgeqwvq")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
     */
    @JvmName("ddsycpkuxbwrkblk")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value The endpoint of the API destination.
     */
    @JvmName("cfoaffysalitbfwd")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
     */
    @JvmName("sygkbvljlmobjnjh")
    public suspend fun method(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    internal fun build(): ApiDestinationHttpApiParametersArgs = ApiDestinationHttpApiParametersArgs(
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        method = method ?: throw PulumiNullFieldException("method"),
    )
}
