@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.inputs

import com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersApiKeyAuthParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiKeyName The name of the API key.
 * @property apiKeyValue The value of the API key.
 */
public data class ConnectionAuthParametersApiKeyAuthParametersArgs(
    public val apiKeyName: Output<String>? = null,
    public val apiKeyValue: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersApiKeyAuthParametersArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersApiKeyAuthParametersArgs =
        com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersApiKeyAuthParametersArgs.builder()
            .apiKeyName(apiKeyName?.applyValue({ args0 -> args0 }))
            .apiKeyValue(apiKeyValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionAuthParametersApiKeyAuthParametersArgs].
 */
@PulumiTagMarker
public class ConnectionAuthParametersApiKeyAuthParametersArgsBuilder internal constructor() {
    private var apiKeyName: Output<String>? = null

    private var apiKeyValue: Output<String>? = null

    /**
     * @param value The name of the API key.
     */
    @JvmName("nesojagalkikmsyg")
    public suspend fun apiKeyName(`value`: Output<String>) {
        this.apiKeyName = value
    }

    /**
     * @param value The value of the API key.
     */
    @JvmName("gnlfgdyejhlvdjmm")
    public suspend fun apiKeyValue(`value`: Output<String>) {
        this.apiKeyValue = value
    }

    /**
     * @param value The name of the API key.
     */
    @JvmName("aphhstsqikdujxpn")
    public suspend fun apiKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKeyName = mapped
    }

    /**
     * @param value The value of the API key.
     */
    @JvmName("kfjvcrspdcyeided")
    public suspend fun apiKeyValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKeyValue = mapped
    }

    internal fun build(): ConnectionAuthParametersApiKeyAuthParametersArgs =
        ConnectionAuthParametersApiKeyAuthParametersArgs(
            apiKeyName = apiKeyName,
            apiKeyValue = apiKeyValue,
        )
}
