@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.inputs

import com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property apiKeyAuthParameters The parameters that are configured for API key authentication. See `api_key_auth_parameters` below.
 * @property authorizationType The type of the authentication. Valid values: `API_KEY_AUTH`, `BASIC_AUTH`, `OAUTH_AUTH`.
 * @property basicAuthParameters The parameters that are configured for basic authentication. See `basic_auth_parameters` below.
 * @property oauthParameters The parameters that are configured for OAuth authentication. See `oauth_parameters` below.
 */
public data class ConnectionAuthParametersArgs(
    public val apiKeyAuthParameters: Output<ConnectionAuthParametersApiKeyAuthParametersArgs>? = null,
    public val authorizationType: Output<String>? = null,
    public val basicAuthParameters: Output<ConnectionAuthParametersBasicAuthParametersArgs>? = null,
    public val oauthParameters: Output<ConnectionAuthParametersOauthParametersArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersArgs =
        com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersArgs.builder()
            .apiKeyAuthParameters(
                apiKeyAuthParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .authorizationType(authorizationType?.applyValue({ args0 -> args0 }))
            .basicAuthParameters(
                basicAuthParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .oauthParameters(
                oauthParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectionAuthParametersArgs].
 */
@PulumiTagMarker
public class ConnectionAuthParametersArgsBuilder internal constructor() {
    private var apiKeyAuthParameters: Output<ConnectionAuthParametersApiKeyAuthParametersArgs>? = null

    private var authorizationType: Output<String>? = null

    private var basicAuthParameters: Output<ConnectionAuthParametersBasicAuthParametersArgs>? = null

    private var oauthParameters: Output<ConnectionAuthParametersOauthParametersArgs>? = null

    /**
     * @param value The parameters that are configured for API key authentication. See `api_key_auth_parameters` below.
     */
    @JvmName("ruwmvsynceoayreu")
    public suspend fun apiKeyAuthParameters(`value`: Output<ConnectionAuthParametersApiKeyAuthParametersArgs>) {
        this.apiKeyAuthParameters = value
    }

    /**
     * @param value The type of the authentication. Valid values: `API_KEY_AUTH`, `BASIC_AUTH`, `OAUTH_AUTH`.
     */
    @JvmName("kynfbcdemayommcw")
    public suspend fun authorizationType(`value`: Output<String>) {
        this.authorizationType = value
    }

    /**
     * @param value The parameters that are configured for basic authentication. See `basic_auth_parameters` below.
     */
    @JvmName("bjxaewpmplfxnrke")
    public suspend fun basicAuthParameters(`value`: Output<ConnectionAuthParametersBasicAuthParametersArgs>) {
        this.basicAuthParameters = value
    }

    /**
     * @param value The parameters that are configured for OAuth authentication. See `oauth_parameters` below.
     */
    @JvmName("dpimpmxjkhkxmkik")
    public suspend fun oauthParameters(`value`: Output<ConnectionAuthParametersOauthParametersArgs>) {
        this.oauthParameters = value
    }

    /**
     * @param value The parameters that are configured for API key authentication. See `api_key_auth_parameters` below.
     */
    @JvmName("tiaawjjegoyjtkcs")
    public suspend fun apiKeyAuthParameters(`value`: ConnectionAuthParametersApiKeyAuthParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKeyAuthParameters = mapped
    }

    /**
     * @param argument The parameters that are configured for API key authentication. See `api_key_auth_parameters` below.
     */
    @JvmName("bclggwvapmseeyjf")
    public suspend fun apiKeyAuthParameters(argument: suspend ConnectionAuthParametersApiKeyAuthParametersArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionAuthParametersApiKeyAuthParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.apiKeyAuthParameters = mapped
    }

    /**
     * @param value The type of the authentication. Valid values: `API_KEY_AUTH`, `BASIC_AUTH`, `OAUTH_AUTH`.
     */
    @JvmName("mxfwlwygnsjijigc")
    public suspend fun authorizationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationType = mapped
    }

    /**
     * @param value The parameters that are configured for basic authentication. See `basic_auth_parameters` below.
     */
    @JvmName("xpeymlrscdsdfvua")
    public suspend fun basicAuthParameters(`value`: ConnectionAuthParametersBasicAuthParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basicAuthParameters = mapped
    }

    /**
     * @param argument The parameters that are configured for basic authentication. See `basic_auth_parameters` below.
     */
    @JvmName("odwjespvjcxbulah")
    public suspend fun basicAuthParameters(argument: suspend ConnectionAuthParametersBasicAuthParametersArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionAuthParametersBasicAuthParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.basicAuthParameters = mapped
    }

    /**
     * @param value The parameters that are configured for OAuth authentication. See `oauth_parameters` below.
     */
    @JvmName("nnqqxqkaesxblrlm")
    public suspend fun oauthParameters(`value`: ConnectionAuthParametersOauthParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauthParameters = mapped
    }

    /**
     * @param argument The parameters that are configured for OAuth authentication. See `oauth_parameters` below.
     */
    @JvmName("ehxybjrovoldgxwp")
    public suspend fun oauthParameters(argument: suspend ConnectionAuthParametersOauthParametersArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionAuthParametersOauthParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.oauthParameters = mapped
    }

    internal fun build(): ConnectionAuthParametersArgs = ConnectionAuthParametersArgs(
        apiKeyAuthParameters = apiKeyAuthParameters,
        authorizationType = authorizationType,
        basicAuthParameters = basicAuthParameters,
        oauthParameters = oauthParameters,
    )
}
