@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.inputs

import com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersBasicAuthParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property password The password for basic authentication.
 * @property username The username for basic authentication.
 */
public data class ConnectionAuthParametersBasicAuthParametersArgs(
    public val password: Output<String>? = null,
    public val username: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersBasicAuthParametersArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersBasicAuthParametersArgs =
        com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersBasicAuthParametersArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionAuthParametersBasicAuthParametersArgs].
 */
@PulumiTagMarker
public class ConnectionAuthParametersBasicAuthParametersArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The password for basic authentication.
     */
    @JvmName("epdpphrylwoisrlo")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The username for basic authentication.
     */
    @JvmName("ljrwetjwgwfpmgjx")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The password for basic authentication.
     */
    @JvmName("hmdiedxoperrpkxr")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The username for basic authentication.
     */
    @JvmName("oafeyentcvsirtdu")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ConnectionAuthParametersBasicAuthParametersArgs =
        ConnectionAuthParametersBasicAuthParametersArgs(
            password = password,
            username = username,
        )
}
