@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.inputs

import com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersOauthParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationEndpoint The IP address of the authorized endpoint.
 * @property clientParameters The parameters that are configured for the client. See `client_parameters` below.
 * @property httpMethod The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
 * @property oauthHttpParameters The request parameters that are configured for OAuth authentication. See `oauth_http_parameters` below.
 */
public data class ConnectionAuthParametersOauthParametersArgs(
    public val authorizationEndpoint: Output<String>? = null,
    public val clientParameters: Output<ConnectionAuthParametersOauthParametersClientParametersArgs>? =
        null,
    public val httpMethod: Output<String>? = null,
    public val oauthHttpParameters: Output<ConnectionAuthParametersOauthParametersOauthHttpParametersArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersOauthParametersArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersOauthParametersArgs =
        com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersOauthParametersArgs.builder()
            .authorizationEndpoint(authorizationEndpoint?.applyValue({ args0 -> args0 }))
            .clientParameters(clientParameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpMethod(httpMethod?.applyValue({ args0 -> args0 }))
            .oauthHttpParameters(
                oauthHttpParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectionAuthParametersOauthParametersArgs].
 */
@PulumiTagMarker
public class ConnectionAuthParametersOauthParametersArgsBuilder internal constructor() {
    private var authorizationEndpoint: Output<String>? = null

    private var clientParameters: Output<ConnectionAuthParametersOauthParametersClientParametersArgs>? =
        null

    private var httpMethod: Output<String>? = null

    private var oauthHttpParameters:
        Output<ConnectionAuthParametersOauthParametersOauthHttpParametersArgs>? = null

    /**
     * @param value The IP address of the authorized endpoint.
     */
    @JvmName("pumvillwwtggjtpj")
    public suspend fun authorizationEndpoint(`value`: Output<String>) {
        this.authorizationEndpoint = value
    }

    /**
     * @param value The parameters that are configured for the client. See `client_parameters` below.
     */
    @JvmName("ibbgobqxtejsukrk")
    public suspend fun clientParameters(`value`: Output<ConnectionAuthParametersOauthParametersClientParametersArgs>) {
        this.clientParameters = value
    }

    /**
     * @param value The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
     */
    @JvmName("tktucdxveowcufeh")
    public suspend fun httpMethod(`value`: Output<String>) {
        this.httpMethod = value
    }

    /**
     * @param value The request parameters that are configured for OAuth authentication. See `oauth_http_parameters` below.
     */
    @JvmName("kspekbnftocdrtxj")
    public suspend fun oauthHttpParameters(`value`: Output<ConnectionAuthParametersOauthParametersOauthHttpParametersArgs>) {
        this.oauthHttpParameters = value
    }

    /**
     * @param value The IP address of the authorized endpoint.
     */
    @JvmName("iixdhnombgxcymkl")
    public suspend fun authorizationEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationEndpoint = mapped
    }

    /**
     * @param value The parameters that are configured for the client. See `client_parameters` below.
     */
    @JvmName("dhuvlssxpjewkwuk")
    public suspend fun clientParameters(`value`: ConnectionAuthParametersOauthParametersClientParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientParameters = mapped
    }

    /**
     * @param argument The parameters that are configured for the client. See `client_parameters` below.
     */
    @JvmName("cfcgayqfailyxyvn")
    public suspend fun clientParameters(argument: suspend ConnectionAuthParametersOauthParametersClientParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectionAuthParametersOauthParametersClientParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.clientParameters = mapped
    }

    /**
     * @param value The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
     */
    @JvmName("paqafcfvpcyfgvxe")
    public suspend fun httpMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpMethod = mapped
    }

    /**
     * @param value The request parameters that are configured for OAuth authentication. See `oauth_http_parameters` below.
     */
    @JvmName("xyolaojymxehqvxm")
    public suspend fun oauthHttpParameters(`value`: ConnectionAuthParametersOauthParametersOauthHttpParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauthHttpParameters = mapped
    }

    /**
     * @param argument The request parameters that are configured for OAuth authentication. See `oauth_http_parameters` below.
     */
    @JvmName("vmjjyjslohwhaani")
    public suspend fun oauthHttpParameters(argument: suspend ConnectionAuthParametersOauthParametersOauthHttpParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectionAuthParametersOauthParametersOauthHttpParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.oauthHttpParameters = mapped
    }

    internal fun build(): ConnectionAuthParametersOauthParametersArgs =
        ConnectionAuthParametersOauthParametersArgs(
            authorizationEndpoint = authorizationEndpoint,
            clientParameters = clientParameters,
            httpMethod = httpMethod,
            oauthHttpParameters = oauthHttpParameters,
        )
}
