@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.inputs

import com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersOauthParametersClientParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clientId The ID of the client.
 * @property clientSecret The AccessKey secret of the client.
 */
public data class ConnectionAuthParametersOauthParametersClientParametersArgs(
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersOauthParametersClientParametersArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersOauthParametersClientParametersArgs =
        com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersOauthParametersClientParametersArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionAuthParametersOauthParametersClientParametersArgs].
 */
@PulumiTagMarker
public class ConnectionAuthParametersOauthParametersClientParametersArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    /**
     * @param value The ID of the client.
     */
    @JvmName("cecvdgbobkhvuaor")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The AccessKey secret of the client.
     */
    @JvmName("qrbokbbgpccwmrko")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value The ID of the client.
     */
    @JvmName("elvdxjtgoewlrvsn")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The AccessKey secret of the client.
     */
    @JvmName("skhieeltortumpof")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    internal fun build(): ConnectionAuthParametersOauthParametersClientParametersArgs =
        ConnectionAuthParametersOauthParametersClientParametersArgs(
            clientId = clientId,
            clientSecret = clientSecret,
        )
}
