@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.inputs

import com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersOauthParametersOauthHttpParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property bodyParameters The parameters that are configured for the request body. See `body_parameters` below.
 * @property headerParameters The parameters that are configured for the request header. See `header_parameters` below.
 * @property queryStringParameters The parameters that are configured for the request path. See `query_string_parameters` below.
 */
public data class ConnectionAuthParametersOauthParametersOauthHttpParametersArgs(
    public val bodyParameters: Output<List<ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameterArgs>>? =
        null,
    public val headerParameters: Output<List<ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameterArgs>>? =
        null,
    public val queryStringParameters: Output<List<ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameterArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersOauthParametersOauthHttpParametersArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersOauthParametersOauthHttpParametersArgs =
        com.pulumi.alicloud.eventbridge.inputs.ConnectionAuthParametersOauthParametersOauthHttpParametersArgs.builder()
            .bodyParameters(
                bodyParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .headerParameters(
                headerParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .queryStringParameters(
                queryStringParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectionAuthParametersOauthParametersOauthHttpParametersArgs].
 */
@PulumiTagMarker
public class ConnectionAuthParametersOauthParametersOauthHttpParametersArgsBuilder internal constructor() {
    private var bodyParameters:
        Output<List<ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameterArgs>>? =
        null

    private var headerParameters:
        Output<List<ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameterArgs>>? =
        null

    private var queryStringParameters:
        Output<List<ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameterArgs>>? =
        null

    /**
     * @param value The parameters that are configured for the request body. See `body_parameters` below.
     */
    @JvmName("hikipkhrwgrdoobk")
    public suspend fun bodyParameters(`value`: Output<List<ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameterArgs>>) {
        this.bodyParameters = value
    }

    @JvmName("lwsmdkguljdedcsw")
    public suspend fun bodyParameters(vararg values: Output<ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameterArgs>) {
        this.bodyParameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters that are configured for the request body. See `body_parameters` below.
     */
    @JvmName("csmgbfuddglnjdyc")
    public suspend fun bodyParameters(values: List<Output<ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameterArgs>>) {
        this.bodyParameters = Output.all(values)
    }

    /**
     * @param value The parameters that are configured for the request header. See `header_parameters` below.
     */
    @JvmName("wcghakxlbgnugywr")
    public suspend fun headerParameters(`value`: Output<List<ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameterArgs>>) {
        this.headerParameters = value
    }

    @JvmName("msxiemvdwexcficb")
    public suspend fun headerParameters(vararg values: Output<ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameterArgs>) {
        this.headerParameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters that are configured for the request header. See `header_parameters` below.
     */
    @JvmName("fwrpqqjgqrkxnpkd")
    public suspend fun headerParameters(values: List<Output<ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameterArgs>>) {
        this.headerParameters = Output.all(values)
    }

    /**
     * @param value The parameters that are configured for the request path. See `query_string_parameters` below.
     */
    @JvmName("laojumnnfoooyuwy")
    public suspend fun queryStringParameters(`value`: Output<List<ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameterArgs>>) {
        this.queryStringParameters = value
    }

    @JvmName("atviyetkpflypcts")
    public suspend fun queryStringParameters(vararg values: Output<ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameterArgs>) {
        this.queryStringParameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters that are configured for the request path. See `query_string_parameters` below.
     */
    @JvmName("uabwbdkcvpxepnss")
    public suspend fun queryStringParameters(values: List<Output<ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameterArgs>>) {
        this.queryStringParameters = Output.all(values)
    }

    /**
     * @param value The parameters that are configured for the request body. See `body_parameters` below.
     */
    @JvmName("jvklcspxcryoggdy")
    public suspend fun bodyParameters(`value`: List<ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bodyParameters = mapped
    }

    /**
     * @param argument The parameters that are configured for the request body. See `body_parameters` below.
     */
    @JvmName("ilxyxkpmbqixvlba")
    public suspend fun bodyParameters(argument: List<suspend ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bodyParameters = mapped
    }

    /**
     * @param argument The parameters that are configured for the request body. See `body_parameters` below.
     */
    @JvmName("pmalmcpvhlptkmgp")
    public suspend fun bodyParameters(vararg argument: suspend ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bodyParameters = mapped
    }

    /**
     * @param argument The parameters that are configured for the request body. See `body_parameters` below.
     */
    @JvmName("lmwgoyixlmfdgcsr")
    public suspend fun bodyParameters(argument: suspend ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.bodyParameters = mapped
    }

    /**
     * @param values The parameters that are configured for the request body. See `body_parameters` below.
     */
    @JvmName("qjicijjunkpxjklr")
    public suspend fun bodyParameters(vararg values: ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bodyParameters = mapped
    }

    /**
     * @param value The parameters that are configured for the request header. See `header_parameters` below.
     */
    @JvmName("xmqpyvktpptyluca")
    public suspend fun headerParameters(`value`: List<ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerParameters = mapped
    }

    /**
     * @param argument The parameters that are configured for the request header. See `header_parameters` below.
     */
    @JvmName("wqkryslmllcrdnrj")
    public suspend fun headerParameters(argument: List<suspend ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerParameters = mapped
    }

    /**
     * @param argument The parameters that are configured for the request header. See `header_parameters` below.
     */
    @JvmName("rqkclbwqqqfdtdmo")
    public suspend fun headerParameters(vararg argument: suspend ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerParameters = mapped
    }

    /**
     * @param argument The parameters that are configured for the request header. See `header_parameters` below.
     */
    @JvmName("bbimjsxxadsorhtc")
    public suspend fun headerParameters(argument: suspend ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headerParameters = mapped
    }

    /**
     * @param values The parameters that are configured for the request header. See `header_parameters` below.
     */
    @JvmName("nucxvucxdhsbdtaa")
    public suspend fun headerParameters(vararg values: ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerParameters = mapped
    }

    /**
     * @param value The parameters that are configured for the request path. See `query_string_parameters` below.
     */
    @JvmName("vtrclomgilwbklur")
    public suspend fun queryStringParameters(`value`: List<ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStringParameters = mapped
    }

    /**
     * @param argument The parameters that are configured for the request path. See `query_string_parameters` below.
     */
    @JvmName("bywkjnlskecrpdla")
    public suspend fun queryStringParameters(argument: List<suspend ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queryStringParameters = mapped
    }

    /**
     * @param argument The parameters that are configured for the request path. See `query_string_parameters` below.
     */
    @JvmName("jihitmuhuhvtlngh")
    public suspend fun queryStringParameters(vararg argument: suspend ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queryStringParameters = mapped
    }

    /**
     * @param argument The parameters that are configured for the request path. See `query_string_parameters` below.
     */
    @JvmName("ltbhhflpjgxqhdcw")
    public suspend fun queryStringParameters(argument: suspend ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.queryStringParameters = mapped
    }

    /**
     * @param values The parameters that are configured for the request path. See `query_string_parameters` below.
     */
    @JvmName("sdcvxpsalfyhcgyf")
    public suspend fun queryStringParameters(vararg values: ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringParameters = mapped
    }

    internal fun build(): ConnectionAuthParametersOauthParametersOauthHttpParametersArgs =
        ConnectionAuthParametersOauthParametersOauthHttpParametersArgs(
            bodyParameters = bodyParameters,
            headerParameters = headerParameters,
            queryStringParameters = queryStringParameters,
        )
}
