@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.inputs

import com.pulumi.alicloud.eventbridge.inputs.ConnectionNetworkParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkType The network type. Valid values: `PublicNetwork`, `PrivateNetwork`. **NOTE:** If you set `network_type` to `PrivateNetwork`, you must configure `vpc_id`, `vswitche_id`, and `security_group_id`.
 * @property securityGroupId The ID of the security group.
 * @property vpcId The ID of the VPC.
 * @property vswitcheId The ID of the VSwitch.
 */
public data class ConnectionNetworkParametersArgs(
    public val networkType: Output<String>,
    public val securityGroupId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitcheId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eventbridge.inputs.ConnectionNetworkParametersArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.inputs.ConnectionNetworkParametersArgs =
        com.pulumi.alicloud.eventbridge.inputs.ConnectionNetworkParametersArgs.builder()
            .networkType(networkType.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitcheId(vswitcheId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionNetworkParametersArgs].
 */
@PulumiTagMarker
public class ConnectionNetworkParametersArgsBuilder internal constructor() {
    private var networkType: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitcheId: Output<String>? = null

    /**
     * @param value The network type. Valid values: `PublicNetwork`, `PrivateNetwork`. **NOTE:** If you set `network_type` to `PrivateNetwork`, you must configure `vpc_id`, `vswitche_id`, and `security_group_id`.
     */
    @JvmName("wjbwjyphyampbjhd")
    public suspend fun networkType(`value`: Output<String>) {
        this.networkType = value
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("egopefeloepekpyp")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("xqrceuplcvtnfkpl")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the VSwitch.
     */
    @JvmName("vuoacsbarwemmeqr")
    public suspend fun vswitcheId(`value`: Output<String>) {
        this.vswitcheId = value
    }

    /**
     * @param value The network type. Valid values: `PublicNetwork`, `PrivateNetwork`. **NOTE:** If you set `network_type` to `PrivateNetwork`, you must configure `vpc_id`, `vswitche_id`, and `security_group_id`.
     */
    @JvmName("vqwrvnksaubkloip")
    public suspend fun networkType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("kkahycsmqxybbfxo")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("eeevnwxlrnocrdso")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of the VSwitch.
     */
    @JvmName("mracnaqiqrkxpghw")
    public suspend fun vswitcheId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitcheId = mapped
    }

    internal fun build(): ConnectionNetworkParametersArgs = ConnectionNetworkParametersArgs(
        networkType = networkType ?: throw PulumiNullFieldException("networkType"),
        securityGroupId = securityGroupId,
        vpcId = vpcId,
        vswitcheId = vswitcheId,
    )
}
