@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.inputs

import com.pulumi.alicloud.eventbridge.inputs.GetEventBusesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEventBuses.
 * @property eventBusType The event bus type.
 * @property ids A list of Event Bus IDs. Its element value is same as Event Bus Name.
 * @property namePrefix The name prefix.
 * @property nameRegex A regex string to filter results by Event Bus name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetEventBusesPlainArgs(
    public val eventBusType: String? = null,
    public val ids: List<String>? = null,
    public val namePrefix: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eventbridge.inputs.GetEventBusesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.inputs.GetEventBusesPlainArgs =
        com.pulumi.alicloud.eventbridge.inputs.GetEventBusesPlainArgs.builder()
            .eventBusType(eventBusType?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .namePrefix(namePrefix?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEventBusesPlainArgs].
 */
@PulumiTagMarker
public class GetEventBusesPlainArgsBuilder internal constructor() {
    private var eventBusType: String? = null

    private var ids: List<String>? = null

    private var namePrefix: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The event bus type.
     */
    @JvmName("fmvxpobjyfxsgyuw")
    public suspend fun eventBusType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.eventBusType = mapped
    }

    /**
     * @param value A list of Event Bus IDs. Its element value is same as Event Bus Name.
     */
    @JvmName("kgjxuylvaegrlrff")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Event Bus IDs. Its element value is same as Event Bus Name.
     */
    @JvmName("udirvrfruxbdgwlk")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The name prefix.
     */
    @JvmName("ikrbdpmxkousdhjb")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namePrefix = mapped
    }

    /**
     * @param value A regex string to filter results by Event Bus name.
     */
    @JvmName("mniuohlwoxscvuks")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("njtnciresgawlkww")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetEventBusesPlainArgs = GetEventBusesPlainArgs(
        eventBusType = eventBusType,
        ids = ids,
        namePrefix = namePrefix,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
