@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.inputs

import com.pulumi.alicloud.eventbridge.inputs.GetRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRules.
 * @property eventBusName The name of event bus.
 * @property ids A list of Rule IDs.
 * @property nameRegex A regex string to filter results by Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property ruleNamePrefix The rule name prefix.
 * @property status Rule status, either Enable or Disable. Valid values: `DISABLE`, `ENABLE`.
 */
public data class GetRulesPlainArgs(
    public val eventBusName: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val ruleNamePrefix: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eventbridge.inputs.GetRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.inputs.GetRulesPlainArgs =
        com.pulumi.alicloud.eventbridge.inputs.GetRulesPlainArgs.builder()
            .eventBusName(eventBusName.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .ruleNamePrefix(ruleNamePrefix?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRulesPlainArgs].
 */
@PulumiTagMarker
public class GetRulesPlainArgsBuilder internal constructor() {
    private var eventBusName: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var ruleNamePrefix: String? = null

    private var status: String? = null

    /**
     * @param value The name of event bus.
     */
    @JvmName("gttantoxopbcignb")
    public suspend fun eventBusName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventBusName = mapped
    }

    /**
     * @param value A list of Rule IDs.
     */
    @JvmName("rsbfyeqphrnkyuhm")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Rule IDs.
     */
    @JvmName("bsmymaufttrffnln")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Rule name.
     */
    @JvmName("hwfqisueutxgotlx")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ualmltbidsumlwuw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The rule name prefix.
     */
    @JvmName("jbjftcpcjgqgowig")
    public suspend fun ruleNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ruleNamePrefix = mapped
    }

    /**
     * @param value Rule status, either Enable or Disable. Valid values: `DISABLE`, `ENABLE`.
     */
    @JvmName("fsogosyfwcjbvgnv")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetRulesPlainArgs = GetRulesPlainArgs(
        eventBusName = eventBusName ?: throw PulumiNullFieldException("eventBusName"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        ruleNamePrefix = ruleNamePrefix,
        status = status,
    )
}
