@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.inputs

import com.pulumi.alicloud.eventbridge.inputs.RuleTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property deadLetterQueue The dead letter queue. Events that are not processed or exceed the number of retries will be written to the dead letter. Support message service MNS and message queue RocketMQ. See `dead_letter_queue` below.
 * @property endpoint The endpoint of the event target.
 * @property paramLists The parameters that are configured for the event target. See `param_list` below.
 * @property pushRetryStrategy The retry policy that is used to push the event. Valid values:
 * - `BACKOFF_RETRY`: Backoff retry. The request can be retried up to three times. The interval between two consecutive retries is a random value between 10 and 20 seconds.
 * - `EXPONENTIAL_DECAY_RETRY`: Exponential decay retry. The request can be retried up to 176 times. The interval between two consecutive retries exponentially increases to 512 seconds, and the total retry time is one day. The specific retry intervals are 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 512, ..., and 512 seconds, including a maximum of one hundred and sixty-seven 512 seconds in total.
 * @property targetId The ID of the custom event target.
 * @property type The type of the event target. Valid values: `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.dingtalk`, `acs.eventbridge`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fc.function`, `acs.fnf`, `acs.k8s`, `acs.mail`, `acs.mns.queue`, `acs.mns.topic`, `acs.openapi`, `acs.rabbitmq`, `acs.rds.mysql`, `acs.rocketmq`, `acs.sae`, `acs.sls`, `acs.sms`, `http`,`https` and `mysql`.
 * **NOTE:** From version 1.208.1, `type` can be set to `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fnf`, `acs.k8s`, `acs.openapi`, `acs.rds.mysql`, `acs.sae`, `acs.sls`, `mysql`.
 */
public data class RuleTargetArgs(
    public val deadLetterQueue: Output<RuleTargetDeadLetterQueueArgs>? = null,
    public val endpoint: Output<String>,
    public val paramLists: Output<List<RuleTargetParamListArgs>>,
    public val pushRetryStrategy: Output<String>? = null,
    public val targetId: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.eventbridge.inputs.RuleTargetArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.inputs.RuleTargetArgs =
        com.pulumi.alicloud.eventbridge.inputs.RuleTargetArgs.builder()
            .deadLetterQueue(deadLetterQueue?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .paramLists(
                paramLists.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .pushRetryStrategy(pushRetryStrategy?.applyValue({ args0 -> args0 }))
            .targetId(targetId.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleTargetArgs].
 */
@PulumiTagMarker
public class RuleTargetArgsBuilder internal constructor() {
    private var deadLetterQueue: Output<RuleTargetDeadLetterQueueArgs>? = null

    private var endpoint: Output<String>? = null

    private var paramLists: Output<List<RuleTargetParamListArgs>>? = null

    private var pushRetryStrategy: Output<String>? = null

    private var targetId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The dead letter queue. Events that are not processed or exceed the number of retries will be written to the dead letter. Support message service MNS and message queue RocketMQ. See `dead_letter_queue` below.
     */
    @JvmName("fwfslyjqsgtqhxun")
    public suspend fun deadLetterQueue(`value`: Output<RuleTargetDeadLetterQueueArgs>) {
        this.deadLetterQueue = value
    }

    /**
     * @param value The endpoint of the event target.
     */
    @JvmName("pdwpfoowywqwjbni")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The parameters that are configured for the event target. See `param_list` below.
     */
    @JvmName("jalevtcyeevtdxft")
    public suspend fun paramLists(`value`: Output<List<RuleTargetParamListArgs>>) {
        this.paramLists = value
    }

    @JvmName("omivcxsmvschvdec")
    public suspend fun paramLists(vararg values: Output<RuleTargetParamListArgs>) {
        this.paramLists = Output.all(values.asList())
    }

    /**
     * @param values The parameters that are configured for the event target. See `param_list` below.
     */
    @JvmName("ctwrrrgncrvhhgre")
    public suspend fun paramLists(values: List<Output<RuleTargetParamListArgs>>) {
        this.paramLists = Output.all(values)
    }

    /**
     * @param value The retry policy that is used to push the event. Valid values:
     * - `BACKOFF_RETRY`: Backoff retry. The request can be retried up to three times. The interval between two consecutive retries is a random value between 10 and 20 seconds.
     * - `EXPONENTIAL_DECAY_RETRY`: Exponential decay retry. The request can be retried up to 176 times. The interval between two consecutive retries exponentially increases to 512 seconds, and the total retry time is one day. The specific retry intervals are 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 512, ..., and 512 seconds, including a maximum of one hundred and sixty-seven 512 seconds in total.
     */
    @JvmName("chijiocxmsywovvj")
    public suspend fun pushRetryStrategy(`value`: Output<String>) {
        this.pushRetryStrategy = value
    }

    /**
     * @param value The ID of the custom event target.
     */
    @JvmName("abfodmebfepicfar")
    public suspend fun targetId(`value`: Output<String>) {
        this.targetId = value
    }

    /**
     * @param value The type of the event target. Valid values: `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.dingtalk`, `acs.eventbridge`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fc.function`, `acs.fnf`, `acs.k8s`, `acs.mail`, `acs.mns.queue`, `acs.mns.topic`, `acs.openapi`, `acs.rabbitmq`, `acs.rds.mysql`, `acs.rocketmq`, `acs.sae`, `acs.sls`, `acs.sms`, `http`,`https` and `mysql`.
     * **NOTE:** From version 1.208.1, `type` can be set to `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fnf`, `acs.k8s`, `acs.openapi`, `acs.rds.mysql`, `acs.sae`, `acs.sls`, `mysql`.
     */
    @JvmName("nsblfkqssolprkgr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The dead letter queue. Events that are not processed or exceed the number of retries will be written to the dead letter. Support message service MNS and message queue RocketMQ. See `dead_letter_queue` below.
     */
    @JvmName("eqklebnkmgoqmlbd")
    public suspend fun deadLetterQueue(`value`: RuleTargetDeadLetterQueueArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterQueue = mapped
    }

    /**
     * @param argument The dead letter queue. Events that are not processed or exceed the number of retries will be written to the dead letter. Support message service MNS and message queue RocketMQ. See `dead_letter_queue` below.
     */
    @JvmName("qtxsuskxuqkqqslf")
    public suspend fun deadLetterQueue(argument: suspend RuleTargetDeadLetterQueueArgsBuilder.() -> Unit) {
        val toBeMapped = RuleTargetDeadLetterQueueArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deadLetterQueue = mapped
    }

    /**
     * @param value The endpoint of the event target.
     */
    @JvmName("dkpmxqeflmbjtvbt")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The parameters that are configured for the event target. See `param_list` below.
     */
    @JvmName("xlxgdqxywwtplomf")
    public suspend fun paramLists(`value`: List<RuleTargetParamListArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paramLists = mapped
    }

    /**
     * @param argument The parameters that are configured for the event target. See `param_list` below.
     */
    @JvmName("iofjvldugrhexrth")
    public suspend fun paramLists(argument: List<suspend RuleTargetParamListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleTargetParamListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.paramLists = mapped
    }

    /**
     * @param argument The parameters that are configured for the event target. See `param_list` below.
     */
    @JvmName("mvoluquvuewabbsc")
    public suspend fun paramLists(vararg argument: suspend RuleTargetParamListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleTargetParamListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.paramLists = mapped
    }

    /**
     * @param argument The parameters that are configured for the event target. See `param_list` below.
     */
    @JvmName("dfkyhppotbfiodtx")
    public suspend fun paramLists(argument: suspend RuleTargetParamListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleTargetParamListArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.paramLists = mapped
    }

    /**
     * @param values The parameters that are configured for the event target. See `param_list` below.
     */
    @JvmName("qoeyfnhhrmauelmh")
    public suspend fun paramLists(vararg values: RuleTargetParamListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paramLists = mapped
    }

    /**
     * @param value The retry policy that is used to push the event. Valid values:
     * - `BACKOFF_RETRY`: Backoff retry. The request can be retried up to three times. The interval between two consecutive retries is a random value between 10 and 20 seconds.
     * - `EXPONENTIAL_DECAY_RETRY`: Exponential decay retry. The request can be retried up to 176 times. The interval between two consecutive retries exponentially increases to 512 seconds, and the total retry time is one day. The specific retry intervals are 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 512, ..., and 512 seconds, including a maximum of one hundred and sixty-seven 512 seconds in total.
     */
    @JvmName("fyynjvtgasjfvwce")
    public suspend fun pushRetryStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushRetryStrategy = mapped
    }

    /**
     * @param value The ID of the custom event target.
     */
    @JvmName("uuuwnjyfsdryxptw")
    public suspend fun targetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetId = mapped
    }

    /**
     * @param value The type of the event target. Valid values: `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.dingtalk`, `acs.eventbridge`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fc.function`, `acs.fnf`, `acs.k8s`, `acs.mail`, `acs.mns.queue`, `acs.mns.topic`, `acs.openapi`, `acs.rabbitmq`, `acs.rds.mysql`, `acs.rocketmq`, `acs.sae`, `acs.sls`, `acs.sms`, `http`,`https` and `mysql`.
     * **NOTE:** From version 1.208.1, `type` can be set to `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fnf`, `acs.k8s`, `acs.openapi`, `acs.rds.mysql`, `acs.sae`, `acs.sls`, `mysql`.
     */
    @JvmName("roinasupvjudirei")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RuleTargetArgs = RuleTargetArgs(
        deadLetterQueue = deadLetterQueue,
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        paramLists = paramLists ?: throw PulumiNullFieldException("paramLists"),
        pushRetryStrategy = pushRetryStrategy,
        targetId = targetId ?: throw PulumiNullFieldException("targetId"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
