@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.inputs

import com.pulumi.alicloud.eventbridge.inputs.RuleTargetDeadLetterQueueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Alibaba Cloud Resource Name (ARN) of the dead letter queue. Events that are not processed or whose maximum retries are exceeded are written to the dead-letter queue. The ARN feature is supported by the following queue types: MNS and Message Queue for Apache RocketMQ.
 */
public data class RuleTargetDeadLetterQueueArgs(
    public val arn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eventbridge.inputs.RuleTargetDeadLetterQueueArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.inputs.RuleTargetDeadLetterQueueArgs =
        com.pulumi.alicloud.eventbridge.inputs.RuleTargetDeadLetterQueueArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleTargetDeadLetterQueueArgs].
 */
@PulumiTagMarker
public class RuleTargetDeadLetterQueueArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of the dead letter queue. Events that are not processed or whose maximum retries are exceeded are written to the dead-letter queue. The ARN feature is supported by the following queue types: MNS and Message Queue for Apache RocketMQ.
     */
    @JvmName("foybkvtpcsrrdrnr")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of the dead letter queue. Events that are not processed or whose maximum retries are exceeded are written to the dead-letter queue. The ARN feature is supported by the following queue types: MNS and Message Queue for Apache RocketMQ.
     */
    @JvmName("jpryumcuotrmaoeu")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    internal fun build(): RuleTargetDeadLetterQueueArgs = RuleTargetDeadLetterQueueArgs(
        arn = arn,
    )
}
