@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.inputs

import com.pulumi.alicloud.eventbridge.inputs.RuleTargetParamListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property form The format of the event target parameter. Valid values: `ORIGINAL`, `TEMPLATE`, `JSONPATH`, `CONSTANT`.
 * @property resourceKey The resource parameter of the event target. For more information, see [How to use it](https://www.alibabacloud.com/help/en/eventbridge/latest/event-target-parameters)
 * @property template The template of the event target parameter.
 * @property value The value of the event target parameter.
 * > **NOTE:** There exists a potential diff error that the backend service will return a default param as following:
 * ```
 * param_list {
 * resource_key = "IsBase64Encode"
 * form         = "CONSTANT"
 * value        = "false"
 * template     = ""
 * }
 * ```
 * In order to fix the diff, from version 1.160.0, this resource has removed the param which `resource_key = "IsBase64Encode"` and `value = "false"`.
 * If you want to set `resource_key = "IsBase64Encode"`, please avoid to set `value = "false"`.
 */
public data class RuleTargetParamListArgs(
    public val form: Output<String>,
    public val resourceKey: Output<String>,
    public val template: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eventbridge.inputs.RuleTargetParamListArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.inputs.RuleTargetParamListArgs =
        com.pulumi.alicloud.eventbridge.inputs.RuleTargetParamListArgs.builder()
            .form(form.applyValue({ args0 -> args0 }))
            .resourceKey(resourceKey.applyValue({ args0 -> args0 }))
            .template(template?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleTargetParamListArgs].
 */
@PulumiTagMarker
public class RuleTargetParamListArgsBuilder internal constructor() {
    private var form: Output<String>? = null

    private var resourceKey: Output<String>? = null

    private var template: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The format of the event target parameter. Valid values: `ORIGINAL`, `TEMPLATE`, `JSONPATH`, `CONSTANT`.
     */
    @JvmName("frxperskevjufrmq")
    public suspend fun form(`value`: Output<String>) {
        this.form = value
    }

    /**
     * @param value The resource parameter of the event target. For more information, see [How to use it](https://www.alibabacloud.com/help/en/eventbridge/latest/event-target-parameters)
     */
    @JvmName("rqyivqsessmflfln")
    public suspend fun resourceKey(`value`: Output<String>) {
        this.resourceKey = value
    }

    /**
     * @param value The template of the event target parameter.
     */
    @JvmName("vwqdqhhwidxjavls")
    public suspend fun template(`value`: Output<String>) {
        this.template = value
    }

    /**
     * @param value The value of the event target parameter.
     * > **NOTE:** There exists a potential diff error that the backend service will return a default param as following:
     * ```
     * param_list {
     * resource_key = "IsBase64Encode"
     * form         = "CONSTANT"
     * value        = "false"
     * template     = ""
     * }
     * ```
     * In order to fix the diff, from version 1.160.0, this resource has removed the param which `resource_key = "IsBase64Encode"` and `value = "false"`.
     * If you want to set `resource_key = "IsBase64Encode"`, please avoid to set `value = "false"`.
     */
    @JvmName("oknmsrscpxrqnyer")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The format of the event target parameter. Valid values: `ORIGINAL`, `TEMPLATE`, `JSONPATH`, `CONSTANT`.
     */
    @JvmName("atakoaadjdbkbawj")
    public suspend fun form(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.form = mapped
    }

    /**
     * @param value The resource parameter of the event target. For more information, see [How to use it](https://www.alibabacloud.com/help/en/eventbridge/latest/event-target-parameters)
     */
    @JvmName("cdnkfwfuwmpwsgoo")
    public suspend fun resourceKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceKey = mapped
    }

    /**
     * @param value The template of the event target parameter.
     */
    @JvmName("nebqflcgwmevcwed")
    public suspend fun template(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.template = mapped
    }

    /**
     * @param value The value of the event target parameter.
     * > **NOTE:** There exists a potential diff error that the backend service will return a default param as following:
     * ```
     * param_list {
     * resource_key = "IsBase64Encode"
     * form         = "CONSTANT"
     * value        = "false"
     * template     = ""
     * }
     * ```
     * In order to fix the diff, from version 1.160.0, this resource has removed the param which `resource_key = "IsBase64Encode"` and `value = "false"`.
     * If you want to set `resource_key = "IsBase64Encode"`, please avoid to set `value = "false"`.
     */
    @JvmName("lesjdboqyumqtewa")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): RuleTargetParamListArgs = RuleTargetParamListArgs(
        form = form ?: throw PulumiNullFieldException("form"),
        resourceKey = resourceKey ?: throw PulumiNullFieldException("resourceKey"),
        template = template,
        `value` = `value`,
    )
}
