@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endpoint The endpoint of the API destination.
 * @property method The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
 */
public data class ApiDestinationHttpApiParameters(
    public val endpoint: String,
    public val method: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eventbridge.outputs.ApiDestinationHttpApiParameters): ApiDestinationHttpApiParameters = ApiDestinationHttpApiParameters(
            endpoint = javaType.endpoint(),
            method = javaType.method(),
        )
    }
}
