@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property apiKeyAuthParameters The parameters that are configured for API key authentication. See `api_key_auth_parameters` below.
 * @property authorizationType The type of the authentication. Valid values: `API_KEY_AUTH`, `BASIC_AUTH`, `OAUTH_AUTH`.
 * @property basicAuthParameters The parameters that are configured for basic authentication. See `basic_auth_parameters` below.
 * @property oauthParameters The parameters that are configured for OAuth authentication. See `oauth_parameters` below.
 */
public data class ConnectionAuthParameters(
    public val apiKeyAuthParameters: ConnectionAuthParametersApiKeyAuthParameters? = null,
    public val authorizationType: String? = null,
    public val basicAuthParameters: ConnectionAuthParametersBasicAuthParameters? = null,
    public val oauthParameters: ConnectionAuthParametersOauthParameters? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eventbridge.outputs.ConnectionAuthParameters): ConnectionAuthParameters = ConnectionAuthParameters(
            apiKeyAuthParameters = javaType.apiKeyAuthParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eventbridge.kotlin.outputs.ConnectionAuthParametersApiKeyAuthParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            authorizationType = javaType.authorizationType().map({ args0 -> args0 }).orElse(null),
            basicAuthParameters = javaType.basicAuthParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eventbridge.kotlin.outputs.ConnectionAuthParametersBasicAuthParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            oauthParameters = javaType.oauthParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eventbridge.kotlin.outputs.ConnectionAuthParametersOauthParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
