@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property apiKeyName The name of the API key.
 * @property apiKeyValue The value of the API key.
 */
public data class ConnectionAuthParametersApiKeyAuthParameters(
    public val apiKeyName: String? = null,
    public val apiKeyValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eventbridge.outputs.ConnectionAuthParametersApiKeyAuthParameters): ConnectionAuthParametersApiKeyAuthParameters = ConnectionAuthParametersApiKeyAuthParameters(
            apiKeyName = javaType.apiKeyName().map({ args0 -> args0 }).orElse(null),
            apiKeyValue = javaType.apiKeyValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
