@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authorizationEndpoint The IP address of the authorized endpoint.
 * @property clientParameters The parameters that are configured for the client. See `client_parameters` below.
 * @property httpMethod The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
 * @property oauthHttpParameters The request parameters that are configured for OAuth authentication. See `oauth_http_parameters` below.
 */
public data class ConnectionAuthParametersOauthParameters(
    public val authorizationEndpoint: String? = null,
    public val clientParameters: ConnectionAuthParametersOauthParametersClientParameters? = null,
    public val httpMethod: String? = null,
    public val oauthHttpParameters: ConnectionAuthParametersOauthParametersOauthHttpParameters? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eventbridge.outputs.ConnectionAuthParametersOauthParameters): ConnectionAuthParametersOauthParameters = ConnectionAuthParametersOauthParameters(
            authorizationEndpoint = javaType.authorizationEndpoint().map({ args0 -> args0 }).orElse(null),
            clientParameters = javaType.clientParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eventbridge.kotlin.outputs.ConnectionAuthParametersOauthParametersClientParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            httpMethod = javaType.httpMethod().map({ args0 -> args0 }).orElse(null),
            oauthHttpParameters = javaType.oauthHttpParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eventbridge.kotlin.outputs.ConnectionAuthParametersOauthParametersOauthHttpParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
