@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bodyParameters The parameters that are configured for the request body. See `body_parameters` below.
 * @property headerParameters The parameters that are configured for the request header. See `header_parameters` below.
 * @property queryStringParameters The parameters that are configured for the request path. See `query_string_parameters` below.
 */
public data class ConnectionAuthParametersOauthParametersOauthHttpParameters(
    public val bodyParameters: List<ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter>? = null,
    public val headerParameters: List<ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter>? = null,
    public val queryStringParameters: List<ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eventbridge.outputs.ConnectionAuthParametersOauthParametersOauthHttpParameters): ConnectionAuthParametersOauthParametersOauthHttpParameters =
            ConnectionAuthParametersOauthParametersOauthHttpParameters(
                bodyParameters = javaType.bodyParameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.eventbridge.kotlin.outputs.ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter.Companion.toKotlin(args0)
                    })
                }),
                headerParameters = javaType.headerParameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.eventbridge.kotlin.outputs.ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter.Companion.toKotlin(args0)
                    })
                }),
                queryStringParameters = javaType.queryStringParameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.eventbridge.kotlin.outputs.ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
