@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property networkType The network type. Valid values: `PublicNetwork`, `PrivateNetwork`. **NOTE:** If you set `network_type` to `PrivateNetwork`, you must configure `vpc_id`, `vswitche_id`, and `security_group_id`.
 * @property securityGroupId The ID of the security group.
 * @property vpcId The ID of the VPC.
 * @property vswitcheId The ID of the VSwitch.
 */
public data class ConnectionNetworkParameters(
    public val networkType: String,
    public val securityGroupId: String? = null,
    public val vpcId: String? = null,
    public val vswitcheId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eventbridge.outputs.ConnectionNetworkParameters): ConnectionNetworkParameters = ConnectionNetworkParameters(
            networkType = javaType.networkType(),
            securityGroupId = javaType.securityGroupId().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vswitcheId = javaType.vswitcheId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
