@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The time of this bus was created.
 * @property description The description of event bus.
 * @property eventBusName The name of event bus.
 * @property id The ID of the Event Bus. Its value is same as Queue Name.
 */
public data class GetEventBusesBus(
    public val createTime: String,
    public val description: String,
    public val eventBusName: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eventbridge.outputs.GetEventBusesBus): GetEventBusesBus = GetEventBusesBus(
            createTime = javaType.createTime(),
            description = javaType.description(),
            eventBusName = javaType.eventBusName(),
            id = javaType.id(),
        )
    }
}
