@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEventBuses.
 * @property buses
 * @property eventBusType
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property namePrefix
 * @property nameRegex
 * @property names
 * @property outputFile
 */
public data class GetEventBusesResult(
    public val buses: List<GetEventBusesBus>,
    public val eventBusType: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val namePrefix: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eventbridge.outputs.GetEventBusesResult): GetEventBusesResult = GetEventBusesResult(
            buses = javaType.buses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eventbridge.kotlin.outputs.GetEventBusesBus.Companion.toKotlin(args0)
                })
            }),
            eventBusType = javaType.eventBusType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            namePrefix = javaType.namePrefix().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
