@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property description The detail describe of event source.
 * @property eventSourceName The code name of event source.
 * @property externalSourceConfig The config of external data source.
 * @property externalSourceType The type of external data source.
 * @property id The ID of the Event Source.
 * @property linkedExternalSource Whether to connect to an external data source.
 * @property type
 */
public data class GetEventSourcesSource(
    public val description: String,
    public val eventSourceName: String,
    public val externalSourceConfig: Map<String, String>,
    public val externalSourceType: String,
    public val id: String,
    public val linkedExternalSource: Boolean,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eventbridge.outputs.GetEventSourcesSource): GetEventSourcesSource = GetEventSourcesSource(
            description = javaType.description(),
            eventSourceName = javaType.eventSourceName(),
            externalSourceConfig = javaType.externalSourceConfig().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            externalSourceType = javaType.externalSourceType(),
            id = javaType.id(),
            linkedExternalSource = javaType.linkedExternalSource(),
            type = javaType.type(),
        )
    }
}
