@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRules.
 * @property eventBusName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property ruleNamePrefix
 * @property rules
 * @property status
 */
public data class GetRulesResult(
    public val eventBusName: String,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val ruleNamePrefix: String? = null,
    public val rules: List<GetRulesRule>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eventbridge.outputs.GetRulesResult): GetRulesResult = GetRulesResult(
            eventBusName = javaType.eventBusName(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            ruleNamePrefix = javaType.ruleNamePrefix().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eventbridge.kotlin.outputs.GetRulesRule.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
