@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property description The description of rule.
 * @property eventBusName The name of event bus.
 * @property filterPattern The pattern to match interested events.
 * @property id The ID of the Rule.
 * @property ruleName The name of rule.
 * @property status Rule status, either Enable or Disable.
 * @property targets The target for rule.
 */
public data class GetRulesRule(
    public val description: String,
    public val eventBusName: String,
    public val filterPattern: String,
    public val id: String,
    public val ruleName: String,
    public val status: String,
    public val targets: List<GetRulesRuleTarget>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eventbridge.outputs.GetRulesRule): GetRulesRule = GetRulesRule(
            description = javaType.description(),
            eventBusName = javaType.eventBusName(),
            filterPattern = javaType.filterPattern(),
            id = javaType.id(),
            ruleName = javaType.ruleName(),
            status = javaType.status(),
            targets = javaType.targets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eventbridge.kotlin.outputs.GetRulesRuleTarget.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
