@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property deadLetterQueue The dead letter queue. Events that are not processed or exceed the number of retries will be written to the dead letter. Support message service MNS and message queue RocketMQ. See `dead_letter_queue` below.
 * @property endpoint The endpoint of the event target.
 * @property paramLists The parameters that are configured for the event target. See `param_list` below.
 * @property pushRetryStrategy The retry policy that is used to push the event. Valid values:
 * - `BACKOFF_RETRY`: Backoff retry. The request can be retried up to three times. The interval between two consecutive retries is a random value between 10 and 20 seconds.
 * - `EXPONENTIAL_DECAY_RETRY`: Exponential decay retry. The request can be retried up to 176 times. The interval between two consecutive retries exponentially increases to 512 seconds, and the total retry time is one day. The specific retry intervals are 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 512, ..., and 512 seconds, including a maximum of one hundred and sixty-seven 512 seconds in total.
 * @property targetId The ID of the custom event target.
 * @property type The type of the event target. Valid values: `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.dingtalk`, `acs.eventbridge`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fc.function`, `acs.fnf`, `acs.k8s`, `acs.mail`, `acs.mns.queue`, `acs.mns.topic`, `acs.openapi`, `acs.rabbitmq`, `acs.rds.mysql`, `acs.rocketmq`, `acs.sae`, `acs.sls`, `acs.sms`, `http`,`https` and `mysql`.
 * **NOTE:** From version 1.208.1, `type` can be set to `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fnf`, `acs.k8s`, `acs.openapi`, `acs.rds.mysql`, `acs.sae`, `acs.sls`, `mysql`.
 */
public data class RuleTarget(
    public val deadLetterQueue: RuleTargetDeadLetterQueue? = null,
    public val endpoint: String,
    public val paramLists: List<RuleTargetParamList>,
    public val pushRetryStrategy: String? = null,
    public val targetId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eventbridge.outputs.RuleTarget): RuleTarget =
            RuleTarget(
                deadLetterQueue = javaType.deadLetterQueue().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.eventbridge.kotlin.outputs.RuleTargetDeadLetterQueue.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                endpoint = javaType.endpoint(),
                paramLists = javaType.paramLists().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.eventbridge.kotlin.outputs.RuleTargetParamList.Companion.toKotlin(args0)
                    })
                }),
                pushRetryStrategy = javaType.pushRetryStrategy().map({ args0 -> args0 }).orElse(null),
                targetId = javaType.targetId(),
                type = javaType.type(),
            )
    }
}
