@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The Alibaba Cloud Resource Name (ARN) of the dead letter queue. Events that are not processed or whose maximum retries are exceeded are written to the dead-letter queue. The ARN feature is supported by the following queue types: MNS and Message Queue for Apache RocketMQ.
 */
public data class RuleTargetDeadLetterQueue(
    public val arn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eventbridge.outputs.RuleTargetDeadLetterQueue): RuleTargetDeadLetterQueue = RuleTargetDeadLetterQueue(
            arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
