@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property form The format of the event target parameter. Valid values: `ORIGINAL`, `TEMPLATE`, `JSONPATH`, `CONSTANT`.
 * @property resourceKey The resource parameter of the event target. For more information, see [How to use it](https://www.alibabacloud.com/help/en/eventbridge/latest/event-target-parameters)
 * @property template The template of the event target parameter.
 * @property value The value of the event target parameter.
 * > **NOTE:** There exists a potential diff error that the backend service will return a default param as following:
 * ```
 * param_list {
 * resource_key = "IsBase64Encode"
 * form         = "CONSTANT"
 * value        = "false"
 * template     = ""
 * }
 * ```
 * In order to fix the diff, from version 1.160.0, this resource has removed the param which `resource_key = "IsBase64Encode"` and `value = "false"`.
 * If you want to set `resource_key = "IsBase64Encode"`, please avoid to set `value = "false"`.
 */
public data class RuleTargetParamList(
    public val form: String,
    public val resourceKey: String,
    public val template: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eventbridge.outputs.RuleTargetParamList): RuleTargetParamList = RuleTargetParamList(
            form = javaType.form(),
            resourceKey = javaType.resourceKey(),
            template = javaType.template().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
