@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [EcFailoverTestJob].
 */
@PulumiTagMarker
public class EcFailoverTestJobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EcFailoverTestJobArgs = EcFailoverTestJobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EcFailoverTestJobArgsBuilder.() -> Unit) {
        val builder = EcFailoverTestJobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EcFailoverTestJob {
        val builtJavaResource =
            com.pulumi.alicloud.expressconnect.EcFailoverTestJob(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EcFailoverTestJob(builtJavaResource)
    }
}

/**
 * Provides a Express Connect Ec Failover Test Job resource. Express Connect Failover Test Job.
 * For information about Express Connect Ec Failover Test Job and how to use it, see [What is Ec Failover Test Job](https://www.alibabacloud.com/help/zh/express-connect/developer-reference/api-vpc-2016-04-28-createfailovertestjob-efficiency-channels).
 * > **NOTE:** Available since v1.215.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.expressconnect.getPhysicalConnections({
 *     nameRegex: "preserved-NODELETING",
 * });
 * const defaultEcFailoverTestJob = new alicloud.expressconnect.EcFailoverTestJob("default", {
 *     description: name,
 *     jobType: "StartNow",
 *     resourceIds: [
 *         _default.then(_default => _default.ids?.[0]),
 *         _default.then(_default => _default.ids?.[1]),
 *         _default.then(_default => _default.ids?.[2]),
 *     ],
 *     jobDuration: 1,
 *     resourceType: "PHYSICALCONNECTION",
 *     ecFailoverTestJobName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.expressconnect.get_physical_connections(name_regex="preserved-NODELETING")
 * default_ec_failover_test_job = alicloud.expressconnect.EcFailoverTestJob("default",
 *     description=name,
 *     job_type="StartNow",
 *     resource_ids=[
 *         default.ids[0],
 *         default.ids[1],
 *         default.ids[2],
 *     ],
 *     job_duration=1,
 *     resource_type="PHYSICALCONNECTION",
 *     ec_failover_test_job_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
 *     {
 *         NameRegex = "preserved-NODELETING",
 *     });
 *     var defaultEcFailoverTestJob = new AliCloud.ExpressConnect.EcFailoverTestJob("default", new()
 *     {
 *         Description = name,
 *         JobType = "StartNow",
 *         ResourceIds = new[]
 *         {
 *             @default.Apply(@default => @default.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Ids[0])),
 *             @default.Apply(@default => @default.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Ids[1])),
 *             @default.Apply(@default => @default.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Ids[2])),
 *         },
 *         JobDuration = 1,
 *         ResourceType = "PHYSICALCONNECTION",
 *         EcFailoverTestJobName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
 * 			NameRegex: pulumi.StringRef("preserved-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewEcFailoverTestJob(ctx, "default", &expressconnect.EcFailoverTestJobArgs{
 * 			Description: pulumi.String(name),
 * 			JobType:     pulumi.String("StartNow"),
 * 			ResourceIds: pulumi.StringArray{
 * 				pulumi.String(_default.Ids[0]),
 * 				pulumi.String(_default.Ids[1]),
 * 				pulumi.String(_default.Ids[2]),
 * 			},
 * 			JobDuration:           pulumi.Int(1),
 * 			ResourceType:          pulumi.String("PHYSICALCONNECTION"),
 * 			EcFailoverTestJobName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
 * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsArgs;
 * import com.pulumi.alicloud.expressconnect.EcFailoverTestJob;
 * import com.pulumi.alicloud.expressconnect.EcFailoverTestJobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
 *             .nameRegex("preserved-NODELETING")
 *             .build());
 *         var defaultEcFailoverTestJob = new EcFailoverTestJob("defaultEcFailoverTestJob", EcFailoverTestJobArgs.builder()
 *             .description(name)
 *             .jobType("StartNow")
 *             .resourceIds(
 *                 default_.ids()[0],
 *                 default_.ids()[1],
 *                 default_.ids()[2])
 *             .jobDuration("1")
 *             .resourceType("PHYSICALCONNECTION")
 *             .ecFailoverTestJobName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultEcFailoverTestJob:
 *     type: alicloud:expressconnect:EcFailoverTestJob
 *     name: default
 *     properties:
 *       description: ${name}
 *       jobType: StartNow
 *       resourceIds:
 *         - ${default.ids[0]}
 *         - ${default.ids[1]}
 *         - ${default.ids[2]}
 *       jobDuration: '1'
 *       resourceType: PHYSICALCONNECTION
 *       ecFailoverTestJobName: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:expressconnect:getPhysicalConnections
 *       Arguments:
 *         nameRegex: preserved-NODELETING
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Ec Failover Test Job can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/ecFailoverTestJob:EcFailoverTestJob example <id>
 * ```
 */
public class EcFailoverTestJob internal constructor(
    override val javaResource: com.pulumi.alicloud.expressconnect.EcFailoverTestJob,
) : KotlinCustomResource(javaResource, EcFailoverTestJobMapper) {
    /**
     * Job description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Job name.
     */
    public val ecFailoverTestJobName: Output<String>?
        get() = javaResource.ecFailoverTestJobName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Job duration.
     */
    public val jobDuration: Output<Int>
        get() = javaResource.jobDuration().applyValue({ args0 -> args0 })

    /**
     * Job type.
     */
    public val jobType: Output<String>
        get() = javaResource.jobType().applyValue({ args0 -> args0 })

    /**
     * Resource id list.
     */
    public val resourceIds: Output<List<String>>
        get() = javaResource.resourceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Resource type.
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object EcFailoverTestJobMapper : ResourceMapper<EcFailoverTestJob> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.expressconnect.EcFailoverTestJob::class == javaResource::class

    override fun map(javaResource: Resource): EcFailoverTestJob = EcFailoverTestJob(
        javaResource as
            com.pulumi.alicloud.expressconnect.EcFailoverTestJob,
    )
}

/**
 * @see [EcFailoverTestJob].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EcFailoverTestJob].
 */
public suspend fun ecFailoverTestJob(
    name: String,
    block: suspend EcFailoverTestJobResourceBuilder.() -> Unit,
): EcFailoverTestJob {
    val builder = EcFailoverTestJobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EcFailoverTestJob].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ecFailoverTestJob(name: String): EcFailoverTestJob {
    val builder = EcFailoverTestJobResourceBuilder()
    builder.name(name)
    return builder.build()
}
