@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.alicloud.expressconnect.EcFailoverTestJobArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Express Connect Ec Failover Test Job resource. Express Connect Failover Test Job.
 * For information about Express Connect Ec Failover Test Job and how to use it, see [What is Ec Failover Test Job](https://www.alibabacloud.com/help/zh/express-connect/developer-reference/api-vpc-2016-04-28-createfailovertestjob-efficiency-channels).
 * > **NOTE:** Available since v1.215.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.expressconnect.getPhysicalConnections({
 *     nameRegex: "preserved-NODELETING",
 * });
 * const defaultEcFailoverTestJob = new alicloud.expressconnect.EcFailoverTestJob("default", {
 *     description: name,
 *     jobType: "StartNow",
 *     resourceIds: [
 *         _default.then(_default => _default.ids?.[0]),
 *         _default.then(_default => _default.ids?.[1]),
 *         _default.then(_default => _default.ids?.[2]),
 *     ],
 *     jobDuration: 1,
 *     resourceType: "PHYSICALCONNECTION",
 *     ecFailoverTestJobName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.expressconnect.get_physical_connections(name_regex="preserved-NODELETING")
 * default_ec_failover_test_job = alicloud.expressconnect.EcFailoverTestJob("default",
 *     description=name,
 *     job_type="StartNow",
 *     resource_ids=[
 *         default.ids[0],
 *         default.ids[1],
 *         default.ids[2],
 *     ],
 *     job_duration=1,
 *     resource_type="PHYSICALCONNECTION",
 *     ec_failover_test_job_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
 *     {
 *         NameRegex = "preserved-NODELETING",
 *     });
 *     var defaultEcFailoverTestJob = new AliCloud.ExpressConnect.EcFailoverTestJob("default", new()
 *     {
 *         Description = name,
 *         JobType = "StartNow",
 *         ResourceIds = new[]
 *         {
 *             @default.Apply(@default => @default.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Ids[0])),
 *             @default.Apply(@default => @default.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Ids[1])),
 *             @default.Apply(@default => @default.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Ids[2])),
 *         },
 *         JobDuration = 1,
 *         ResourceType = "PHYSICALCONNECTION",
 *         EcFailoverTestJobName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
 * 			NameRegex: pulumi.StringRef("preserved-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewEcFailoverTestJob(ctx, "default", &expressconnect.EcFailoverTestJobArgs{
 * 			Description: pulumi.String(name),
 * 			JobType:     pulumi.String("StartNow"),
 * 			ResourceIds: pulumi.StringArray{
 * 				pulumi.String(_default.Ids[0]),
 * 				pulumi.String(_default.Ids[1]),
 * 				pulumi.String(_default.Ids[2]),
 * 			},
 * 			JobDuration:           pulumi.Int(1),
 * 			ResourceType:          pulumi.String("PHYSICALCONNECTION"),
 * 			EcFailoverTestJobName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
 * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsArgs;
 * import com.pulumi.alicloud.expressconnect.EcFailoverTestJob;
 * import com.pulumi.alicloud.expressconnect.EcFailoverTestJobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
 *             .nameRegex("preserved-NODELETING")
 *             .build());
 *         var defaultEcFailoverTestJob = new EcFailoverTestJob("defaultEcFailoverTestJob", EcFailoverTestJobArgs.builder()
 *             .description(name)
 *             .jobType("StartNow")
 *             .resourceIds(
 *                 default_.ids()[0],
 *                 default_.ids()[1],
 *                 default_.ids()[2])
 *             .jobDuration("1")
 *             .resourceType("PHYSICALCONNECTION")
 *             .ecFailoverTestJobName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultEcFailoverTestJob:
 *     type: alicloud:expressconnect:EcFailoverTestJob
 *     name: default
 *     properties:
 *       description: ${name}
 *       jobType: StartNow
 *       resourceIds:
 *         - ${default.ids[0]}
 *         - ${default.ids[1]}
 *         - ${default.ids[2]}
 *       jobDuration: '1'
 *       resourceType: PHYSICALCONNECTION
 *       ecFailoverTestJobName: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:expressconnect:getPhysicalConnections
 *       Arguments:
 *         nameRegex: preserved-NODELETING
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Ec Failover Test Job can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/ecFailoverTestJob:EcFailoverTestJob example <id>
 * ```
 * @property description Job description.
 * @property ecFailoverTestJobName Job name.
 * @property jobDuration Job duration.
 * @property jobType Job type.
 * @property resourceIds Resource id list.
 * @property resourceType Resource type.
 * @property status The status of the resource.
 */
public data class EcFailoverTestJobArgs(
    public val description: Output<String>? = null,
    public val ecFailoverTestJobName: Output<String>? = null,
    public val jobDuration: Output<Int>? = null,
    public val jobType: Output<String>? = null,
    public val resourceIds: Output<List<String>>? = null,
    public val resourceType: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.EcFailoverTestJobArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.EcFailoverTestJobArgs =
        com.pulumi.alicloud.expressconnect.EcFailoverTestJobArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .ecFailoverTestJobName(ecFailoverTestJobName?.applyValue({ args0 -> args0 }))
            .jobDuration(jobDuration?.applyValue({ args0 -> args0 }))
            .jobType(jobType?.applyValue({ args0 -> args0 }))
            .resourceIds(resourceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcFailoverTestJobArgs].
 */
@PulumiTagMarker
public class EcFailoverTestJobArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var ecFailoverTestJobName: Output<String>? = null

    private var jobDuration: Output<Int>? = null

    private var jobType: Output<String>? = null

    private var resourceIds: Output<List<String>>? = null

    private var resourceType: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Job description.
     */
    @JvmName("kiqtruebtmcbjtct")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Job name.
     */
    @JvmName("dnvqvmeeecsrdjmx")
    public suspend fun ecFailoverTestJobName(`value`: Output<String>) {
        this.ecFailoverTestJobName = value
    }

    /**
     * @param value Job duration.
     */
    @JvmName("jqcoicqcwxeotwog")
    public suspend fun jobDuration(`value`: Output<Int>) {
        this.jobDuration = value
    }

    /**
     * @param value Job type.
     */
    @JvmName("cxlmvcbjredoupph")
    public suspend fun jobType(`value`: Output<String>) {
        this.jobType = value
    }

    /**
     * @param value Resource id list.
     */
    @JvmName("mnhfraynuehktarl")
    public suspend fun resourceIds(`value`: Output<List<String>>) {
        this.resourceIds = value
    }

    @JvmName("sbkhrliaoulknfob")
    public suspend fun resourceIds(vararg values: Output<String>) {
        this.resourceIds = Output.all(values.asList())
    }

    /**
     * @param values Resource id list.
     */
    @JvmName("entdgkibjaqglmyn")
    public suspend fun resourceIds(values: List<Output<String>>) {
        this.resourceIds = Output.all(values)
    }

    /**
     * @param value Resource type.
     */
    @JvmName("mtpscoxmwxwcjkhx")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The status of the resource.
     */
    @JvmName("tvmrojjuinxdqdyd")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Job description.
     */
    @JvmName("bhudferhgsmqkfwn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Job name.
     */
    @JvmName("gjibqpdcvpdctivm")
    public suspend fun ecFailoverTestJobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecFailoverTestJobName = mapped
    }

    /**
     * @param value Job duration.
     */
    @JvmName("wknypqscdveesvrr")
    public suspend fun jobDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobDuration = mapped
    }

    /**
     * @param value Job type.
     */
    @JvmName("ekugyixxdlahguen")
    public suspend fun jobType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobType = mapped
    }

    /**
     * @param value Resource id list.
     */
    @JvmName("vhmyiekrxfnwurru")
    public suspend fun resourceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceIds = mapped
    }

    /**
     * @param values Resource id list.
     */
    @JvmName("hqlciavykslynfxt")
    public suspend fun resourceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceIds = mapped
    }

    /**
     * @param value Resource type.
     */
    @JvmName("buaunscovyayfuqe")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value The status of the resource.
     */
    @JvmName("wbhxxldfpwfquapm")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): EcFailoverTestJobArgs = EcFailoverTestJobArgs(
        description = description,
        ecFailoverTestJobName = ecFailoverTestJobName,
        jobDuration = jobDuration,
        jobType = jobType,
        resourceIds = resourceIds,
        resourceType = resourceType,
        status = status,
    )
}
