@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions.getAccessPointsPlain
import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions.getGrantRuleToCensPlain
import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions.getPhysicalConnectionServicePlain
import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions.getPhysicalConnectionsPlain
import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions.getRouterInterfacesPlain
import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions.getVbrPconnAssociationsPlain
import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions.getVirtualBorderRoutersPlain
import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions.getVirtualPhysicalConnectionsPlain
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetAccessPointsPlainArgs
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetAccessPointsPlainArgsBuilder
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetGrantRuleToCensPlainArgs
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetGrantRuleToCensPlainArgsBuilder
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetPhysicalConnectionServicePlainArgs
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetPhysicalConnectionServicePlainArgsBuilder
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetPhysicalConnectionsPlainArgs
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetPhysicalConnectionsPlainArgsBuilder
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetRouterInterfacesFilter
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetRouterInterfacesPlainArgs
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetRouterInterfacesPlainArgsBuilder
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetVbrPconnAssociationsPlainArgs
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetVbrPconnAssociationsPlainArgsBuilder
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetVirtualBorderRoutersFilter
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetVirtualBorderRoutersPlainArgs
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetVirtualBorderRoutersPlainArgsBuilder
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetVirtualPhysicalConnectionsPlainArgs
import com.pulumi.alicloud.expressconnect.kotlin.inputs.GetVirtualPhysicalConnectionsPlainArgsBuilder
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetAccessPointsResult
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetGrantRuleToCensResult
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetPhysicalConnectionServiceResult
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetPhysicalConnectionsResult
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetRouterInterfacesResult
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetVbrPconnAssociationsResult
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetVirtualBorderRoutersResult
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetVirtualPhysicalConnectionsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetAccessPointsResult.Companion.toKotlin as getAccessPointsResultToKotlin
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetGrantRuleToCensResult.Companion.toKotlin as getGrantRuleToCensResultToKotlin
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetPhysicalConnectionServiceResult.Companion.toKotlin as getPhysicalConnectionServiceResultToKotlin
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetPhysicalConnectionsResult.Companion.toKotlin as getPhysicalConnectionsResultToKotlin
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetRouterInterfacesResult.Companion.toKotlin as getRouterInterfacesResultToKotlin
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetVbrPconnAssociationsResult.Companion.toKotlin as getVbrPconnAssociationsResultToKotlin
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetVirtualBorderRoutersResult.Companion.toKotlin as getVirtualBorderRoutersResultToKotlin
import com.pulumi.alicloud.expressconnect.kotlin.outputs.GetVirtualPhysicalConnectionsResult.Companion.toKotlin as getVirtualPhysicalConnectionsResultToKotlin

public object ExpressconnectFunctions {
    /**
     * This data source provides the Express Connect Access Points of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.132.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.expressconnect.getAccessPoints({
     *     ids: ["ap-cn-hangzhou-yh-C"],
     * });
     * export const expressConnectAccessPointId1 = ids.then(ids => ids.points?.[0]?.id);
     * const nameRegex = alicloud.expressconnect.getAccessPoints({
     *     nameRegex: "^杭州-",
     * });
     * export const expressConnectAccessPointId2 = nameRegex.then(nameRegex => nameRegex.points?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.expressconnect.get_access_points(ids=["ap-cn-hangzhou-yh-C"])
     * pulumi.export("expressConnectAccessPointId1", ids.points[0].id)
     * name_regex = alicloud.expressconnect.get_access_points(name_regex="^杭州-")
     * pulumi.export("expressConnectAccessPointId2", name_regex.points[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.ExpressConnect.GetAccessPoints.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "ap-cn-hangzhou-yh-C",
     *         },
     *     });
     *     var nameRegex = AliCloud.ExpressConnect.GetAccessPoints.Invoke(new()
     *     {
     *         NameRegex = "^杭州-",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["expressConnectAccessPointId1"] = ids&#46;Apply(getAccessPointsResult => getAccessPointsResult&#46;Points[0]?.Id),
     *         ["expressConnectAccessPointId2"] = nameRegex&#46;Apply(getAccessPointsResult => getAccessPointsResult&#46;Points[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := expressconnect.GetAccessPoints(ctx, &expressconnect.GetAccessPointsArgs{
     * 			Ids: []string{
     * 				"ap-cn-hangzhou-yh-C",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("expressConnectAccessPointId1", ids.Points[0].Id)
     * 		nameRegex, err := expressconnect.GetAccessPoints(ctx, &expressconnect.GetAccessPointsArgs{
     * 			NameRegex: pulumi.StringRef("^杭州-"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("expressConnectAccessPointId2", nameRegex.Points[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
     * import com.pulumi.alicloud.expressconnect.inputs.GetAccessPointsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ExpressconnectFunctions.getAccessPoints(GetAccessPointsArgs.builder()
     *             .ids("ap-cn-hangzhou-yh-C")
     *             .build());
     *         ctx.export("expressConnectAccessPointId1", ids.applyValue(getAccessPointsResult -> getAccessPointsResult.points()[0].id()));
     *         final var nameRegex = ExpressconnectFunctions.getAccessPoints(GetAccessPointsArgs.builder()
     *             .nameRegex("^杭州-")
     *             .build());
     *         ctx.export("expressConnectAccessPointId2", nameRegex.applyValue(getAccessPointsResult -> getAccessPointsResult.points()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:expressconnect:getAccessPoints
     *       Arguments:
     *         ids:
     *           - ap-cn-hangzhou-yh-C
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:expressconnect:getAccessPoints
     *       Arguments:
     *         nameRegex: ^杭州-
     * outputs:
     *   expressConnectAccessPointId1: ${ids.points[0].id}
     *   expressConnectAccessPointId2: ${nameRegex.points[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccessPoints.
     * @return A collection of values returned by getAccessPoints.
     */
    public suspend fun getAccessPoints(argument: GetAccessPointsPlainArgs): GetAccessPointsResult =
        getAccessPointsResultToKotlin(getAccessPointsPlain(argument.toJava()).await())

    /**
     * @see [getAccessPoints].
     * @param ids A list of Access Point IDs.
     * @param nameRegex A regex string to filter results by Access Point name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The Physical Connection to Which the Access Point State. Valid values: `disabled`, `full`, `hot`, `recommended`.
     * @return A collection of values returned by getAccessPoints.
     */
    public suspend fun getAccessPoints(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetAccessPointsResult {
        val argument = GetAccessPointsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getAccessPointsResultToKotlin(getAccessPointsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessPoints].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;expressconnect&#46;kotlin&#46;inputs&#46;GetAccessPointsPlainArgs].
     * @return A collection of values returned by getAccessPoints.
     */
    public suspend fun getAccessPoints(argument: suspend GetAccessPointsPlainArgsBuilder.() -> Unit): GetAccessPointsResult {
        val builder = GetAccessPointsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessPointsResultToKotlin(getAccessPointsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Express Connect Grant Rule To Cens of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.196.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.expressconnect.getGrantRuleToCens({
     *     ids: ["example_id"],
     *     instanceId: "your_vbr_instance_id",
     * });
     * export const expressConnectGrantRuleToCenId0 = ids.then(ids => ids.cens?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.expressconnect.get_grant_rule_to_cens(ids=["example_id"],
     *     instance_id="your_vbr_instance_id")
     * pulumi.export("expressConnectGrantRuleToCenId0", ids.cens[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.ExpressConnect.GetGrantRuleToCens.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         InstanceId = "your_vbr_instance_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["expressConnectGrantRuleToCenId0"] = ids&#46;Apply(getGrantRuleToCensResult => getGrantRuleToCensResult&#46;Cens[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := expressconnect.GetGrantRuleToCens(ctx, &expressconnect.GetGrantRuleToCensArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			InstanceId: "your_vbr_instance_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("expressConnectGrantRuleToCenId0", ids.Cens[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
     * import com.pulumi.alicloud.expressconnect.inputs.GetGrantRuleToCensArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ExpressconnectFunctions.getGrantRuleToCens(GetGrantRuleToCensArgs.builder()
     *             .ids("example_id")
     *             .instanceId("your_vbr_instance_id")
     *             .build());
     *         ctx.export("expressConnectGrantRuleToCenId0", ids.applyValue(getGrantRuleToCensResult -> getGrantRuleToCensResult.cens()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:expressconnect:getGrantRuleToCens
     *       Arguments:
     *         ids:
     *           - example_id
     *         instanceId: your_vbr_instance_id
     * outputs:
     *   expressConnectGrantRuleToCenId0: ${ids.cens[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGrantRuleToCens.
     * @return A collection of values returned by getGrantRuleToCens.
     */
    public suspend fun getGrantRuleToCens(argument: GetGrantRuleToCensPlainArgs): GetGrantRuleToCensResult =
        getGrantRuleToCensResultToKotlin(getGrantRuleToCensPlain(argument.toJava()).await())

    /**
     * @see [getGrantRuleToCens].
     * @param ids A list of Grant Rule To Cen IDs.
     * @param instanceId The ID of the VBR.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getGrantRuleToCens.
     */
    public suspend fun getGrantRuleToCens(
        ids: List<String>? = null,
        instanceId: String,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetGrantRuleToCensResult {
        val argument = GetGrantRuleToCensPlainArgs(
            ids = ids,
            instanceId = instanceId,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getGrantRuleToCensResultToKotlin(getGrantRuleToCensPlain(argument.toJava()).await())
    }

    /**
     * @see [getGrantRuleToCens].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;expressconnect&#46;kotlin&#46;inputs&#46;GetGrantRuleToCensPlainArgs].
     * @return A collection of values returned by getGrantRuleToCens.
     */
    public suspend fun getGrantRuleToCens(argument: suspend GetGrantRuleToCensPlainArgsBuilder.() -> Unit): GetGrantRuleToCensResult {
        val builder = GetGrantRuleToCensPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGrantRuleToCensResultToKotlin(getGrantRuleToCensPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can enable outbound traffic for an Express Connect circuit automatically. If the service has been opened, it will return opened.
     * For information about Express Connect and how to use it, see [What is Express Connect](https://www.alibabacloud.com/help/doc-detail/275179.htm).
     * > **NOTE:** Available since v1.132.0
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.expressconnect.getPhysicalConnectionService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.expressconnect.get_physical_connection_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.ExpressConnect.GetPhysicalConnectionService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := expressconnect.GetPhysicalConnectionService(ctx, &expressconnect.GetPhysicalConnectionServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
     * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = ExpressconnectFunctions.getPhysicalConnectionService(GetPhysicalConnectionServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:expressconnect:getPhysicalConnectionService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPhysicalConnectionService.
     * @return A collection of values returned by getPhysicalConnectionService.
     */
    public suspend fun getPhysicalConnectionService(argument: GetPhysicalConnectionServicePlainArgs): GetPhysicalConnectionServiceResult =
        getPhysicalConnectionServiceResultToKotlin(getPhysicalConnectionServicePlain(argument.toJava()).await())

    /**
     * @see [getPhysicalConnectionService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to enable outbound traffic for an Express Connect circuit that means you have read and agreed the [Express Connect Terms of Service](https://terms.aliyun.com/legal-agreement/terms/suit_bu1_ali_cloud/suit_bu1_ali_cloud201803060947_16271.html). The service can not closed once it is opened.
     * @return A collection of values returned by getPhysicalConnectionService.
     */
    public suspend fun getPhysicalConnectionService(enable: String? = null): GetPhysicalConnectionServiceResult {
        val argument = GetPhysicalConnectionServicePlainArgs(
            enable = enable,
        )
        return getPhysicalConnectionServiceResultToKotlin(getPhysicalConnectionServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getPhysicalConnectionService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;expressconnect&#46;kotlin&#46;inputs&#46;GetPhysicalConnectionServicePlainArgs].
     * @return A collection of values returned by getPhysicalConnectionService.
     */
    public suspend fun getPhysicalConnectionService(argument: suspend GetPhysicalConnectionServicePlainArgsBuilder.() -> Unit): GetPhysicalConnectionServiceResult {
        val builder = GetPhysicalConnectionServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPhysicalConnectionServiceResultToKotlin(getPhysicalConnectionServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Express Connect Physical Connections of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.132.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.expressconnect.getPhysicalConnections({
     *     ids: ["pc-2345678"],
     * });
     * export const expressConnectPhysicalConnectionId1 = ids.then(ids => ids.connections?.[0]?.id);
     * const nameRegex = alicloud.expressconnect.getPhysicalConnections({
     *     nameRegex: "^my-PhysicalConnection",
     * });
     * export const expressConnectPhysicalConnectionId2 = nameRegex.then(nameRegex => nameRegex.connections?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.expressconnect.get_physical_connections(ids=["pc-2345678"])
     * pulumi.export("expressConnectPhysicalConnectionId1", ids.connections[0].id)
     * name_regex = alicloud.expressconnect.get_physical_connections(name_regex="^my-PhysicalConnection")
     * pulumi.export("expressConnectPhysicalConnectionId2", name_regex.connections[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "pc-2345678",
     *         },
     *     });
     *     var nameRegex = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
     *     {
     *         NameRegex = "^my-PhysicalConnection",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["expressConnectPhysicalConnectionId1"] = ids&#46;Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult&#46;Connections[0]?.Id),
     *         ["expressConnectPhysicalConnectionId2"] = nameRegex&#46;Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult&#46;Connections[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
     * 			Ids: []string{
     * 				"pc-2345678",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("expressConnectPhysicalConnectionId1", ids.Connections[0].Id)
     * 		nameRegex, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
     * 			NameRegex: pulumi.StringRef("^my-PhysicalConnection"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("expressConnectPhysicalConnectionId2", nameRegex.Connections[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
     * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
     *             .ids("pc-2345678")
     *             .build());
     *         ctx.export("expressConnectPhysicalConnectionId1", ids.applyValue(getPhysicalConnectionsResult -> getPhysicalConnectionsResult.connections()[0].id()));
     *         final var nameRegex = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
     *             .nameRegex("^my-PhysicalConnection")
     *             .build());
     *         ctx.export("expressConnectPhysicalConnectionId2", nameRegex.applyValue(getPhysicalConnectionsResult -> getPhysicalConnectionsResult.connections()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:expressconnect:getPhysicalConnections
     *       Arguments:
     *         ids:
     *           - pc-2345678
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:expressconnect:getPhysicalConnections
     *       Arguments:
     *         nameRegex: ^my-PhysicalConnection
     * outputs:
     *   expressConnectPhysicalConnectionId1: ${ids.connections[0].id}
     *   expressConnectPhysicalConnectionId2: ${nameRegex.connections[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPhysicalConnections.
     * @return A collection of values returned by getPhysicalConnections.
     */
    public suspend fun getPhysicalConnections(argument: GetPhysicalConnectionsPlainArgs): GetPhysicalConnectionsResult =
        getPhysicalConnectionsResultToKotlin(getPhysicalConnectionsPlain(argument.toJava()).await())

    /**
     * @see [getPhysicalConnections].
     * @param ids A list of Physical Connection IDs.
     * @param includeReservationData The include reservation data.
     * @param nameRegex A regex string to filter results by Physical Connection name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status Resources on Behalf of a State of the Resource Attribute Field. Valid values: `Canceled`, `Enabled`, `Terminated`.
     * @return A collection of values returned by getPhysicalConnections.
     */
    public suspend fun getPhysicalConnections(
        ids: List<String>? = null,
        includeReservationData: Boolean? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetPhysicalConnectionsResult {
        val argument = GetPhysicalConnectionsPlainArgs(
            ids = ids,
            includeReservationData = includeReservationData,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getPhysicalConnectionsResultToKotlin(getPhysicalConnectionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPhysicalConnections].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;expressconnect&#46;kotlin&#46;inputs&#46;GetPhysicalConnectionsPlainArgs].
     * @return A collection of values returned by getPhysicalConnections.
     */
    public suspend fun getPhysicalConnections(argument: suspend GetPhysicalConnectionsPlainArgsBuilder.() -> Unit): GetPhysicalConnectionsResult {
        val builder = GetPhysicalConnectionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPhysicalConnectionsResultToKotlin(getPhysicalConnectionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Router Interface available to the user.[What is Router Interface](https://www.alibabacloud.com/help/en/express-connect/developer-reference/api-vpc-2016-04-28-describerouterinterfaces-efficiency-channels)
     * > **NOTE:** Available in 1.199.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.expressconnect.getRouterInterfaces({
     *     ids: [defaultAlicloudRouterInterface&#46;id],
     *     nameRegex: defaultAlicloudRouterInterface.name,
     * });
     * export const alicloudRouterInterfaceExampleId = _default.then(_default => _default.interfaces?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.expressconnect.get_router_interfaces(ids=[default_alicloud_router_interface["id"]],
     *     name_regex=default_alicloud_router_interface["name"])
     * pulumi.export("alicloudRouterInterfaceExampleId", default.interfaces[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ExpressConnect.GetRouterInterfaces.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudRouterInterface.Id,
     *         },
     *         NameRegex = defaultAlicloudRouterInterface.Name,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudRouterInterfaceExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getRouterInterfacesResult => getRouterInterfacesResult&#46;Interfaces[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := expressconnect.GetRouterInterfaces(ctx, &expressconnect.GetRouterInterfacesArgs{
     * Ids: interface{}{
     * defaultAlicloudRouterInterface.Id,
     * },
     * NameRegex: pulumi.StringRef(defaultAlicloudRouterInterface.Name),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudRouterInterfaceExampleId", _default.Interfaces[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
     * import com.pulumi.alicloud.expressconnect.inputs.GetRouterInterfacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ExpressconnectFunctions.getRouterInterfaces(GetRouterInterfacesArgs.builder()
     *             .ids(defaultAlicloudRouterInterface.id())
     *             .nameRegex(defaultAlicloudRouterInterface.name())
     *             .build());
     *         ctx.export("alicloudRouterInterfaceExampleId", default_.interfaces()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:expressconnect:getRouterInterfaces
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudRouterInterface.id}
     *         nameRegex: ${defaultAlicloudRouterInterface.name}
     * outputs:
     *   alicloudRouterInterfaceExampleId: ${default.interfaces[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRouterInterfaces.
     * @return A collection of values returned by getRouterInterfaces.
     */
    public suspend fun getRouterInterfaces(argument: GetRouterInterfacesPlainArgs): GetRouterInterfacesResult =
        getRouterInterfacesResultToKotlin(getRouterInterfacesPlain(argument.toJava()).await())

    /**
     * @see [getRouterInterfaces].
     * @param filters
     * @param ids A list of Router Interface IDs.
     * @param includeReservationData Does it contain renewal data. Valid values: `true`, `false`.
     * @param nameRegex A regex string to filter results by Group Metric Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getRouterInterfaces.
     */
    public suspend fun getRouterInterfaces(
        filters: List<GetRouterInterfacesFilter>? = null,
        ids: List<String>? = null,
        includeReservationData: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetRouterInterfacesResult {
        val argument = GetRouterInterfacesPlainArgs(
            filters = filters,
            ids = ids,
            includeReservationData = includeReservationData,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getRouterInterfacesResultToKotlin(getRouterInterfacesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouterInterfaces].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;expressconnect&#46;kotlin&#46;inputs&#46;GetRouterInterfacesPlainArgs].
     * @return A collection of values returned by getRouterInterfaces.
     */
    public suspend fun getRouterInterfaces(argument: suspend GetRouterInterfacesPlainArgsBuilder.() -> Unit): GetRouterInterfacesResult {
        val builder = GetRouterInterfacesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouterInterfacesResultToKotlin(getRouterInterfacesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Express Connect Vbr Pconn Association available to the user.
     * > **NOTE:** Available in 1.196.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.expressconnect.getVbrPconnAssociations({
     *     ids: ["example_id"],
     *     vbrId: defaultAlicloudExpressConnectVbrPconnAssociation.vbrId,
     * });
     * export const alicloudExpressConnectVbrPconnAssociationExampleId = _default.then(_default => _default.associations?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.expressconnect.get_vbr_pconn_associations(ids=["example_id"],
     *     vbr_id=default_alicloud_express_connect_vbr_pconn_association["vbrId"])
     * pulumi.export("alicloudExpressConnectVbrPconnAssociationExampleId", default.associations[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ExpressConnect.GetVbrPconnAssociations.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         VbrId = defaultAlicloudExpressConnectVbrPconnAssociation.VbrId,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudExpressConnectVbrPconnAssociationExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getVbrPconnAssociationsResult => getVbrPconnAssociationsResult&#46;Associations[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := expressconnect.GetVbrPconnAssociations(ctx, &expressconnect.GetVbrPconnAssociationsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			VbrId: pulumi.StringRef(defaultAlicloudExpressConnectVbrPconnAssociation.VbrId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudExpressConnectVbrPconnAssociationExampleId", _default.Associations[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
     * import com.pulumi.alicloud.expressconnect.inputs.GetVbrPconnAssociationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ExpressconnectFunctions.getVbrPconnAssociations(GetVbrPconnAssociationsArgs.builder()
     *             .ids("example_id")
     *             .vbrId(defaultAlicloudExpressConnectVbrPconnAssociation.vbrId())
     *             .build());
     *         ctx.export("alicloudExpressConnectVbrPconnAssociationExampleId", default_.associations()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:expressconnect:getVbrPconnAssociations
     *       Arguments:
     *         ids:
     *           - example_id
     *         vbrId: ${defaultAlicloudExpressConnectVbrPconnAssociation.vbrId}
     * outputs:
     *   alicloudExpressConnectVbrPconnAssociationExampleId: ${default.associations[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVbrPconnAssociations.
     * @return A collection of values returned by getVbrPconnAssociations.
     */
    public suspend fun getVbrPconnAssociations(argument: GetVbrPconnAssociationsPlainArgs): GetVbrPconnAssociationsResult =
        getVbrPconnAssociationsResultToKotlin(getVbrPconnAssociationsPlain(argument.toJava()).await())

    /**
     * @see [getVbrPconnAssociations].
     * @param ids A list of Vbr Pconn Association IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param vbrId The ID of the VBR instance.
     * @return A collection of values returned by getVbrPconnAssociations.
     */
    public suspend fun getVbrPconnAssociations(
        ids: List<String>? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        vbrId: String? = null,
    ): GetVbrPconnAssociationsResult {
        val argument = GetVbrPconnAssociationsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            vbrId = vbrId,
        )
        return getVbrPconnAssociationsResultToKotlin(getVbrPconnAssociationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVbrPconnAssociations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;expressconnect&#46;kotlin&#46;inputs&#46;GetVbrPconnAssociationsPlainArgs].
     * @return A collection of values returned by getVbrPconnAssociations.
     */
    public suspend fun getVbrPconnAssociations(argument: suspend GetVbrPconnAssociationsPlainArgsBuilder.() -> Unit): GetVbrPconnAssociationsResult {
        val builder = GetVbrPconnAssociationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVbrPconnAssociationsResultToKotlin(getVbrPconnAssociationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Express Connect Virtual Border Routers of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.134.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.expressconnect.getVirtualBorderRouters({});
     * export const expressConnectVirtualBorderRouterId1 = ids.then(ids => ids.routers?.[0]?.id);
     * const nameRegex = alicloud.expressconnect.getVirtualBorderRouters({
     *     nameRegex: "^my-VirtualBorderRouter",
     * });
     * export const expressConnectVirtualBorderRouterId2 = nameRegex.then(nameRegex => nameRegex.routers?.[0]?.id);
     * const filter = alicloud.expressconnect.getVirtualBorderRouters({
     *     filters: [
     *         {
     *             key: "PhysicalConnectionId",
     *             values: ["pc-xxxx1"],
     *         },
     *         {
     *             key: "VbrId",
     *             values: [
     *                 "vbr-xxxx1",
     *                 "vbr-xxxx2",
     *             ],
     *         },
     *     ],
     * });
     * export const expressConnectVirtualBorderRouterId3 = filter.then(filter => filter.routers?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.expressconnect.get_virtual_border_routers()
     * pulumi.export("expressConnectVirtualBorderRouterId1", ids.routers[0].id)
     * name_regex = alicloud.expressconnect.get_virtual_border_routers(name_regex="^my-VirtualBorderRouter")
     * pulumi.export("expressConnectVirtualBorderRouterId2", name_regex.routers[0].id)
     * filter = alicloud.expressconnect.get_virtual_border_routers(filters=[
     *     {
     *         "key": "PhysicalConnectionId",
     *         "values": ["pc-xxxx1"],
     *     },
     *     {
     *         "key": "VbrId",
     *         "values": [
     *             "vbr-xxxx1",
     *             "vbr-xxxx2",
     *         ],
     *     },
     * ])
     * pulumi.export("expressConnectVirtualBorderRouterId3", filter.routers[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.ExpressConnect.GetVirtualBorderRouters.Invoke();
     *     var nameRegex = AliCloud.ExpressConnect.GetVirtualBorderRouters.Invoke(new()
     *     {
     *         NameRegex = "^my-VirtualBorderRouter",
     *     });
     *     var filter = AliCloud.ExpressConnect.GetVirtualBorderRouters.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new AliCloud.ExpressConnect.Inputs.GetVirtualBorderRoutersFilterInputArgs
     *             {
     *                 Key = "PhysicalConnectionId",
     *                 Values = new[]
     *                 {
     *                     "pc-xxxx1",
     *                 },
     *             },
     *             new AliCloud.ExpressConnect.Inputs.GetVirtualBorderRoutersFilterInputArgs
     *             {
     *                 Key = "VbrId",
     *                 Values = new[]
     *                 {
     *                     "vbr-xxxx1",
     *                     "vbr-xxxx2",
     *                 },
     *             },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["expressConnectVirtualBorderRouterId1"] = ids&#46;Apply(getVirtualBorderRoutersResult => getVirtualBorderRoutersResult&#46;Routers[0]?.Id),
     *         ["expressConnectVirtualBorderRouterId2"] = nameRegex&#46;Apply(getVirtualBorderRoutersResult => getVirtualBorderRoutersResult&#46;Routers[0]?.Id),
     *         ["expressConnectVirtualBorderRouterId3"] = filter&#46;Apply(getVirtualBorderRoutersResult => getVirtualBorderRoutersResult&#46;Routers[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := expressconnect.GetVirtualBorderRouters(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("expressConnectVirtualBorderRouterId1", ids.Routers[0].Id)
     * 		nameRegex, err := expressconnect.GetVirtualBorderRouters(ctx, &expressconnect.GetVirtualBorderRoutersArgs{
     * 			NameRegex: pulumi.StringRef("^my-VirtualBorderRouter"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("expressConnectVirtualBorderRouterId2", nameRegex.Routers[0].Id)
     * 		filter, err := expressconnect.GetVirtualBorderRouters(ctx, &expressconnect.GetVirtualBorderRoutersArgs{
     * 			Filters: []expressconnect.GetVirtualBorderRoutersFilter{
     * 				{
     * 					Key: pulumi.StringRef("PhysicalConnectionId"),
     * 					Values: []string{
     * 						"pc-xxxx1",
     * 					},
     * 				},
     * 				{
     * 					Key: pulumi.StringRef("VbrId"),
     * 					Values: []string{
     * 						"vbr-xxxx1",
     * 						"vbr-xxxx2",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("expressConnectVirtualBorderRouterId3", filter.Routers[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
     * import com.pulumi.alicloud.expressconnect.inputs.GetVirtualBorderRoutersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ExpressconnectFunctions.getVirtualBorderRouters();
     *         ctx.export("expressConnectVirtualBorderRouterId1", ids.applyValue(getVirtualBorderRoutersResult -> getVirtualBorderRoutersResult.routers()[0].id()));
     *         final var nameRegex = ExpressconnectFunctions.getVirtualBorderRouters(GetVirtualBorderRoutersArgs.builder()
     *             .nameRegex("^my-VirtualBorderRouter")
     *             .build());
     *         ctx.export("expressConnectVirtualBorderRouterId2", nameRegex.applyValue(getVirtualBorderRoutersResult -> getVirtualBorderRoutersResult.routers()[0].id()));
     *         final var filter = ExpressconnectFunctions.getVirtualBorderRouters(GetVirtualBorderRoutersArgs.builder()
     *             .filters(
     *                 GetVirtualBorderRoutersFilterArgs.builder()
     *                     .key("PhysicalConnectionId")
     *                     .values("pc-xxxx1")
     *                     .build(),
     *                 GetVirtualBorderRoutersFilterArgs.builder()
     *                     .key("VbrId")
     *                     .values(
     *                         "vbr-xxxx1",
     *                         "vbr-xxxx2")
     *                     .build())
     *             .build());
     *         ctx.export("expressConnectVirtualBorderRouterId3", filter.applyValue(getVirtualBorderRoutersResult -> getVirtualBorderRoutersResult.routers()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:expressconnect:getVirtualBorderRouters
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:expressconnect:getVirtualBorderRouters
     *       Arguments:
     *         nameRegex: ^my-VirtualBorderRouter
     *   filter:
     *     fn::invoke:
     *       Function: alicloud:expressconnect:getVirtualBorderRouters
     *       Arguments:
     *         filters:
     *           - key: PhysicalConnectionId
     *             values:
     *               - pc-xxxx1
     *           - key: VbrId
     *             values:
     *               - vbr-xxxx1
     *               - vbr-xxxx2
     * outputs:
     *   expressConnectVirtualBorderRouterId1: ${ids.routers[0].id}
     *   expressConnectVirtualBorderRouterId2: ${nameRegex.routers[0].id}
     *   expressConnectVirtualBorderRouterId3: ${filter.routers[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVirtualBorderRouters.
     * @return A collection of values returned by getVirtualBorderRouters.
     */
    public suspend fun getVirtualBorderRouters(argument: GetVirtualBorderRoutersPlainArgs): GetVirtualBorderRoutersResult =
        getVirtualBorderRoutersResultToKotlin(getVirtualBorderRoutersPlain(argument.toJava()).await())

    /**
     * @see [getVirtualBorderRouters].
     * @param filters Custom filter block as described below.
     * @param ids A list of Virtual Border Router IDs.
     * @param nameRegex A regex string to filter results by Virtual Border Router name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The instance state with. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
     * @return A collection of values returned by getVirtualBorderRouters.
     */
    public suspend fun getVirtualBorderRouters(
        filters: List<GetVirtualBorderRoutersFilter>? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetVirtualBorderRoutersResult {
        val argument = GetVirtualBorderRoutersPlainArgs(
            filters = filters,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getVirtualBorderRoutersResultToKotlin(getVirtualBorderRoutersPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualBorderRouters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;expressconnect&#46;kotlin&#46;inputs&#46;GetVirtualBorderRoutersPlainArgs].
     * @return A collection of values returned by getVirtualBorderRouters.
     */
    public suspend fun getVirtualBorderRouters(argument: suspend GetVirtualBorderRoutersPlainArgsBuilder.() -> Unit): GetVirtualBorderRoutersResult {
        val builder = GetVirtualBorderRoutersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualBorderRoutersResultToKotlin(getVirtualBorderRoutersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Express Connect Virtual Physical Connection available to the user.
     * > **NOTE:** Available in 1.196.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
     * import com.pulumi.alicloud.expressconnect.inputs.GetVirtualPhysicalConnectionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ExpressconnectFunctions.getVirtualPhysicalConnections(GetVirtualPhysicalConnectionsArgs.builder()
     *             .ids(defaultAlicloudExpressConnectVirtualPhysicalConnection.id())
     *             .nameRegex(defaultAlicloudExpressConnectVirtualPhysicalConnection.name())
     *             .parentPhysicalConnectionId(defaultAlicloudExpressConnectVirtualPhysicalConnection.parentPhysicalConnectionId())
     *             .vlanId(789)
     *             .vpconnAliUid(1234567890)
     *             .build());
     *         ctx.export("alicloudExpressConnectVirtualPhysicalConnectionExampleId", default_.connections()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:expressconnect:getVirtualPhysicalConnections
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudExpressConnectVirtualPhysicalConnection.id}
     *         nameRegex: ${defaultAlicloudExpressConnectVirtualPhysicalConnection.name}
     *         parentPhysicalConnectionId: ${defaultAlicloudExpressConnectVirtualPhysicalConnection.parentPhysicalConnectionId}
     *         vlanId: 789
     *         vpconnAliUid: 1.23456789e+09
     * outputs:
     *   alicloudExpressConnectVirtualPhysicalConnectionExampleId: ${default.connections[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVirtualPhysicalConnections.
     * @return A collection of values returned by getVirtualPhysicalConnections.
     */
    public suspend fun getVirtualPhysicalConnections(argument: GetVirtualPhysicalConnectionsPlainArgs): GetVirtualPhysicalConnectionsResult =
        getVirtualPhysicalConnectionsResultToKotlin(getVirtualPhysicalConnectionsPlain(argument.toJava()).await())

    /**
     * @see [getVirtualPhysicalConnections].
     * @param businessStatus The commercial status of the physical line. Value:
     * - **Normal**: activated.
     * - **Financialized**: Arrears locked.
     * - **SecurityLocked**: locked for security reasons.
     * @param ids A list of Virtual Physical Connection IDs.
     * @param isConfirmed
     * @param nameRegex A regex string to filter results by Group Metric Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param parentPhysicalConnectionId The ID of the instance of the physical connection.
     * @param virtualPhysicalConnectionIds The ID of the hosted connection. You can specify multiple hosted connection IDs.
     * @param virtualPhysicalConnectionStatus The business status of the shared line. Value:
     * - **Confirmed**: The shared line has been Confirmed to receive.
     * - **UnConfirmed**: The shared line has not been confirmed to be received.
     * - **Deleted**: The shared line has been Deleted.
     * @param vlanIds The VLAN ID of the hosted connection. You can specify multiple VLAN IDs.
     * @param vpconnAliUid The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
     * @return A collection of values returned by getVirtualPhysicalConnections.
     */
    public suspend fun getVirtualPhysicalConnections(
        businessStatus: String? = null,
        ids: List<String>? = null,
        isConfirmed: Boolean? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        parentPhysicalConnectionId: String? = null,
        virtualPhysicalConnectionIds: List<String>? = null,
        virtualPhysicalConnectionStatus: String? = null,
        vlanIds: List<Int>? = null,
        vpconnAliUid: String? = null,
    ): GetVirtualPhysicalConnectionsResult {
        val argument = GetVirtualPhysicalConnectionsPlainArgs(
            businessStatus = businessStatus,
            ids = ids,
            isConfirmed = isConfirmed,
            nameRegex = nameRegex,
            outputFile = outputFile,
            parentPhysicalConnectionId = parentPhysicalConnectionId,
            virtualPhysicalConnectionIds = virtualPhysicalConnectionIds,
            virtualPhysicalConnectionStatus = virtualPhysicalConnectionStatus,
            vlanIds = vlanIds,
            vpconnAliUid = vpconnAliUid,
        )
        return getVirtualPhysicalConnectionsResultToKotlin(getVirtualPhysicalConnectionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualPhysicalConnections].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;expressconnect&#46;kotlin&#46;inputs&#46;GetVirtualPhysicalConnectionsPlainArgs].
     * @return A collection of values returned by getVirtualPhysicalConnections.
     */
    public suspend fun getVirtualPhysicalConnections(argument: suspend GetVirtualPhysicalConnectionsPlainArgsBuilder.() -> Unit): GetVirtualPhysicalConnectionsResult {
        val builder = GetVirtualPhysicalConnectionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualPhysicalConnectionsResultToKotlin(getVirtualPhysicalConnectionsPlain(builtArgument.toJava()).await())
    }
}
