@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PhysicalConnection].
 */
@PulumiTagMarker
public class PhysicalConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PhysicalConnectionArgs = PhysicalConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PhysicalConnectionArgsBuilder.() -> Unit) {
        val builder = PhysicalConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PhysicalConnection {
        val builtJavaResource =
            com.pulumi.alicloud.expressconnect.PhysicalConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PhysicalConnection(builtJavaResource)
    }
}

/**
 * Provides a Express Connect Physical Connection resource.
 * For information about Express Connect Physical Connection and how to use it, see [What is Physical Connection](https://www.alibabacloud.com/help/doc-detail/44852.htm).
 * > **NOTE:** Available since v1.132.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const domestic = new alicloud.expressconnect.PhysicalConnection("domestic", {
 *     accessPointId: "ap-cn-hangzhou-yh-B",
 *     lineOperator: "CT",
 *     peerLocation: "example_value",
 *     physicalConnectionName: "example_value",
 *     type: "VPC",
 *     description: "my domestic connection",
 *     portType: "1000Base-LX",
 *     bandwidth: "100",
 * });
 * const international = new alicloud.expressconnect.PhysicalConnection("international", {
 *     accessPointId: "ap-sg-singpore-A",
 *     lineOperator: "Other",
 *     peerLocation: "example_value",
 *     physicalConnectionName: "example_value",
 *     type: "VPC",
 *     description: "my domestic connection",
 *     portType: "1000Base-LX",
 *     bandwidth: "100",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * domestic = alicloud.expressconnect.PhysicalConnection("domestic",
 *     access_point_id="ap-cn-hangzhou-yh-B",
 *     line_operator="CT",
 *     peer_location="example_value",
 *     physical_connection_name="example_value",
 *     type="VPC",
 *     description="my domestic connection",
 *     port_type="1000Base-LX",
 *     bandwidth="100")
 * international = alicloud.expressconnect.PhysicalConnection("international",
 *     access_point_id="ap-sg-singpore-A",
 *     line_operator="Other",
 *     peer_location="example_value",
 *     physical_connection_name="example_value",
 *     type="VPC",
 *     description="my domestic connection",
 *     port_type="1000Base-LX",
 *     bandwidth="100")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domestic = new AliCloud.ExpressConnect.PhysicalConnection("domestic", new()
 *     {
 *         AccessPointId = "ap-cn-hangzhou-yh-B",
 *         LineOperator = "CT",
 *         PeerLocation = "example_value",
 *         PhysicalConnectionName = "example_value",
 *         Type = "VPC",
 *         Description = "my domestic connection",
 *         PortType = "1000Base-LX",
 *         Bandwidth = "100",
 *     });
 *     var international = new AliCloud.ExpressConnect.PhysicalConnection("international", new()
 *     {
 *         AccessPointId = "ap-sg-singpore-A",
 *         LineOperator = "Other",
 *         PeerLocation = "example_value",
 *         PhysicalConnectionName = "example_value",
 *         Type = "VPC",
 *         Description = "my domestic connection",
 *         PortType = "1000Base-LX",
 *         Bandwidth = "100",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := expressconnect.NewPhysicalConnection(ctx, "domestic", &expressconnect.PhysicalConnectionArgs{
 * 			AccessPointId:          pulumi.String("ap-cn-hangzhou-yh-B"),
 * 			LineOperator:           pulumi.String("CT"),
 * 			PeerLocation:           pulumi.String("example_value"),
 * 			PhysicalConnectionName: pulumi.String("example_value"),
 * 			Type:                   pulumi.String("VPC"),
 * 			Description:            pulumi.String("my domestic connection"),
 * 			PortType:               pulumi.String("1000Base-LX"),
 * 			Bandwidth:              pulumi.String("100"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewPhysicalConnection(ctx, "international", &expressconnect.PhysicalConnectionArgs{
 * 			AccessPointId:          pulumi.String("ap-sg-singpore-A"),
 * 			LineOperator:           pulumi.String("Other"),
 * 			PeerLocation:           pulumi.String("example_value"),
 * 			PhysicalConnectionName: pulumi.String("example_value"),
 * 			Type:                   pulumi.String("VPC"),
 * 			Description:            pulumi.String("my domestic connection"),
 * 			PortType:               pulumi.String("1000Base-LX"),
 * 			Bandwidth:              pulumi.String("100"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.expressconnect.PhysicalConnection;
 * import com.pulumi.alicloud.expressconnect.PhysicalConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domestic = new PhysicalConnection("domestic", PhysicalConnectionArgs.builder()
 *             .accessPointId("ap-cn-hangzhou-yh-B")
 *             .lineOperator("CT")
 *             .peerLocation("example_value")
 *             .physicalConnectionName("example_value")
 *             .type("VPC")
 *             .description("my domestic connection")
 *             .portType("1000Base-LX")
 *             .bandwidth(100)
 *             .build());
 *         var international = new PhysicalConnection("international", PhysicalConnectionArgs.builder()
 *             .accessPointId("ap-sg-singpore-A")
 *             .lineOperator("Other")
 *             .peerLocation("example_value")
 *             .physicalConnectionName("example_value")
 *             .type("VPC")
 *             .description("my domestic connection")
 *             .portType("1000Base-LX")
 *             .bandwidth(100)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   domestic:
 *     type: alicloud:expressconnect:PhysicalConnection
 *     properties:
 *       accessPointId: ap-cn-hangzhou-yh-B
 *       lineOperator: CT
 *       peerLocation: example_value
 *       physicalConnectionName: example_value
 *       type: VPC
 *       description: my domestic connection
 *       portType: 1000Base-LX
 *       bandwidth: 100
 *   international:
 *     type: alicloud:expressconnect:PhysicalConnection
 *     properties:
 *       accessPointId: ap-sg-singpore-A
 *       lineOperator: Other
 *       peerLocation: example_value
 *       physicalConnectionName: example_value
 *       type: VPC
 *       description: my domestic connection
 *       portType: 1000Base-LX
 *       bandwidth: 100
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Physical Connection can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/physicalConnection:PhysicalConnection example <id>
 * ```
 */
public class PhysicalConnection internal constructor(
    override val javaResource: com.pulumi.alicloud.expressconnect.PhysicalConnection,
) : KotlinCustomResource(javaResource, PhysicalConnectionMapper) {
    /**
     * The Physical Leased Line Access Point ID.
     */
    public val accessPointId: Output<String>
        get() = javaResource.accessPointId().applyValue({ args0 -> args0 })

    /**
     * On the Bandwidth of the ECC Service and Physical Connection.
     */
    public val bandwidth: Output<String>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * Operators for Physical Connection Circuit Provided Coding.
     */
    public val circuitCode: Output<String>?
        get() = javaResource.circuitCode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Physical Connection to Which the Description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provides Access to the Physical Line Operator. Valid values:
     * * CT: China Telecom
     * * CU: China Unicom
     * * CM: china Mobile
     * * CO: Other Chinese
     * * Equinix: Equinix
     * * Other: Other Overseas.
     */
    public val lineOperator: Output<String>
        get() = javaResource.lineOperator().applyValue({ args0 -> args0 })

    /**
     * and an on-Premises Data Center Location.
     */
    public val peerLocation: Output<String>?
        get() = javaResource.peerLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * on Behalf of the Resource Name of the Resources-Attribute Field.
     */
    public val physicalConnectionName: Output<String>?
        get() = javaResource.physicalConnectionName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Physical Leased Line Access Port Type. Valid value:
     * * 100Base-T: Fast Electrical Ports
     * * 1000Base-T: gigabit Electrical Ports
     * * 1000Base-LX: Gigabit Singlemode Optical Ports (10Km)
     * * 10GBase-T: Gigabit Electrical Port
     * * 10GBase-LR: Gigabit Singlemode Optical Ports (10Km).
     * * 40GBase-LR: 40 Gigabit Singlemode Optical Ports.
     * * 100GBase-LR: One hundred thousand Gigabit Singlemode Optical Ports.
     * **NOTE:** From in v1.185.0+, The `40GBase-LR` and `100GBase-LR` is valid. and Set these values based on the water levels of background ports. For details about the water levels, contact the business manager.
     */
    public val portType: Output<String>?
        get() = javaResource.portType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Redundant Physical Connection to Which the ID.
     */
    public val redundantPhysicalConnectionId: Output<String>?
        get() = javaResource.redundantPhysicalConnectionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resources on Behalf of a State of the Resource Attribute Field. Valid values: `Canceled`, `Enabled`, `Terminated`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Physical Private Line of Type. Default Value: VPC.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PhysicalConnectionMapper : ResourceMapper<PhysicalConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.expressconnect.PhysicalConnection::class == javaResource::class

    override fun map(javaResource: Resource): PhysicalConnection = PhysicalConnection(
        javaResource as
            com.pulumi.alicloud.expressconnect.PhysicalConnection,
    )
}

/**
 * @see [PhysicalConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PhysicalConnection].
 */
public suspend fun physicalConnection(
    name: String,
    block: suspend PhysicalConnectionResourceBuilder.() -> Unit,
): PhysicalConnection {
    val builder = PhysicalConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PhysicalConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun physicalConnection(name: String): PhysicalConnection {
    val builder = PhysicalConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
