@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.alicloud.expressconnect.PhysicalConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Express Connect Physical Connection resource.
 * For information about Express Connect Physical Connection and how to use it, see [What is Physical Connection](https://www.alibabacloud.com/help/doc-detail/44852.htm).
 * > **NOTE:** Available since v1.132.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const domestic = new alicloud.expressconnect.PhysicalConnection("domestic", {
 *     accessPointId: "ap-cn-hangzhou-yh-B",
 *     lineOperator: "CT",
 *     peerLocation: "example_value",
 *     physicalConnectionName: "example_value",
 *     type: "VPC",
 *     description: "my domestic connection",
 *     portType: "1000Base-LX",
 *     bandwidth: "100",
 * });
 * const international = new alicloud.expressconnect.PhysicalConnection("international", {
 *     accessPointId: "ap-sg-singpore-A",
 *     lineOperator: "Other",
 *     peerLocation: "example_value",
 *     physicalConnectionName: "example_value",
 *     type: "VPC",
 *     description: "my domestic connection",
 *     portType: "1000Base-LX",
 *     bandwidth: "100",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * domestic = alicloud.expressconnect.PhysicalConnection("domestic",
 *     access_point_id="ap-cn-hangzhou-yh-B",
 *     line_operator="CT",
 *     peer_location="example_value",
 *     physical_connection_name="example_value",
 *     type="VPC",
 *     description="my domestic connection",
 *     port_type="1000Base-LX",
 *     bandwidth="100")
 * international = alicloud.expressconnect.PhysicalConnection("international",
 *     access_point_id="ap-sg-singpore-A",
 *     line_operator="Other",
 *     peer_location="example_value",
 *     physical_connection_name="example_value",
 *     type="VPC",
 *     description="my domestic connection",
 *     port_type="1000Base-LX",
 *     bandwidth="100")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domestic = new AliCloud.ExpressConnect.PhysicalConnection("domestic", new()
 *     {
 *         AccessPointId = "ap-cn-hangzhou-yh-B",
 *         LineOperator = "CT",
 *         PeerLocation = "example_value",
 *         PhysicalConnectionName = "example_value",
 *         Type = "VPC",
 *         Description = "my domestic connection",
 *         PortType = "1000Base-LX",
 *         Bandwidth = "100",
 *     });
 *     var international = new AliCloud.ExpressConnect.PhysicalConnection("international", new()
 *     {
 *         AccessPointId = "ap-sg-singpore-A",
 *         LineOperator = "Other",
 *         PeerLocation = "example_value",
 *         PhysicalConnectionName = "example_value",
 *         Type = "VPC",
 *         Description = "my domestic connection",
 *         PortType = "1000Base-LX",
 *         Bandwidth = "100",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := expressconnect.NewPhysicalConnection(ctx, "domestic", &expressconnect.PhysicalConnectionArgs{
 * 			AccessPointId:          pulumi.String("ap-cn-hangzhou-yh-B"),
 * 			LineOperator:           pulumi.String("CT"),
 * 			PeerLocation:           pulumi.String("example_value"),
 * 			PhysicalConnectionName: pulumi.String("example_value"),
 * 			Type:                   pulumi.String("VPC"),
 * 			Description:            pulumi.String("my domestic connection"),
 * 			PortType:               pulumi.String("1000Base-LX"),
 * 			Bandwidth:              pulumi.String("100"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewPhysicalConnection(ctx, "international", &expressconnect.PhysicalConnectionArgs{
 * 			AccessPointId:          pulumi.String("ap-sg-singpore-A"),
 * 			LineOperator:           pulumi.String("Other"),
 * 			PeerLocation:           pulumi.String("example_value"),
 * 			PhysicalConnectionName: pulumi.String("example_value"),
 * 			Type:                   pulumi.String("VPC"),
 * 			Description:            pulumi.String("my domestic connection"),
 * 			PortType:               pulumi.String("1000Base-LX"),
 * 			Bandwidth:              pulumi.String("100"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.expressconnect.PhysicalConnection;
 * import com.pulumi.alicloud.expressconnect.PhysicalConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domestic = new PhysicalConnection("domestic", PhysicalConnectionArgs.builder()
 *             .accessPointId("ap-cn-hangzhou-yh-B")
 *             .lineOperator("CT")
 *             .peerLocation("example_value")
 *             .physicalConnectionName("example_value")
 *             .type("VPC")
 *             .description("my domestic connection")
 *             .portType("1000Base-LX")
 *             .bandwidth(100)
 *             .build());
 *         var international = new PhysicalConnection("international", PhysicalConnectionArgs.builder()
 *             .accessPointId("ap-sg-singpore-A")
 *             .lineOperator("Other")
 *             .peerLocation("example_value")
 *             .physicalConnectionName("example_value")
 *             .type("VPC")
 *             .description("my domestic connection")
 *             .portType("1000Base-LX")
 *             .bandwidth(100)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   domestic:
 *     type: alicloud:expressconnect:PhysicalConnection
 *     properties:
 *       accessPointId: ap-cn-hangzhou-yh-B
 *       lineOperator: CT
 *       peerLocation: example_value
 *       physicalConnectionName: example_value
 *       type: VPC
 *       description: my domestic connection
 *       portType: 1000Base-LX
 *       bandwidth: 100
 *   international:
 *     type: alicloud:expressconnect:PhysicalConnection
 *     properties:
 *       accessPointId: ap-sg-singpore-A
 *       lineOperator: Other
 *       peerLocation: example_value
 *       physicalConnectionName: example_value
 *       type: VPC
 *       description: my domestic connection
 *       portType: 1000Base-LX
 *       bandwidth: 100
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Physical Connection can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/physicalConnection:PhysicalConnection example <id>
 * ```
 * @property accessPointId The Physical Leased Line Access Point ID.
 * @property bandwidth On the Bandwidth of the ECC Service and Physical Connection.
 * @property circuitCode Operators for Physical Connection Circuit Provided Coding.
 * @property description The Physical Connection to Which the Description.
 * @property lineOperator Provides Access to the Physical Line Operator. Valid values:
 * * CT: China Telecom
 * * CU: China Unicom
 * * CM: china Mobile
 * * CO: Other Chinese
 * * Equinix: Equinix
 * * Other: Other Overseas.
 * @property peerLocation and an on-Premises Data Center Location.
 * @property physicalConnectionName on Behalf of the Resource Name of the Resources-Attribute Field.
 * @property portType The Physical Leased Line Access Port Type. Valid value:
 * * 100Base-T: Fast Electrical Ports
 * * 1000Base-T: gigabit Electrical Ports
 * * 1000Base-LX: Gigabit Singlemode Optical Ports (10Km)
 * * 10GBase-T: Gigabit Electrical Port
 * * 10GBase-LR: Gigabit Singlemode Optical Ports (10Km).
 * * 40GBase-LR: 40 Gigabit Singlemode Optical Ports.
 * * 100GBase-LR: One hundred thousand Gigabit Singlemode Optical Ports.
 * **NOTE:** From in v1.185.0+, The `40GBase-LR` and `100GBase-LR` is valid. and Set these values based on the water levels of background ports. For details about the water levels, contact the business manager.
 * @property redundantPhysicalConnectionId Redundant Physical Connection to Which the ID.
 * @property status Resources on Behalf of a State of the Resource Attribute Field. Valid values: `Canceled`, `Enabled`, `Terminated`.
 * @property type Physical Private Line of Type. Default Value: VPC.
 */
public data class PhysicalConnectionArgs(
    public val accessPointId: Output<String>? = null,
    public val bandwidth: Output<String>? = null,
    public val circuitCode: Output<String>? = null,
    public val description: Output<String>? = null,
    public val lineOperator: Output<String>? = null,
    public val peerLocation: Output<String>? = null,
    public val physicalConnectionName: Output<String>? = null,
    public val portType: Output<String>? = null,
    public val redundantPhysicalConnectionId: Output<String>? = null,
    public val status: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.PhysicalConnectionArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.PhysicalConnectionArgs =
        com.pulumi.alicloud.expressconnect.PhysicalConnectionArgs.builder()
            .accessPointId(accessPointId?.applyValue({ args0 -> args0 }))
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .circuitCode(circuitCode?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .lineOperator(lineOperator?.applyValue({ args0 -> args0 }))
            .peerLocation(peerLocation?.applyValue({ args0 -> args0 }))
            .physicalConnectionName(physicalConnectionName?.applyValue({ args0 -> args0 }))
            .portType(portType?.applyValue({ args0 -> args0 }))
            .redundantPhysicalConnectionId(redundantPhysicalConnectionId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PhysicalConnectionArgs].
 */
@PulumiTagMarker
public class PhysicalConnectionArgsBuilder internal constructor() {
    private var accessPointId: Output<String>? = null

    private var bandwidth: Output<String>? = null

    private var circuitCode: Output<String>? = null

    private var description: Output<String>? = null

    private var lineOperator: Output<String>? = null

    private var peerLocation: Output<String>? = null

    private var physicalConnectionName: Output<String>? = null

    private var portType: Output<String>? = null

    private var redundantPhysicalConnectionId: Output<String>? = null

    private var status: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The Physical Leased Line Access Point ID.
     */
    @JvmName("otdwcicjbfjxiklm")
    public suspend fun accessPointId(`value`: Output<String>) {
        this.accessPointId = value
    }

    /**
     * @param value On the Bandwidth of the ECC Service and Physical Connection.
     */
    @JvmName("qdghnnmvslclvobn")
    public suspend fun bandwidth(`value`: Output<String>) {
        this.bandwidth = value
    }

    /**
     * @param value Operators for Physical Connection Circuit Provided Coding.
     */
    @JvmName("qqxmdqcqsryqskno")
    public suspend fun circuitCode(`value`: Output<String>) {
        this.circuitCode = value
    }

    /**
     * @param value The Physical Connection to Which the Description.
     */
    @JvmName("wrwosurxakcqsybj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Provides Access to the Physical Line Operator. Valid values:
     * * CT: China Telecom
     * * CU: China Unicom
     * * CM: china Mobile
     * * CO: Other Chinese
     * * Equinix: Equinix
     * * Other: Other Overseas.
     */
    @JvmName("qjfvuiyupyccndqn")
    public suspend fun lineOperator(`value`: Output<String>) {
        this.lineOperator = value
    }

    /**
     * @param value and an on-Premises Data Center Location.
     */
    @JvmName("jghmpoljsqvqcbjt")
    public suspend fun peerLocation(`value`: Output<String>) {
        this.peerLocation = value
    }

    /**
     * @param value on Behalf of the Resource Name of the Resources-Attribute Field.
     */
    @JvmName("gsccfelwsneyatgv")
    public suspend fun physicalConnectionName(`value`: Output<String>) {
        this.physicalConnectionName = value
    }

    /**
     * @param value The Physical Leased Line Access Port Type. Valid value:
     * * 100Base-T: Fast Electrical Ports
     * * 1000Base-T: gigabit Electrical Ports
     * * 1000Base-LX: Gigabit Singlemode Optical Ports (10Km)
     * * 10GBase-T: Gigabit Electrical Port
     * * 10GBase-LR: Gigabit Singlemode Optical Ports (10Km).
     * * 40GBase-LR: 40 Gigabit Singlemode Optical Ports.
     * * 100GBase-LR: One hundred thousand Gigabit Singlemode Optical Ports.
     * **NOTE:** From in v1.185.0+, The `40GBase-LR` and `100GBase-LR` is valid. and Set these values based on the water levels of background ports. For details about the water levels, contact the business manager.
     */
    @JvmName("ycfujyrtrbgbrtuy")
    public suspend fun portType(`value`: Output<String>) {
        this.portType = value
    }

    /**
     * @param value Redundant Physical Connection to Which the ID.
     */
    @JvmName("scbfsttmprdapxwt")
    public suspend fun redundantPhysicalConnectionId(`value`: Output<String>) {
        this.redundantPhysicalConnectionId = value
    }

    /**
     * @param value Resources on Behalf of a State of the Resource Attribute Field. Valid values: `Canceled`, `Enabled`, `Terminated`.
     */
    @JvmName("nbydkodbeshxxqky")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Physical Private Line of Type. Default Value: VPC.
     */
    @JvmName("dblpyqtxfmmqydte")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The Physical Leased Line Access Point ID.
     */
    @JvmName("mplbgiwheovetcta")
    public suspend fun accessPointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPointId = mapped
    }

    /**
     * @param value On the Bandwidth of the ECC Service and Physical Connection.
     */
    @JvmName("vloffshbxewhyvdk")
    public suspend fun bandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value Operators for Physical Connection Circuit Provided Coding.
     */
    @JvmName("xywtrvhigdhrviyb")
    public suspend fun circuitCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.circuitCode = mapped
    }

    /**
     * @param value The Physical Connection to Which the Description.
     */
    @JvmName("mbvgirasgsgvlrxj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Provides Access to the Physical Line Operator. Valid values:
     * * CT: China Telecom
     * * CU: China Unicom
     * * CM: china Mobile
     * * CO: Other Chinese
     * * Equinix: Equinix
     * * Other: Other Overseas.
     */
    @JvmName("chxpghcgfgahverd")
    public suspend fun lineOperator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lineOperator = mapped
    }

    /**
     * @param value and an on-Premises Data Center Location.
     */
    @JvmName("pxwyscxbeostdqep")
    public suspend fun peerLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerLocation = mapped
    }

    /**
     * @param value on Behalf of the Resource Name of the Resources-Attribute Field.
     */
    @JvmName("krckfaiabcyvbolq")
    public suspend fun physicalConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.physicalConnectionName = mapped
    }

    /**
     * @param value The Physical Leased Line Access Port Type. Valid value:
     * * 100Base-T: Fast Electrical Ports
     * * 1000Base-T: gigabit Electrical Ports
     * * 1000Base-LX: Gigabit Singlemode Optical Ports (10Km)
     * * 10GBase-T: Gigabit Electrical Port
     * * 10GBase-LR: Gigabit Singlemode Optical Ports (10Km).
     * * 40GBase-LR: 40 Gigabit Singlemode Optical Ports.
     * * 100GBase-LR: One hundred thousand Gigabit Singlemode Optical Ports.
     * **NOTE:** From in v1.185.0+, The `40GBase-LR` and `100GBase-LR` is valid. and Set these values based on the water levels of background ports. For details about the water levels, contact the business manager.
     */
    @JvmName("hseajnmjfemoyrxn")
    public suspend fun portType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portType = mapped
    }

    /**
     * @param value Redundant Physical Connection to Which the ID.
     */
    @JvmName("shwmvtndlhrrolmv")
    public suspend fun redundantPhysicalConnectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redundantPhysicalConnectionId = mapped
    }

    /**
     * @param value Resources on Behalf of a State of the Resource Attribute Field. Valid values: `Canceled`, `Enabled`, `Terminated`.
     */
    @JvmName("miugcmvodtpttsht")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Physical Private Line of Type. Default Value: VPC.
     */
    @JvmName("ufqvdssparuwltqw")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PhysicalConnectionArgs = PhysicalConnectionArgs(
        accessPointId = accessPointId,
        bandwidth = bandwidth,
        circuitCode = circuitCode,
        description = description,
        lineOperator = lineOperator,
        peerLocation = peerLocation,
        physicalConnectionName = physicalConnectionName,
        portType = portType,
        redundantPhysicalConnectionId = redundantPhysicalConnectionId,
        status = status,
        type = type,
    )
}
