@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.alicloud.expressconnect.kotlin.outputs.RouterExpressConnectRouterRegion
import com.pulumi.alicloud.expressconnect.kotlin.outputs.RouterExpressConnectRouterRegion.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [RouterExpressConnectRouter].
 */
@PulumiTagMarker
public class RouterExpressConnectRouterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouterExpressConnectRouterArgs = RouterExpressConnectRouterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouterExpressConnectRouterArgsBuilder.() -> Unit) {
        val builder = RouterExpressConnectRouterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RouterExpressConnectRouter {
        val builtJavaResource =
            com.pulumi.alicloud.expressconnect.RouterExpressConnectRouter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RouterExpressConnectRouter(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Express Connect Router Express Connect Router can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/routerExpressConnectRouter:RouterExpressConnectRouter example <id>
 * ```
 */
public class RouterExpressConnectRouter internal constructor(
    override val javaResource: com.pulumi.alicloud.expressconnect.RouterExpressConnectRouter,
) : KotlinCustomResource(javaResource, RouterExpressConnectRouterMapper) {
    /**
     * ASN representing resources.
     */
    public val alibabaSideAsn: Output<Int>
        get() = javaResource.alibabaSideAsn().applyValue({ args0 -> args0 })

    /**
     * Represents the creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Represents the description of the leased line gateway.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the Gateway representing the leased line.
     */
    public val ecrName: Output<String>?
        get() = javaResource.ecrName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * List of regions representing leased line gateways. See `regions` below.
     */
    public val regions: Output<List<RouterExpressConnectRouterRegion>>
        get() = javaResource.regions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The ID of the resource group to which the ECR instance belongs.
     * - A string consisting of letters, numbers, hyphens (-), and underscores (_), and the string length can be 0 to 64 characters.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tag of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object RouterExpressConnectRouterMapper : ResourceMapper<RouterExpressConnectRouter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.expressconnect.RouterExpressConnectRouter::class == javaResource::class

    override fun map(javaResource: Resource): RouterExpressConnectRouter =
        RouterExpressConnectRouter(
            javaResource as
                com.pulumi.alicloud.expressconnect.RouterExpressConnectRouter,
        )
}

/**
 * @see [RouterExpressConnectRouter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouterExpressConnectRouter].
 */
public suspend fun routerExpressConnectRouter(
    name: String,
    block: suspend RouterExpressConnectRouterResourceBuilder.() -> Unit,
): RouterExpressConnectRouter {
    val builder = RouterExpressConnectRouterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouterExpressConnectRouter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routerExpressConnectRouter(name: String): RouterExpressConnectRouter {
    val builder = RouterExpressConnectRouterResourceBuilder()
    builder.name(name)
    return builder.build()
}
