@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.alicloud.expressconnect.RouterExpressConnectRouterArgs.builder
import com.pulumi.alicloud.expressconnect.kotlin.inputs.RouterExpressConnectRouterRegionArgs
import com.pulumi.alicloud.expressconnect.kotlin.inputs.RouterExpressConnectRouterRegionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Express Connect Router Express Connect Router can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/routerExpressConnectRouter:RouterExpressConnectRouter example <id>
 * ```
 * @property alibabaSideAsn ASN representing resources.
 * @property description Represents the description of the leased line gateway.
 * @property ecrName Name of the Gateway representing the leased line.
 * @property regions List of regions representing leased line gateways. See `regions` below.
 * @property resourceGroupId The ID of the resource group to which the ECR instance belongs.
 * - A string consisting of letters, numbers, hyphens (-), and underscores (_), and the string length can be 0 to 64 characters.
 * @property tags The tag of the resource.
 */
public data class RouterExpressConnectRouterArgs(
    public val alibabaSideAsn: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val ecrName: Output<String>? = null,
    public val regions: Output<List<RouterExpressConnectRouterRegionArgs>>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.RouterExpressConnectRouterArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.RouterExpressConnectRouterArgs =
        com.pulumi.alicloud.expressconnect.RouterExpressConnectRouterArgs.builder()
            .alibabaSideAsn(alibabaSideAsn?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .ecrName(ecrName?.applyValue({ args0 -> args0 }))
            .regions(
                regions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RouterExpressConnectRouterArgs].
 */
@PulumiTagMarker
public class RouterExpressConnectRouterArgsBuilder internal constructor() {
    private var alibabaSideAsn: Output<Int>? = null

    private var description: Output<String>? = null

    private var ecrName: Output<String>? = null

    private var regions: Output<List<RouterExpressConnectRouterRegionArgs>>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value ASN representing resources.
     */
    @JvmName("ypydlfpcxvfwfsdi")
    public suspend fun alibabaSideAsn(`value`: Output<Int>) {
        this.alibabaSideAsn = value
    }

    /**
     * @param value Represents the description of the leased line gateway.
     */
    @JvmName("kyyamsrlkapyrmtb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the Gateway representing the leased line.
     */
    @JvmName("xsqgfqnykigaisyb")
    public suspend fun ecrName(`value`: Output<String>) {
        this.ecrName = value
    }

    /**
     * @param value List of regions representing leased line gateways. See `regions` below.
     */
    @JvmName("dynonjyvhlfuudpl")
    public suspend fun regions(`value`: Output<List<RouterExpressConnectRouterRegionArgs>>) {
        this.regions = value
    }

    @JvmName("yetmorpjuhjculve")
    public suspend fun regions(vararg values: Output<RouterExpressConnectRouterRegionArgs>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values List of regions representing leased line gateways. See `regions` below.
     */
    @JvmName("hobgtdunfcskrrfe")
    public suspend fun regions(values: List<Output<RouterExpressConnectRouterRegionArgs>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value The ID of the resource group to which the ECR instance belongs.
     * - A string consisting of letters, numbers, hyphens (-), and underscores (_), and the string length can be 0 to 64 characters.
     */
    @JvmName("dxkuwlbmjhblbsxf")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("ntuelohielrcforg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ASN representing resources.
     */
    @JvmName("nluptrgnyckyhqfy")
    public suspend fun alibabaSideAsn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alibabaSideAsn = mapped
    }

    /**
     * @param value Represents the description of the leased line gateway.
     */
    @JvmName("pevqgpimhwsebvxr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the Gateway representing the leased line.
     */
    @JvmName("rjhrbtkvwtkrarva")
    public suspend fun ecrName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecrName = mapped
    }

    /**
     * @param value List of regions representing leased line gateways. See `regions` below.
     */
    @JvmName("qytcfchigbwjjnst")
    public suspend fun regions(`value`: List<RouterExpressConnectRouterRegionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param argument List of regions representing leased line gateways. See `regions` below.
     */
    @JvmName("vobuupmwitecdfhs")
    public suspend fun regions(argument: List<suspend RouterExpressConnectRouterRegionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RouterExpressConnectRouterRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param argument List of regions representing leased line gateways. See `regions` below.
     */
    @JvmName("imqqlxuhnkfsqqta")
    public suspend fun regions(vararg argument: suspend RouterExpressConnectRouterRegionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RouterExpressConnectRouterRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param argument List of regions representing leased line gateways. See `regions` below.
     */
    @JvmName("ebvffsodqhkapdhd")
    public suspend fun regions(argument: suspend RouterExpressConnectRouterRegionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RouterExpressConnectRouterRegionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param values List of regions representing leased line gateways. See `regions` below.
     */
    @JvmName("livhcwpgbvxuiwla")
    public suspend fun regions(vararg values: RouterExpressConnectRouterRegionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param value The ID of the resource group to which the ECR instance belongs.
     * - A string consisting of letters, numbers, hyphens (-), and underscores (_), and the string length can be 0 to 64 characters.
     */
    @JvmName("aqgxjkawpvmoqkuy")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("cvmjpwunbbfbhkmu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource.
     */
    @JvmName("slkobcioafpllpyd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RouterExpressConnectRouterArgs = RouterExpressConnectRouterArgs(
        alibabaSideAsn = alibabaSideAsn,
        description = description,
        ecrName = ecrName,
        regions = regions,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
