@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RouterInterface].
 */
@PulumiTagMarker
public class RouterInterfaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouterInterfaceArgs = RouterInterfaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouterInterfaceArgsBuilder.() -> Unit) {
        val builder = RouterInterfaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RouterInterface {
        val builtJavaResource =
            com.pulumi.alicloud.expressconnect.RouterInterface(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RouterInterface(builtJavaResource)
    }
}

/**
 * Provides a Express Connect Router Interface resource.
 * For information about Express Connect Router Interface and how to use it, see What is Router Interface.
 * > **NOTE:** Available since v1.199.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.vpc.getNetworks({
 *     nameRegex: "default-NODELETING",
 * });
 * const defaultGetRegions = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultRouterInterface = new alicloud.expressconnect.RouterInterface("default", {
 *     description: name,
 *     oppositeRegionId: defaultGetRegions.then(defaultGetRegions => defaultGetRegions.regions?.[0]?.id),
 *     routerId: _default.then(_default => _default.vpcs?.[0]?.routerId),
 *     role: "InitiatingSide",
 *     routerType: "VRouter",
 *     paymentType: "PayAsYouGo",
 *     routerInterfaceName: name,
 *     spec: "Mini.2",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.vpc.get_networks(name_regex="default-NODELETING")
 * default_get_regions = alicloud.get_regions(current=True)
 * default_router_interface = alicloud.expressconnect.RouterInterface("default",
 *     description=name,
 *     opposite_region_id=default_get_regions.regions[0].id,
 *     router_id=default.vpcs[0].router_id,
 *     role="InitiatingSide",
 *     router_type="VRouter",
 *     payment_type="PayAsYouGo",
 *     router_interface_name=name,
 *     spec="Mini.2")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "default-NODELETING",
 *     });
 *     var defaultGetRegions = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultRouterInterface = new AliCloud.ExpressConnect.RouterInterface("default", new()
 *     {
 *         Description = name,
 *         OppositeRegionId = defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id),
 *         RouterId = @default.Apply(@default => @default.Apply(getNetworksResult => getNetworksResult.Vpcs[0]?.RouterId)),
 *         Role = "InitiatingSide",
 *         RouterType = "VRouter",
 *         PaymentType = "PayAsYouGo",
 *         RouterInterfaceName = name,
 *         Spec = "Mini.2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("default-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetRegions, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewRouterInterface(ctx, "default", &expressconnect.RouterInterfaceArgs{
 * 			Description:         pulumi.String(name),
 * 			OppositeRegionId:    pulumi.String(defaultGetRegions.Regions[0].Id),
 * 			RouterId:            pulumi.String(_default.Vpcs[0].RouterId),
 * 			Role:                pulumi.String("InitiatingSide"),
 * 			RouterType:          pulumi.String("VRouter"),
 * 			PaymentType:         pulumi.String("PayAsYouGo"),
 * 			RouterInterfaceName: pulumi.String(name),
 * 			Spec:                pulumi.String("Mini.2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.expressconnect.RouterInterface;
 * import com.pulumi.alicloud.expressconnect.RouterInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("default-NODELETING")
 *             .build());
 *         final var defaultGetRegions = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultRouterInterface = new RouterInterface("defaultRouterInterface", RouterInterfaceArgs.builder()
 *             .description(name)
 *             .oppositeRegionId(defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()))
 *             .routerId(default_.vpcs()[0].routerId())
 *             .role("InitiatingSide")
 *             .routerType("VRouter")
 *             .paymentType("PayAsYouGo")
 *             .routerInterfaceName(name)
 *             .spec("Mini.2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultRouterInterface:
 *     type: alicloud:expressconnect:RouterInterface
 *     name: default
 *     properties:
 *       description: ${name}
 *       oppositeRegionId: ${defaultGetRegions.regions[0].id}
 *       routerId: ${default.vpcs[0].routerId}
 *       role: InitiatingSide
 *       routerType: VRouter
 *       paymentType: PayAsYouGo
 *       routerInterfaceName: ${name}
 *       spec: Mini.2
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: default-NODELETING
 *   defaultGetRegions:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Router Interface can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/routerInterface:RouterInterface example <id>
 * ```
 */
public class RouterInterface internal constructor(
    override val javaResource: com.pulumi.alicloud.expressconnect.RouterInterface,
) : KotlinCustomResource(javaResource, RouterInterfaceMapper) {
    /**
     * The access point ID to which the VBR belongs.
     */
    public val accessPointId: Output<String>?
        get() = javaResource.accessPointId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to pay automatically, value:-**false** (default): automatic payment is not enabled. After generating an order, you need to complete the payment at the order center.-**true**: Enable automatic payment to automatically pay for orders.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
     */
    public val autoPay: Output<Boolean>?
        get() = javaResource.autoPay().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The bandwidth of the resource.
     */
    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The businessStatus of the resource. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
     */
    public val businessStatus: Output<String>
        get() = javaResource.businessStatus().applyValue({ args0 -> args0 })

    /**
     * The connected time of the resource.
     */
    public val connectedTime: Output<String>
        get() = javaResource.connectedTime().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The cross border of the resource.
     */
    public val crossBorder: Output<Boolean>
        get() = javaResource.crossBorder().applyValue({ args0 -> args0 })

    /**
     * Whether to delete the health check IP address configured on the router interface. Value:-**true**: deletes the health check IP address.-**false** (default): does not delete the health check IP address.
     */
    public val deleteHealthCheckIp: Output<Boolean>?
        get() = javaResource.deleteHealthCheckIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the router interface. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The end time of the resource.
     */
    public val endTime: Output<String>
        get() = javaResource.endTime().applyValue({ args0 -> args0 })

    /**
     * The has reservation data of the resource.
     */
    public val hasReservationData: Output<String>
        get() = javaResource.hasReservationData().applyValue({ args0 -> args0 })

    /**
     * The health check rate. Unit: seconds. The recommended value is 2. This indicates the interval between successive probe messages sent during the specified health check.
     */
    public val hcRate: Output<Int>?
        get() = javaResource.hcRate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The health check thresholds. Unit: pcs. The recommended value is 8. This indicates the number of probe messages to be sent during the specified health check.
     */
    public val hcThreshold: Output<String>?
        get() = javaResource.hcThreshold().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The health check source IP address, must be an unused IP within the local VPC.
     */
    public val healthCheckSourceIp: Output<String>?
        get() = javaResource.healthCheckSourceIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IP address for health screening purposes.
     */
    public val healthCheckTargetIp: Output<String>?
        get() = javaResource.healthCheckTargetIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Access point ID to which the other end belongs.
     */
    public val oppositeAccessPointId: Output<String>?
        get() = javaResource.oppositeAccessPointId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The opposite bandwidth of the router on the other side.
     */
    public val oppositeBandwidth: Output<Int>
        get() = javaResource.oppositeBandwidth().applyValue({ args0 -> args0 })

    /**
     * The opposite interface business status of the router on the other side. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
     */
    public val oppositeInterfaceBusinessStatus: Output<String>
        get() = javaResource.oppositeInterfaceBusinessStatus().applyValue({ args0 -> args0 })

    /**
     * The Interface ID of the router at the other end.
     */
    public val oppositeInterfaceId: Output<String>?
        get() = javaResource.oppositeInterfaceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The AliCloud account ID of the owner of the router interface on the other end.
     */
    public val oppositeInterfaceOwnerId: Output<String>?
        get() = javaResource.oppositeInterfaceOwnerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The opposite interface spec of the router on the other side. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
     */
    public val oppositeInterfaceSpec: Output<String>
        get() = javaResource.oppositeInterfaceSpec().applyValue({ args0 -> args0 })

    /**
     * The opposite interface status of the router on the other side. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
     */
    public val oppositeInterfaceStatus: Output<String>
        get() = javaResource.oppositeInterfaceStatus().applyValue({ args0 -> args0 })

    /**
     * The geographical ID of the location of the receiving end of the connection.
     */
    public val oppositeRegionId: Output<String>
        get() = javaResource.oppositeRegionId().applyValue({ args0 -> args0 })

    /**
     * The id of the router at the other end.
     */
    public val oppositeRouterId: Output<String>?
        get() = javaResource.oppositeRouterId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The opposite router type of the router on the other side. Valid Values: `VRouter`, `VBR`.
     */
    public val oppositeRouterType: Output<String>
        get() = javaResource.oppositeRouterType().applyValue({ args0 -> args0 })

    /**
     * The opposite vpc instance id of the router on the other side.
     */
    public val oppositeVpcInstanceId: Output<String>
        get() = javaResource.oppositeVpcInstanceId().applyValue({ args0 -> args0 })

    /**
     * The payment methods for router interfaces. Valid Values: `PayAsYouGo`, `Subscription`.
     */
    public val paymentType: Output<String>?
        get() = javaResource.paymentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Purchase duration, value:-When you choose to pay on a monthly basis, the value range is **1 to 9 * *.-When you choose to pay per year, the value range is **1 to 3 * *.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The billing cycle of the prepaid fee. Valid values:-**Month** (default): monthly payment.-**Year**: Pay per Year.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
     */
    public val pricingCycle: Output<String>?
        get() = javaResource.pricingCycle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The reservation active time of the resource.
     */
    public val reservationActiveTime: Output<String>
        get() = javaResource.reservationActiveTime().applyValue({ args0 -> args0 })

    /**
     * The reservation bandwidth of the resource.
     */
    public val reservationBandwidth: Output<String>
        get() = javaResource.reservationBandwidth().applyValue({ args0 -> args0 })

    /**
     * The reservation internet charge type of the resource.
     */
    public val reservationInternetChargeType: Output<String>
        get() = javaResource.reservationInternetChargeType().applyValue({ args0 -> args0 })

    /**
     * The reservation order type of the resource.
     */
    public val reservationOrderType: Output<String>
        get() = javaResource.reservationOrderType().applyValue({ args0 -> args0 })

    /**
     * The role of the router interface. Valid Values: `InitiatingSide`, `AcceptingSide`.
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * The router id associated with the router interface.
     */
    public val routerId: Output<String>
        get() = javaResource.routerId().applyValue({ args0 -> args0 })

    /**
     * The first ID of the resource.
     */
    public val routerInterfaceId: Output<String>
        get() = javaResource.routerInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val routerInterfaceName: Output<String>?
        get() = javaResource.routerInterfaceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of router associated with the router interface. Valid Values: `VRouter`, `VBR`.
     */
    public val routerType: Output<String>
        get() = javaResource.routerType().applyValue({ args0 -> args0 })

    /**
     * The specification of the router interface. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
     */
    public val spec: Output<String>
        get() = javaResource.spec().applyValue({ args0 -> args0 })

    /**
     * The status of the resource. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The vpc instance id of the resource.
     */
    public val vpcInstanceId: Output<String>
        get() = javaResource.vpcInstanceId().applyValue({ args0 -> args0 })
}

public object RouterInterfaceMapper : ResourceMapper<RouterInterface> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.expressconnect.RouterInterface::class == javaResource::class

    override fun map(javaResource: Resource): RouterInterface = RouterInterface(
        javaResource as
            com.pulumi.alicloud.expressconnect.RouterInterface,
    )
}

/**
 * @see [RouterInterface].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouterInterface].
 */
public suspend fun routerInterface(
    name: String,
    block: suspend RouterInterfaceResourceBuilder.() -> Unit,
): RouterInterface {
    val builder = RouterInterfaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouterInterface].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routerInterface(name: String): RouterInterface {
    val builder = RouterInterfaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
