@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.alicloud.expressconnect.RouterInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Express Connect Router Interface resource.
 * For information about Express Connect Router Interface and how to use it, see What is Router Interface.
 * > **NOTE:** Available since v1.199.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.vpc.getNetworks({
 *     nameRegex: "default-NODELETING",
 * });
 * const defaultGetRegions = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultRouterInterface = new alicloud.expressconnect.RouterInterface("default", {
 *     description: name,
 *     oppositeRegionId: defaultGetRegions.then(defaultGetRegions => defaultGetRegions.regions?.[0]?.id),
 *     routerId: _default.then(_default => _default.vpcs?.[0]?.routerId),
 *     role: "InitiatingSide",
 *     routerType: "VRouter",
 *     paymentType: "PayAsYouGo",
 *     routerInterfaceName: name,
 *     spec: "Mini.2",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.vpc.get_networks(name_regex="default-NODELETING")
 * default_get_regions = alicloud.get_regions(current=True)
 * default_router_interface = alicloud.expressconnect.RouterInterface("default",
 *     description=name,
 *     opposite_region_id=default_get_regions.regions[0].id,
 *     router_id=default.vpcs[0].router_id,
 *     role="InitiatingSide",
 *     router_type="VRouter",
 *     payment_type="PayAsYouGo",
 *     router_interface_name=name,
 *     spec="Mini.2")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "default-NODELETING",
 *     });
 *     var defaultGetRegions = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultRouterInterface = new AliCloud.ExpressConnect.RouterInterface("default", new()
 *     {
 *         Description = name,
 *         OppositeRegionId = defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id),
 *         RouterId = @default.Apply(@default => @default.Apply(getNetworksResult => getNetworksResult.Vpcs[0]?.RouterId)),
 *         Role = "InitiatingSide",
 *         RouterType = "VRouter",
 *         PaymentType = "PayAsYouGo",
 *         RouterInterfaceName = name,
 *         Spec = "Mini.2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("default-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetRegions, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewRouterInterface(ctx, "default", &expressconnect.RouterInterfaceArgs{
 * 			Description:         pulumi.String(name),
 * 			OppositeRegionId:    pulumi.String(defaultGetRegions.Regions[0].Id),
 * 			RouterId:            pulumi.String(_default.Vpcs[0].RouterId),
 * 			Role:                pulumi.String("InitiatingSide"),
 * 			RouterType:          pulumi.String("VRouter"),
 * 			PaymentType:         pulumi.String("PayAsYouGo"),
 * 			RouterInterfaceName: pulumi.String(name),
 * 			Spec:                pulumi.String("Mini.2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.expressconnect.RouterInterface;
 * import com.pulumi.alicloud.expressconnect.RouterInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("default-NODELETING")
 *             .build());
 *         final var defaultGetRegions = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultRouterInterface = new RouterInterface("defaultRouterInterface", RouterInterfaceArgs.builder()
 *             .description(name)
 *             .oppositeRegionId(defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()))
 *             .routerId(default_.vpcs()[0].routerId())
 *             .role("InitiatingSide")
 *             .routerType("VRouter")
 *             .paymentType("PayAsYouGo")
 *             .routerInterfaceName(name)
 *             .spec("Mini.2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultRouterInterface:
 *     type: alicloud:expressconnect:RouterInterface
 *     name: default
 *     properties:
 *       description: ${name}
 *       oppositeRegionId: ${defaultGetRegions.regions[0].id}
 *       routerId: ${default.vpcs[0].routerId}
 *       role: InitiatingSide
 *       routerType: VRouter
 *       paymentType: PayAsYouGo
 *       routerInterfaceName: ${name}
 *       spec: Mini.2
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: default-NODELETING
 *   defaultGetRegions:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Router Interface can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/routerInterface:RouterInterface example <id>
 * ```
 * @property accessPointId The access point ID to which the VBR belongs.
 * @property autoPay Whether to pay automatically, value:-**false** (default): automatic payment is not enabled. After generating an order, you need to complete the payment at the order center.-**true**: Enable automatic payment to automatically pay for orders.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
 * @property deleteHealthCheckIp Whether to delete the health check IP address configured on the router interface. Value:-**true**: deletes the health check IP address.-**false** (default): does not delete the health check IP address.
 * @property description The description of the router interface. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
 * @property hcRate The health check rate. Unit: seconds. The recommended value is 2. This indicates the interval between successive probe messages sent during the specified health check.
 * @property hcThreshold The health check thresholds. Unit: pcs. The recommended value is 8. This indicates the number of probe messages to be sent during the specified health check.
 * @property healthCheckSourceIp The health check source IP address, must be an unused IP within the local VPC.
 * @property healthCheckTargetIp The IP address for health screening purposes.
 * @property oppositeAccessPointId The Access point ID to which the other end belongs.
 * @property oppositeInterfaceId The Interface ID of the router at the other end.
 * @property oppositeInterfaceOwnerId The AliCloud account ID of the owner of the router interface on the other end.
 * @property oppositeRegionId The geographical ID of the location of the receiving end of the connection.
 * @property oppositeRouterId The id of the router at the other end.
 * @property oppositeRouterType The opposite router type of the router on the other side. Valid Values: `VRouter`, `VBR`.
 * @property paymentType The payment methods for router interfaces. Valid Values: `PayAsYouGo`, `Subscription`.
 * @property period Purchase duration, value:-When you choose to pay on a monthly basis, the value range is **1 to 9 * *.-When you choose to pay per year, the value range is **1 to 3 * *.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
 * @property pricingCycle The billing cycle of the prepaid fee. Valid values:-**Month** (default): monthly payment.-**Year**: Pay per Year.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
 * @property role The role of the router interface. Valid Values: `InitiatingSide`, `AcceptingSide`.
 * @property routerId The router id associated with the router interface.
 * @property routerInterfaceId The first ID of the resource.
 * @property routerInterfaceName The name of the resource.
 * @property routerType The type of router associated with the router interface. Valid Values: `VRouter`, `VBR`.
 * @property spec The specification of the router interface. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
 * @property status The status of the resource. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
 */
public data class RouterInterfaceArgs(
    public val accessPointId: Output<String>? = null,
    public val autoPay: Output<Boolean>? = null,
    public val deleteHealthCheckIp: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val hcRate: Output<Int>? = null,
    public val hcThreshold: Output<String>? = null,
    public val healthCheckSourceIp: Output<String>? = null,
    public val healthCheckTargetIp: Output<String>? = null,
    public val oppositeAccessPointId: Output<String>? = null,
    public val oppositeInterfaceId: Output<String>? = null,
    public val oppositeInterfaceOwnerId: Output<String>? = null,
    public val oppositeRegionId: Output<String>? = null,
    public val oppositeRouterId: Output<String>? = null,
    public val oppositeRouterType: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val pricingCycle: Output<String>? = null,
    public val role: Output<String>? = null,
    public val routerId: Output<String>? = null,
    public val routerInterfaceId: Output<String>? = null,
    public val routerInterfaceName: Output<String>? = null,
    public val routerType: Output<String>? = null,
    public val spec: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.RouterInterfaceArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.RouterInterfaceArgs =
        com.pulumi.alicloud.expressconnect.RouterInterfaceArgs.builder()
            .accessPointId(accessPointId?.applyValue({ args0 -> args0 }))
            .autoPay(autoPay?.applyValue({ args0 -> args0 }))
            .deleteHealthCheckIp(deleteHealthCheckIp?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .hcRate(hcRate?.applyValue({ args0 -> args0 }))
            .hcThreshold(hcThreshold?.applyValue({ args0 -> args0 }))
            .healthCheckSourceIp(healthCheckSourceIp?.applyValue({ args0 -> args0 }))
            .healthCheckTargetIp(healthCheckTargetIp?.applyValue({ args0 -> args0 }))
            .oppositeAccessPointId(oppositeAccessPointId?.applyValue({ args0 -> args0 }))
            .oppositeInterfaceId(oppositeInterfaceId?.applyValue({ args0 -> args0 }))
            .oppositeInterfaceOwnerId(oppositeInterfaceOwnerId?.applyValue({ args0 -> args0 }))
            .oppositeRegionId(oppositeRegionId?.applyValue({ args0 -> args0 }))
            .oppositeRouterId(oppositeRouterId?.applyValue({ args0 -> args0 }))
            .oppositeRouterType(oppositeRouterType?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .pricingCycle(pricingCycle?.applyValue({ args0 -> args0 }))
            .role(role?.applyValue({ args0 -> args0 }))
            .routerId(routerId?.applyValue({ args0 -> args0 }))
            .routerInterfaceId(routerInterfaceId?.applyValue({ args0 -> args0 }))
            .routerInterfaceName(routerInterfaceName?.applyValue({ args0 -> args0 }))
            .routerType(routerType?.applyValue({ args0 -> args0 }))
            .spec(spec?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouterInterfaceArgs].
 */
@PulumiTagMarker
public class RouterInterfaceArgsBuilder internal constructor() {
    private var accessPointId: Output<String>? = null

    private var autoPay: Output<Boolean>? = null

    private var deleteHealthCheckIp: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var hcRate: Output<Int>? = null

    private var hcThreshold: Output<String>? = null

    private var healthCheckSourceIp: Output<String>? = null

    private var healthCheckTargetIp: Output<String>? = null

    private var oppositeAccessPointId: Output<String>? = null

    private var oppositeInterfaceId: Output<String>? = null

    private var oppositeInterfaceOwnerId: Output<String>? = null

    private var oppositeRegionId: Output<String>? = null

    private var oppositeRouterId: Output<String>? = null

    private var oppositeRouterType: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var pricingCycle: Output<String>? = null

    private var role: Output<String>? = null

    private var routerId: Output<String>? = null

    private var routerInterfaceId: Output<String>? = null

    private var routerInterfaceName: Output<String>? = null

    private var routerType: Output<String>? = null

    private var spec: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The access point ID to which the VBR belongs.
     */
    @JvmName("tncnbmjvvhqnotjs")
    public suspend fun accessPointId(`value`: Output<String>) {
        this.accessPointId = value
    }

    /**
     * @param value Whether to pay automatically, value:-**false** (default): automatic payment is not enabled. After generating an order, you need to complete the payment at the order center.-**true**: Enable automatic payment to automatically pay for orders.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
     */
    @JvmName("dilxfvvnomguwrrw")
    public suspend fun autoPay(`value`: Output<Boolean>) {
        this.autoPay = value
    }

    /**
     * @param value Whether to delete the health check IP address configured on the router interface. Value:-**true**: deletes the health check IP address.-**false** (default): does not delete the health check IP address.
     */
    @JvmName("grebfqpakejoytdj")
    public suspend fun deleteHealthCheckIp(`value`: Output<Boolean>) {
        this.deleteHealthCheckIp = value
    }

    /**
     * @param value The description of the router interface. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("cwisktvbxdiktmhw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The health check rate. Unit: seconds. The recommended value is 2. This indicates the interval between successive probe messages sent during the specified health check.
     */
    @JvmName("qtyjyvcuxqnpfglh")
    public suspend fun hcRate(`value`: Output<Int>) {
        this.hcRate = value
    }

    /**
     * @param value The health check thresholds. Unit: pcs. The recommended value is 8. This indicates the number of probe messages to be sent during the specified health check.
     */
    @JvmName("jkuutagimrvkybja")
    public suspend fun hcThreshold(`value`: Output<String>) {
        this.hcThreshold = value
    }

    /**
     * @param value The health check source IP address, must be an unused IP within the local VPC.
     */
    @JvmName("pdpqiyoxxicnlvmt")
    public suspend fun healthCheckSourceIp(`value`: Output<String>) {
        this.healthCheckSourceIp = value
    }

    /**
     * @param value The IP address for health screening purposes.
     */
    @JvmName("yhyotpergumtgjdc")
    public suspend fun healthCheckTargetIp(`value`: Output<String>) {
        this.healthCheckTargetIp = value
    }

    /**
     * @param value The Access point ID to which the other end belongs.
     */
    @JvmName("tdmnnpwhhiwxoycl")
    public suspend fun oppositeAccessPointId(`value`: Output<String>) {
        this.oppositeAccessPointId = value
    }

    /**
     * @param value The Interface ID of the router at the other end.
     */
    @JvmName("qgvujqqyaenubwho")
    public suspend fun oppositeInterfaceId(`value`: Output<String>) {
        this.oppositeInterfaceId = value
    }

    /**
     * @param value The AliCloud account ID of the owner of the router interface on the other end.
     */
    @JvmName("ikviuoitjjwffalu")
    public suspend fun oppositeInterfaceOwnerId(`value`: Output<String>) {
        this.oppositeInterfaceOwnerId = value
    }

    /**
     * @param value The geographical ID of the location of the receiving end of the connection.
     */
    @JvmName("suqbjeyawbdtpqwx")
    public suspend fun oppositeRegionId(`value`: Output<String>) {
        this.oppositeRegionId = value
    }

    /**
     * @param value The id of the router at the other end.
     */
    @JvmName("pribideyqfmtrfow")
    public suspend fun oppositeRouterId(`value`: Output<String>) {
        this.oppositeRouterId = value
    }

    /**
     * @param value The opposite router type of the router on the other side. Valid Values: `VRouter`, `VBR`.
     */
    @JvmName("flyeyirsduskkbbg")
    public suspend fun oppositeRouterType(`value`: Output<String>) {
        this.oppositeRouterType = value
    }

    /**
     * @param value The payment methods for router interfaces. Valid Values: `PayAsYouGo`, `Subscription`.
     */
    @JvmName("sekxqethbwsnqfdo")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Purchase duration, value:-When you choose to pay on a monthly basis, the value range is **1 to 9 * *.-When you choose to pay per year, the value range is **1 to 3 * *.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
     */
    @JvmName("ptqfouaxtrmpnupg")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The billing cycle of the prepaid fee. Valid values:-**Month** (default): monthly payment.-**Year**: Pay per Year.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
     */
    @JvmName("tlfngflxgknhawfm")
    public suspend fun pricingCycle(`value`: Output<String>) {
        this.pricingCycle = value
    }

    /**
     * @param value The role of the router interface. Valid Values: `InitiatingSide`, `AcceptingSide`.
     */
    @JvmName("esandgpgtarydcym")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value The router id associated with the router interface.
     */
    @JvmName("sjwuvgqpomxtvxvs")
    public suspend fun routerId(`value`: Output<String>) {
        this.routerId = value
    }

    /**
     * @param value The first ID of the resource.
     */
    @JvmName("hbxnyotipvomuatv")
    public suspend fun routerInterfaceId(`value`: Output<String>) {
        this.routerInterfaceId = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("mxrbghtgnblitikb")
    public suspend fun routerInterfaceName(`value`: Output<String>) {
        this.routerInterfaceName = value
    }

    /**
     * @param value The type of router associated with the router interface. Valid Values: `VRouter`, `VBR`.
     */
    @JvmName("ujncqoxxqcbnurhm")
    public suspend fun routerType(`value`: Output<String>) {
        this.routerType = value
    }

    /**
     * @param value The specification of the router interface. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
     */
    @JvmName("yigobtpmofthhfef")
    public suspend fun spec(`value`: Output<String>) {
        this.spec = value
    }

    /**
     * @param value The status of the resource. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
     */
    @JvmName("udmswdhpjgrjtljd")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The access point ID to which the VBR belongs.
     */
    @JvmName("lcwkudkewwiysvst")
    public suspend fun accessPointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPointId = mapped
    }

    /**
     * @param value Whether to pay automatically, value:-**false** (default): automatic payment is not enabled. After generating an order, you need to complete the payment at the order center.-**true**: Enable automatic payment to automatically pay for orders.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
     */
    @JvmName("xkqjsqwiapgbiojm")
    public suspend fun autoPay(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPay = mapped
    }

    /**
     * @param value Whether to delete the health check IP address configured on the router interface. Value:-**true**: deletes the health check IP address.-**false** (default): does not delete the health check IP address.
     */
    @JvmName("ypbdelahyxwqaurr")
    public suspend fun deleteHealthCheckIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteHealthCheckIp = mapped
    }

    /**
     * @param value The description of the router interface. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("wqhqyqrjvwebiosl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The health check rate. Unit: seconds. The recommended value is 2. This indicates the interval between successive probe messages sent during the specified health check.
     */
    @JvmName("jdxvvsyypbwyrsmp")
    public suspend fun hcRate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hcRate = mapped
    }

    /**
     * @param value The health check thresholds. Unit: pcs. The recommended value is 8. This indicates the number of probe messages to be sent during the specified health check.
     */
    @JvmName("gvdymqsbgdbetgak")
    public suspend fun hcThreshold(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hcThreshold = mapped
    }

    /**
     * @param value The health check source IP address, must be an unused IP within the local VPC.
     */
    @JvmName("cwkutmrnnsnvnnwh")
    public suspend fun healthCheckSourceIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckSourceIp = mapped
    }

    /**
     * @param value The IP address for health screening purposes.
     */
    @JvmName("xttgkicdolusumla")
    public suspend fun healthCheckTargetIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckTargetIp = mapped
    }

    /**
     * @param value The Access point ID to which the other end belongs.
     */
    @JvmName("xltwcrpgcfpolyja")
    public suspend fun oppositeAccessPointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oppositeAccessPointId = mapped
    }

    /**
     * @param value The Interface ID of the router at the other end.
     */
    @JvmName("iihupjbtohqoaihh")
    public suspend fun oppositeInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oppositeInterfaceId = mapped
    }

    /**
     * @param value The AliCloud account ID of the owner of the router interface on the other end.
     */
    @JvmName("lgqgxkqptdebqdrx")
    public suspend fun oppositeInterfaceOwnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oppositeInterfaceOwnerId = mapped
    }

    /**
     * @param value The geographical ID of the location of the receiving end of the connection.
     */
    @JvmName("cinndghooteyehsn")
    public suspend fun oppositeRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oppositeRegionId = mapped
    }

    /**
     * @param value The id of the router at the other end.
     */
    @JvmName("jgdgpideerlfmpcg")
    public suspend fun oppositeRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oppositeRouterId = mapped
    }

    /**
     * @param value The opposite router type of the router on the other side. Valid Values: `VRouter`, `VBR`.
     */
    @JvmName("utppbvxvvionyonf")
    public suspend fun oppositeRouterType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oppositeRouterType = mapped
    }

    /**
     * @param value The payment methods for router interfaces. Valid Values: `PayAsYouGo`, `Subscription`.
     */
    @JvmName("pfkdgghbyjcgylxy")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Purchase duration, value:-When you choose to pay on a monthly basis, the value range is **1 to 9 * *.-When you choose to pay per year, the value range is **1 to 3 * *.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
     */
    @JvmName("prdtjbxgjpxxlosh")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The billing cycle of the prepaid fee. Valid values:-**Month** (default): monthly payment.-**Year**: Pay per Year.> **InstanceChargeType** is required when the value of the parameter is **PrePaid.
     */
    @JvmName("vhucggnyhkaponfl")
    public suspend fun pricingCycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricingCycle = mapped
    }

    /**
     * @param value The role of the router interface. Valid Values: `InitiatingSide`, `AcceptingSide`.
     */
    @JvmName("hdbpsjrprfsbrqmj")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The router id associated with the router interface.
     */
    @JvmName("fjqtwtmtunsbqqtf")
    public suspend fun routerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routerId = mapped
    }

    /**
     * @param value The first ID of the resource.
     */
    @JvmName("cdcsajvhmlyyjnqq")
    public suspend fun routerInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routerInterfaceId = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("wgqbjofeucuahqui")
    public suspend fun routerInterfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routerInterfaceName = mapped
    }

    /**
     * @param value The type of router associated with the router interface. Valid Values: `VRouter`, `VBR`.
     */
    @JvmName("rsnexdnuucoyseks")
    public suspend fun routerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routerType = mapped
    }

    /**
     * @param value The specification of the router interface. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
     */
    @JvmName("ecgkilwitfefnsdk")
    public suspend fun spec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param value The status of the resource. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
     */
    @JvmName("eklcgbjkqdulwtmg")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): RouterInterfaceArgs = RouterInterfaceArgs(
        accessPointId = accessPointId,
        autoPay = autoPay,
        deleteHealthCheckIp = deleteHealthCheckIp,
        description = description,
        hcRate = hcRate,
        hcThreshold = hcThreshold,
        healthCheckSourceIp = healthCheckSourceIp,
        healthCheckTargetIp = healthCheckTargetIp,
        oppositeAccessPointId = oppositeAccessPointId,
        oppositeInterfaceId = oppositeInterfaceId,
        oppositeInterfaceOwnerId = oppositeInterfaceOwnerId,
        oppositeRegionId = oppositeRegionId,
        oppositeRouterId = oppositeRouterId,
        oppositeRouterType = oppositeRouterType,
        paymentType = paymentType,
        period = period,
        pricingCycle = pricingCycle,
        role = role,
        routerId = routerId,
        routerInterfaceId = routerInterfaceId,
        routerInterfaceName = routerInterfaceName,
        routerType = routerType,
        spec = spec,
        status = status,
    )
}
