@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.alicloud.expressconnect.RouterTrAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Express Connect Router Express Connect Router Tr Association resource. Leased line gateway and TR binding relationship object.
 * For information about Express Connect Router Express Connect Router Tr Association and how to use it, see [What is Express Connect Router Tr Association](https://next.api.alibabacloud.com/api/ExpressConnectRouter/2023-09-01/CreateExpressConnectRouterAssociation).
 * > **NOTE:** Available since v1.224.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const alowprefix1 = config.get("alowprefix1") || "10.0.0.0/24";
 * const allowprefix2 = config.get("allowprefix2") || "10.0.1.0/24";
 * const allowprefix3 = config.get("allowprefix3") || "10.0.2.0/24";
 * const allowprefix4 = config.get("allowprefix4") || "10.0.3.0/24";
 * const asn = config.get("asn") || "4200001003";
 * const defaultpX0KlC = new alicloud.expressconnect.RouterExpressConnectRouter("defaultpX0KlC", {alibabaSideAsn: asn});
 * const default418DC9 = new alicloud.cen.Instance("default418DC9", {cenInstanceName: name});
 * const defaultRYcjsc = new alicloud.cen.TransitRouter("defaultRYcjsc", {cenId: default418DC9.id});
 * const current = alicloud.getAccount({});
 * const _default = new alicloud.expressconnect.RouterTrAssociation("default", {
 *     ecrId: defaultpX0KlC.id,
 *     cenId: default418DC9.id,
 *     transitRouterOwnerId: current.then(current => current.id),
 *     allowedPrefixes: [
 *         alowprefix1,
 *         allowprefix3,
 *         allowprefix2,
 *     ],
 *     transitRouterId: defaultRYcjsc.transitRouterId,
 *     associationRegionId: "cn-hangzhou",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * alowprefix1 = config.get("alowprefix1")
 * if alowprefix1 is None:
 *     alowprefix1 = "10.0.0.0/24"
 * allowprefix2 = config.get("allowprefix2")
 * if allowprefix2 is None:
 *     allowprefix2 = "10.0.1.0/24"
 * allowprefix3 = config.get("allowprefix3")
 * if allowprefix3 is None:
 *     allowprefix3 = "10.0.2.0/24"
 * allowprefix4 = config.get("allowprefix4")
 * if allowprefix4 is None:
 *     allowprefix4 = "10.0.3.0/24"
 * asn = config.get("asn")
 * if asn is None:
 *     asn = "4200001003"
 * defaultp_x0_kl_c = alicloud.expressconnect.RouterExpressConnectRouter("defaultpX0KlC", alibaba_side_asn=asn)
 * default418_dc9 = alicloud.cen.Instance("default418DC9", cen_instance_name=name)
 * default_r_ycjsc = alicloud.cen.TransitRouter("defaultRYcjsc", cen_id=default418_dc9.id)
 * current = alicloud.get_account()
 * default = alicloud.expressconnect.RouterTrAssociation("default",
 *     ecr_id=defaultp_x0_kl_c.id,
 *     cen_id=default418_dc9.id,
 *     transit_router_owner_id=current.id,
 *     allowed_prefixes=[
 *         alowprefix1,
 *         allowprefix3,
 *         allowprefix2,
 *     ],
 *     transit_router_id=default_r_ycjsc.transit_router_id,
 *     association_region_id="cn-hangzhou")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var alowprefix1 = config.Get("alowprefix1") ?? "10.0.0.0/24";
 *     var allowprefix2 = config.Get("allowprefix2") ?? "10.0.1.0/24";
 *     var allowprefix3 = config.Get("allowprefix3") ?? "10.0.2.0/24";
 *     var allowprefix4 = config.Get("allowprefix4") ?? "10.0.3.0/24";
 *     var asn = config.Get("asn") ?? "4200001003";
 *     var defaultpX0KlC = new AliCloud.ExpressConnect.RouterExpressConnectRouter("defaultpX0KlC", new()
 *     {
 *         AlibabaSideAsn = asn,
 *     });
 *     var default418DC9 = new AliCloud.Cen.Instance("default418DC9", new()
 *     {
 *         CenInstanceName = name,
 *     });
 *     var defaultRYcjsc = new AliCloud.Cen.TransitRouter("defaultRYcjsc", new()
 *     {
 *         CenId = default418DC9.Id,
 *     });
 *     var current = AliCloud.GetAccount.Invoke();
 *     var @default = new AliCloud.ExpressConnect.RouterTrAssociation("default", new()
 *     {
 *         EcrId = defaultpX0KlC.Id,
 *         CenId = default418DC9.Id,
 *         TransitRouterOwnerId = current.Apply(getAccountResult => getAccountResult.Id),
 *         AllowedPrefixes = new[]
 *         {
 *             alowprefix1,
 *             allowprefix3,
 *             allowprefix2,
 *         },
 *         TransitRouterId = defaultRYcjsc.TransitRouterId,
 *         AssociationRegionId = "cn-hangzhou",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		alowprefix1 := "10.0.0.0/24"
 * 		if param := cfg.Get("alowprefix1"); param != "" {
 * 			alowprefix1 = param
 * 		}
 * 		allowprefix2 := "10.0.1.0/24"
 * 		if param := cfg.Get("allowprefix2"); param != "" {
 * 			allowprefix2 = param
 * 		}
 * 		allowprefix3 := "10.0.2.0/24"
 * 		if param := cfg.Get("allowprefix3"); param != "" {
 * 			allowprefix3 = param
 * 		}
 * 		allowprefix4 := "10.0.3.0/24"
 * 		if param := cfg.Get("allowprefix4"); param != "" {
 * 			allowprefix4 = param
 * 		}
 * 		asn := "4200001003"
 * 		if param := cfg.Get("asn"); param != "" {
 * 			asn = param
 * 		}
 * 		defaultpX0KlC, err := expressconnect.NewRouterExpressConnectRouter(ctx, "defaultpX0KlC", &expressconnect.RouterExpressConnectRouterArgs{
 * 			AlibabaSideAsn: pulumi.String(asn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default418DC9, err := cen.NewInstance(ctx, "default418DC9", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultRYcjsc, err := cen.NewTransitRouter(ctx, "defaultRYcjsc", &cen.TransitRouterArgs{
 * 			CenId: default418DC9.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		current, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewRouterTrAssociation(ctx, "default", &expressconnect.RouterTrAssociationArgs{
 * 			EcrId:                defaultpX0KlC.ID(),
 * 			CenId:                default418DC9.ID(),
 * 			TransitRouterOwnerId: pulumi.String(current.Id),
 * 			AllowedPrefixes: pulumi.StringArray{
 * 				pulumi.String(alowprefix1),
 * 				pulumi.String(allowprefix3),
 * 				pulumi.String(allowprefix2),
 * 			},
 * 			TransitRouterId:     defaultRYcjsc.TransitRouterId,
 * 			AssociationRegionId: pulumi.String("cn-hangzhou"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.expressconnect.RouterExpressConnectRouter;
 * import com.pulumi.alicloud.expressconnect.RouterExpressConnectRouterArgs;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.expressconnect.RouterTrAssociation;
 * import com.pulumi.alicloud.expressconnect.RouterTrAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var alowprefix1 = config.get("alowprefix1").orElse("10.0.0.0/24");
 *         final var allowprefix2 = config.get("allowprefix2").orElse("10.0.1.0/24");
 *         final var allowprefix3 = config.get("allowprefix3").orElse("10.0.2.0/24");
 *         final var allowprefix4 = config.get("allowprefix4").orElse("10.0.3.0/24");
 *         final var asn = config.get("asn").orElse("4200001003");
 *         var defaultpX0KlC = new RouterExpressConnectRouter("defaultpX0KlC", RouterExpressConnectRouterArgs.builder()
 *             .alibabaSideAsn(asn)
 *             .build());
 *         var default418DC9 = new Instance("default418DC9", InstanceArgs.builder()
 *             .cenInstanceName(name)
 *             .build());
 *         var defaultRYcjsc = new TransitRouter("defaultRYcjsc", TransitRouterArgs.builder()
 *             .cenId(default418DC9.id())
 *             .build());
 *         final var current = AlicloudFunctions.getAccount();
 *         var default_ = new RouterTrAssociation("default", RouterTrAssociationArgs.builder()
 *             .ecrId(defaultpX0KlC.id())
 *             .cenId(default418DC9.id())
 *             .transitRouterOwnerId(current.applyValue(getAccountResult -> getAccountResult.id()))
 *             .allowedPrefixes(
 *                 alowprefix1,
 *                 allowprefix3,
 *                 allowprefix2)
 *             .transitRouterId(defaultRYcjsc.transitRouterId())
 *             .associationRegionId("cn-hangzhou")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 *   alowprefix1:
 *     type: string
 *     default: 10.0.0.0/24
 *   allowprefix2:
 *     type: string
 *     default: 10.0.1.0/24
 *   allowprefix3:
 *     type: string
 *     default: 10.0.2.0/24
 *   allowprefix4:
 *     type: string
 *     default: 10.0.3.0/24
 *   asn:
 *     type: string
 *     default: '4200001003'
 * resources:
 *   defaultpX0KlC:
 *     type: alicloud:expressconnect:RouterExpressConnectRouter
 *     properties:
 *       alibabaSideAsn: ${asn}
 *   default418DC9:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: ${name}
 *   defaultRYcjsc:
 *     type: alicloud:cen:TransitRouter
 *     properties:
 *       cenId: ${default418DC9.id}
 *   default:
 *     type: alicloud:expressconnect:RouterTrAssociation
 *     properties:
 *       ecrId: ${defaultpX0KlC.id}
 *       cenId: ${default418DC9.id}
 *       transitRouterOwnerId: ${current.id}
 *       allowedPrefixes:
 *         - ${alowprefix1}
 *         - ${allowprefix3}
 *         - ${allowprefix2}
 *       transitRouterId: ${defaultRYcjsc.transitRouterId}
 *       associationRegionId: cn-hangzhou
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Router Express Connect Router Tr Association can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/routerTrAssociation:RouterTrAssociation example <ecr_id>:<association_id>:<transit_router_id>
 * ```
 * @property allowedPrefixes List of allowed route prefixes.
 * @property associationRegionId The region to which the VPC or TR belongs.
 * @property cenId The ID of the CEN instance.
 * @property ecrId The ID of the leased line gateway instance.
 * @property transitRouterId The ID of the forwarding router instance.
 * @property transitRouterOwnerId The ID of the Alibaba Cloud account to which the forwarding router belongs.
 */
public data class RouterTrAssociationArgs(
    public val allowedPrefixes: Output<List<String>>? = null,
    public val associationRegionId: Output<String>? = null,
    public val cenId: Output<String>? = null,
    public val ecrId: Output<String>? = null,
    public val transitRouterId: Output<String>? = null,
    public val transitRouterOwnerId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.RouterTrAssociationArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.RouterTrAssociationArgs =
        com.pulumi.alicloud.expressconnect.RouterTrAssociationArgs.builder()
            .allowedPrefixes(allowedPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .associationRegionId(associationRegionId?.applyValue({ args0 -> args0 }))
            .cenId(cenId?.applyValue({ args0 -> args0 }))
            .ecrId(ecrId?.applyValue({ args0 -> args0 }))
            .transitRouterId(transitRouterId?.applyValue({ args0 -> args0 }))
            .transitRouterOwnerId(transitRouterOwnerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouterTrAssociationArgs].
 */
@PulumiTagMarker
public class RouterTrAssociationArgsBuilder internal constructor() {
    private var allowedPrefixes: Output<List<String>>? = null

    private var associationRegionId: Output<String>? = null

    private var cenId: Output<String>? = null

    private var ecrId: Output<String>? = null

    private var transitRouterId: Output<String>? = null

    private var transitRouterOwnerId: Output<Int>? = null

    /**
     * @param value List of allowed route prefixes.
     */
    @JvmName("ixufbbwxiqrwdeik")
    public suspend fun allowedPrefixes(`value`: Output<List<String>>) {
        this.allowedPrefixes = value
    }

    @JvmName("oqlmfixaixsasobl")
    public suspend fun allowedPrefixes(vararg values: Output<String>) {
        this.allowedPrefixes = Output.all(values.asList())
    }

    /**
     * @param values List of allowed route prefixes.
     */
    @JvmName("tugsdsljkeaknmjg")
    public suspend fun allowedPrefixes(values: List<Output<String>>) {
        this.allowedPrefixes = Output.all(values)
    }

    /**
     * @param value The region to which the VPC or TR belongs.
     */
    @JvmName("antjnlympxymvxle")
    public suspend fun associationRegionId(`value`: Output<String>) {
        this.associationRegionId = value
    }

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("itjemyyonvckaxbg")
    public suspend fun cenId(`value`: Output<String>) {
        this.cenId = value
    }

    /**
     * @param value The ID of the leased line gateway instance.
     */
    @JvmName("oinjyqllnqcsgvpm")
    public suspend fun ecrId(`value`: Output<String>) {
        this.ecrId = value
    }

    /**
     * @param value The ID of the forwarding router instance.
     */
    @JvmName("gkxjdweendtmsxet")
    public suspend fun transitRouterId(`value`: Output<String>) {
        this.transitRouterId = value
    }

    /**
     * @param value The ID of the Alibaba Cloud account to which the forwarding router belongs.
     */
    @JvmName("gphbpmpdbaeyvseq")
    public suspend fun transitRouterOwnerId(`value`: Output<Int>) {
        this.transitRouterOwnerId = value
    }

    /**
     * @param value List of allowed route prefixes.
     */
    @JvmName("hxhncoxuhbkenyfp")
    public suspend fun allowedPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedPrefixes = mapped
    }

    /**
     * @param values List of allowed route prefixes.
     */
    @JvmName("irrtkcdcdapqsrih")
    public suspend fun allowedPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedPrefixes = mapped
    }

    /**
     * @param value The region to which the VPC or TR belongs.
     */
    @JvmName("ojrayvrhdwrjydbg")
    public suspend fun associationRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associationRegionId = mapped
    }

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("bindgfqtgohhvlyl")
    public suspend fun cenId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenId = mapped
    }

    /**
     * @param value The ID of the leased line gateway instance.
     */
    @JvmName("iywtvitbsrenjtck")
    public suspend fun ecrId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecrId = mapped
    }

    /**
     * @param value The ID of the forwarding router instance.
     */
    @JvmName("gbrqtrvkppykveqa")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterId = mapped
    }

    /**
     * @param value The ID of the Alibaba Cloud account to which the forwarding router belongs.
     */
    @JvmName("svvxkcbspdbsbmde")
    public suspend fun transitRouterOwnerId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterOwnerId = mapped
    }

    internal fun build(): RouterTrAssociationArgs = RouterTrAssociationArgs(
        allowedPrefixes = allowedPrefixes,
        associationRegionId = associationRegionId,
        cenId = cenId,
        ecrId = ecrId,
        transitRouterId = transitRouterId,
        transitRouterOwnerId = transitRouterOwnerId,
    )
}
