@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RouterVbrChildInstance].
 */
@PulumiTagMarker
public class RouterVbrChildInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouterVbrChildInstanceArgs = RouterVbrChildInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouterVbrChildInstanceArgsBuilder.() -> Unit) {
        val builder = RouterVbrChildInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RouterVbrChildInstance {
        val builtJavaResource =
            com.pulumi.alicloud.expressconnect.RouterVbrChildInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RouterVbrChildInstance(builtJavaResource)
    }
}

/**
 * Provides a Express Connect Router Express Connect Router Vbr Child Instance resource. Leased Line Gateway VBR sub-instance.
 * For information about Express Connect Router Express Connect Router Vbr Child Instance and how to use it, see [What is Express Connect Router Vbr Child Instance](https://next.api.alibabacloud.com/api/ExpressConnectRouter/2023-09-01/AttachExpressConnectRouterChildInstance).
 * > **NOTE:** Available since v1.224.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const nameRegex = alicloud.expressconnect.getPhysicalConnections({
 *     nameRegex: "^preserved-NODELETING",
 * });
 * const defaultydbbk3 = new alicloud.expressconnect.VirtualBorderRouter("defaultydbbk3", {
 *     physicalConnectionId: nameRegex.then(nameRegex => nameRegex.connections?.[0]?.id),
 *     vlanId: 1000,
 *     peerGatewayIp: "192.168.254.2",
 *     peeringSubnetMask: "255.255.255.0",
 *     localGatewayIp: "192.168.254.1",
 * });
 * const defaultAAlhUy = new alicloud.expressconnect.RouterExpressConnectRouter("defaultAAlhUy", {alibabaSideAsn: 65532});
 * const current = alicloud.getAccount({});
 * const _default = new alicloud.expressconnect.RouterVbrChildInstance("default", {
 *     childInstanceId: defaultydbbk3.id,
 *     childInstanceRegionId: "cn-hangzhou",
 *     ecrId: defaultAAlhUy.id,
 *     childInstanceType: "VBR",
 *     childInstanceOwnerId: current.then(current => current.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * name_regex = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
 * defaultydbbk3 = alicloud.expressconnect.VirtualBorderRouter("defaultydbbk3",
 *     physical_connection_id=name_regex.connections[0].id,
 *     vlan_id=1000,
 *     peer_gateway_ip="192.168.254.2",
 *     peering_subnet_mask="255.255.255.0",
 *     local_gateway_ip="192.168.254.1")
 * default_a_alh_uy = alicloud.expressconnect.RouterExpressConnectRouter("defaultAAlhUy", alibaba_side_asn=65532)
 * current = alicloud.get_account()
 * default = alicloud.expressconnect.RouterVbrChildInstance("default",
 *     child_instance_id=defaultydbbk3.id,
 *     child_instance_region_id="cn-hangzhou",
 *     ecr_id=default_a_alh_uy.id,
 *     child_instance_type="VBR",
 *     child_instance_owner_id=current.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var nameRegex = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
 *     {
 *         NameRegex = "^preserved-NODELETING",
 *     });
 *     var defaultydbbk3 = new AliCloud.ExpressConnect.VirtualBorderRouter("defaultydbbk3", new()
 *     {
 *         PhysicalConnectionId = nameRegex.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Connections[0]?.Id),
 *         VlanId = 1000,
 *         PeerGatewayIp = "192.168.254.2",
 *         PeeringSubnetMask = "255.255.255.0",
 *         LocalGatewayIp = "192.168.254.1",
 *     });
 *     var defaultAAlhUy = new AliCloud.ExpressConnect.RouterExpressConnectRouter("defaultAAlhUy", new()
 *     {
 *         AlibabaSideAsn = 65532,
 *     });
 *     var current = AliCloud.GetAccount.Invoke();
 *     var @default = new AliCloud.ExpressConnect.RouterVbrChildInstance("default", new()
 *     {
 *         ChildInstanceId = defaultydbbk3.Id,
 *         ChildInstanceRegionId = "cn-hangzhou",
 *         EcrId = defaultAAlhUy.Id,
 *         ChildInstanceType = "VBR",
 *         ChildInstanceOwnerId = current.Apply(getAccountResult => getAccountResult.Id),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		nameRegex, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
 * 			NameRegex: pulumi.StringRef("^preserved-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultydbbk3, err := expressconnect.NewVirtualBorderRouter(ctx, "defaultydbbk3", &expressconnect.VirtualBorderRouterArgs{
 * 			PhysicalConnectionId: pulumi.String(nameRegex.Connections[0].Id),
 * 			VlanId:               pulumi.Int(1000),
 * 			PeerGatewayIp:        pulumi.String("192.168.254.2"),
 * 			PeeringSubnetMask:    pulumi.String("255.255.255.0"),
 * 			LocalGatewayIp:       pulumi.String("192.168.254.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAAlhUy, err := expressconnect.NewRouterExpressConnectRouter(ctx, "defaultAAlhUy", &expressconnect.RouterExpressConnectRouterArgs{
 * 			AlibabaSideAsn: pulumi.Int(65532),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		current, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewRouterVbrChildInstance(ctx, "default", &expressconnect.RouterVbrChildInstanceArgs{
 * 			ChildInstanceId:       defaultydbbk3.ID(),
 * 			ChildInstanceRegionId: pulumi.String("cn-hangzhou"),
 * 			EcrId:                 defaultAAlhUy.ID(),
 * 			ChildInstanceType:     pulumi.String("VBR"),
 * 			ChildInstanceOwnerId:  pulumi.String(current.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
 * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsArgs;
 * import com.pulumi.alicloud.expressconnect.VirtualBorderRouter;
 * import com.pulumi.alicloud.expressconnect.VirtualBorderRouterArgs;
 * import com.pulumi.alicloud.expressconnect.RouterExpressConnectRouter;
 * import com.pulumi.alicloud.expressconnect.RouterExpressConnectRouterArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.expressconnect.RouterVbrChildInstance;
 * import com.pulumi.alicloud.expressconnect.RouterVbrChildInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var nameRegex = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
 *             .nameRegex("^preserved-NODELETING")
 *             .build());
 *         var defaultydbbk3 = new VirtualBorderRouter("defaultydbbk3", VirtualBorderRouterArgs.builder()
 *             .physicalConnectionId(nameRegex.applyValue(getPhysicalConnectionsResult -> getPhysicalConnectionsResult.connections()[0].id()))
 *             .vlanId("1000")
 *             .peerGatewayIp("192.168.254.2")
 *             .peeringSubnetMask("255.255.255.0")
 *             .localGatewayIp("192.168.254.1")
 *             .build());
 *         var defaultAAlhUy = new RouterExpressConnectRouter("defaultAAlhUy", RouterExpressConnectRouterArgs.builder()
 *             .alibabaSideAsn("65532")
 *             .build());
 *         final var current = AlicloudFunctions.getAccount();
 *         var default_ = new RouterVbrChildInstance("default", RouterVbrChildInstanceArgs.builder()
 *             .childInstanceId(defaultydbbk3.id())
 *             .childInstanceRegionId("cn-hangzhou")
 *             .ecrId(defaultAAlhUy.id())
 *             .childInstanceType("VBR")
 *             .childInstanceOwnerId(current.applyValue(getAccountResult -> getAccountResult.id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultydbbk3:
 *     type: alicloud:expressconnect:VirtualBorderRouter
 *     properties:
 *       physicalConnectionId: ${nameRegex.connections[0].id}
 *       vlanId: '1000'
 *       peerGatewayIp: 192.168.254.2
 *       peeringSubnetMask: 255.255.255.0
 *       localGatewayIp: 192.168.254.1
 *   defaultAAlhUy:
 *     type: alicloud:expressconnect:RouterExpressConnectRouter
 *     properties:
 *       alibabaSideAsn: '65532'
 *   default:
 *     type: alicloud:expressconnect:RouterVbrChildInstance
 *     properties:
 *       childInstanceId: ${defaultydbbk3.id}
 *       childInstanceRegionId: cn-hangzhou
 *       ecrId: ${defaultAAlhUy.id}
 *       childInstanceType: VBR
 *       childInstanceOwnerId: ${current.id}
 * variables:
 *   nameRegex:
 *     fn::invoke:
 *       Function: alicloud:expressconnect:getPhysicalConnections
 *       Arguments:
 *         nameRegex: ^preserved-NODELETING
 *   current:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Router Express Connect Router Vbr Child Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/routerVbrChildInstance:RouterVbrChildInstance example <ecr_id>:<child_instance_id>:<child_instance_type>
 * ```
 */
public class RouterVbrChildInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.expressconnect.RouterVbrChildInstance,
) : KotlinCustomResource(javaResource, RouterVbrChildInstanceMapper) {
    /**
     * The ID of the leased line gateway subinstance.
     */
    public val childInstanceId: Output<String>
        get() = javaResource.childInstanceId().applyValue({ args0 -> args0 })

    /**
     * The ID of the subinstance of the leased line gateway.
     */
    public val childInstanceOwnerId: Output<String>?
        get() = javaResource.childInstanceOwnerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Region of the leased line gateway sub-instance.
     */
    public val childInstanceRegionId: Output<String>
        get() = javaResource.childInstanceRegionId().applyValue({ args0 -> args0 })

    /**
     * The type of leased line gateway sub-instance, Valid values: `VBR`.
     */
    public val childInstanceType: Output<String>
        get() = javaResource.childInstanceType().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * ID of the representative leased line gateway instance.
     */
    public val ecrId: Output<String>
        get() = javaResource.ecrId().applyValue({ args0 -> args0 })

    /**
     * Binding relationship status of leased line gateway subinstances.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object RouterVbrChildInstanceMapper : ResourceMapper<RouterVbrChildInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.expressconnect.RouterVbrChildInstance::class == javaResource::class

    override fun map(javaResource: Resource): RouterVbrChildInstance =
        RouterVbrChildInstance(
            javaResource as
                com.pulumi.alicloud.expressconnect.RouterVbrChildInstance,
        )
}

/**
 * @see [RouterVbrChildInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouterVbrChildInstance].
 */
public suspend fun routerVbrChildInstance(
    name: String,
    block: suspend RouterVbrChildInstanceResourceBuilder.() -> Unit,
): RouterVbrChildInstance {
    val builder = RouterVbrChildInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouterVbrChildInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routerVbrChildInstance(name: String): RouterVbrChildInstance {
    val builder = RouterVbrChildInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
