@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.alicloud.expressconnect.RouterVpcAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Express Connect Router Express Connect Router Vpc Association resource. Bind relationship object between leased line gateway and VPC.
 * For information about Express Connect Router Express Connect Router Vpc Association and how to use it, see [What is Express Connect Router Vpc Association](https://next.api.alibabacloud.com/api/ExpressConnectRouter/2023-09-01/CreateExpressConnectRouterAssociation).
 * > **NOTE:** Available since v1.224.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default8qAtD6 = new alicloud.vpc.Network("default8qAtD6", {cidrBlock: "172.16.0.0/16"});
 * const defaultM9YxGW = new alicloud.expressconnect.RouterExpressConnectRouter("defaultM9YxGW", {alibabaSideAsn: 65533});
 * const current = alicloud.getAccount({});
 * const _default = new alicloud.expressconnect.RouterVpcAssociation("default", {
 *     ecrId: defaultM9YxGW.id,
 *     allowedPrefixes: [
 *         "172.16.4.0/24",
 *         "172.16.3.0/24",
 *         "172.16.2.0/24",
 *         "172.16.1.0/24",
 *     ],
 *     vpcOwnerId: current.then(current => current.id),
 *     associationRegionId: "cn-hangzhou",
 *     vpcId: default8qAtD6.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default8q_at_d6 = alicloud.vpc.Network("default8qAtD6", cidr_block="172.16.0.0/16")
 * default_m9_yx_gw = alicloud.expressconnect.RouterExpressConnectRouter("defaultM9YxGW", alibaba_side_asn=65533)
 * current = alicloud.get_account()
 * default = alicloud.expressconnect.RouterVpcAssociation("default",
 *     ecr_id=default_m9_yx_gw.id,
 *     allowed_prefixes=[
 *         "172.16.4.0/24",
 *         "172.16.3.0/24",
 *         "172.16.2.0/24",
 *         "172.16.1.0/24",
 *     ],
 *     vpc_owner_id=current.id,
 *     association_region_id="cn-hangzhou",
 *     vpc_id=default8q_at_d6.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var default8qAtD6 = new AliCloud.Vpc.Network("default8qAtD6", new()
 *     {
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultM9YxGW = new AliCloud.ExpressConnect.RouterExpressConnectRouter("defaultM9YxGW", new()
 *     {
 *         AlibabaSideAsn = 65533,
 *     });
 *     var current = AliCloud.GetAccount.Invoke();
 *     var @default = new AliCloud.ExpressConnect.RouterVpcAssociation("default", new()
 *     {
 *         EcrId = defaultM9YxGW.Id,
 *         AllowedPrefixes = new[]
 *         {
 *             "172.16.4.0/24",
 *             "172.16.3.0/24",
 *             "172.16.2.0/24",
 *             "172.16.1.0/24",
 *         },
 *         VpcOwnerId = current.Apply(getAccountResult => getAccountResult.Id),
 *         AssociationRegionId = "cn-hangzhou",
 *         VpcId = default8qAtD6.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		default8qAtD6, err := vpc.NewNetwork(ctx, "default8qAtD6", &vpc.NetworkArgs{
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultM9YxGW, err := expressconnect.NewRouterExpressConnectRouter(ctx, "defaultM9YxGW", &expressconnect.RouterExpressConnectRouterArgs{
 * 			AlibabaSideAsn: pulumi.Int(65533),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		current, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewRouterVpcAssociation(ctx, "default", &expressconnect.RouterVpcAssociationArgs{
 * 			EcrId: defaultM9YxGW.ID(),
 * 			AllowedPrefixes: pulumi.StringArray{
 * 				pulumi.String("172.16.4.0/24"),
 * 				pulumi.String("172.16.3.0/24"),
 * 				pulumi.String("172.16.2.0/24"),
 * 				pulumi.String("172.16.1.0/24"),
 * 			},
 * 			VpcOwnerId:          pulumi.String(current.Id),
 * 			AssociationRegionId: pulumi.String("cn-hangzhou"),
 * 			VpcId:               default8qAtD6.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.expressconnect.RouterExpressConnectRouter;
 * import com.pulumi.alicloud.expressconnect.RouterExpressConnectRouterArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.expressconnect.RouterVpcAssociation;
 * import com.pulumi.alicloud.expressconnect.RouterVpcAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default8qAtD6 = new Network("default8qAtD6", NetworkArgs.builder()
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultM9YxGW = new RouterExpressConnectRouter("defaultM9YxGW", RouterExpressConnectRouterArgs.builder()
 *             .alibabaSideAsn("65533")
 *             .build());
 *         final var current = AlicloudFunctions.getAccount();
 *         var default_ = new RouterVpcAssociation("default", RouterVpcAssociationArgs.builder()
 *             .ecrId(defaultM9YxGW.id())
 *             .allowedPrefixes(
 *                 "172.16.4.0/24",
 *                 "172.16.3.0/24",
 *                 "172.16.2.0/24",
 *                 "172.16.1.0/24")
 *             .vpcOwnerId(current.applyValue(getAccountResult -> getAccountResult.id()))
 *             .associationRegionId("cn-hangzhou")
 *             .vpcId(default8qAtD6.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default8qAtD6:
 *     type: alicloud:vpc:Network
 *     properties:
 *       cidrBlock: 172.16.0.0/16
 *   defaultM9YxGW:
 *     type: alicloud:expressconnect:RouterExpressConnectRouter
 *     properties:
 *       alibabaSideAsn: '65533'
 *   default:
 *     type: alicloud:expressconnect:RouterVpcAssociation
 *     properties:
 *       ecrId: ${defaultM9YxGW.id}
 *       allowedPrefixes:
 *         - 172.16.4.0/24
 *         - 172.16.3.0/24
 *         - 172.16.2.0/24
 *         - 172.16.1.0/24
 *       vpcOwnerId: ${current.id}
 *       associationRegionId: cn-hangzhou
 *       vpcId: ${default8qAtD6.id}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Router Express Connect Router Vpc Association can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/routerVpcAssociation:RouterVpcAssociation example <ecr_id>:<association_id>:<vpc_id>
 * ```
 * @property allowedPrefixes List of allowed route prefixes.
 * @property associationRegionId The region to which the VPC or TR belongs.
 * @property ecrId The ID of the leased line gateway instance.
 * @property vpcId The ID of the VPC instance.
 * @property vpcOwnerId The ID of the Alibaba Cloud account to which the VPC belongs.
 */
public data class RouterVpcAssociationArgs(
    public val allowedPrefixes: Output<List<String>>? = null,
    public val associationRegionId: Output<String>? = null,
    public val ecrId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vpcOwnerId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.RouterVpcAssociationArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.RouterVpcAssociationArgs =
        com.pulumi.alicloud.expressconnect.RouterVpcAssociationArgs.builder()
            .allowedPrefixes(allowedPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .associationRegionId(associationRegionId?.applyValue({ args0 -> args0 }))
            .ecrId(ecrId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vpcOwnerId(vpcOwnerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouterVpcAssociationArgs].
 */
@PulumiTagMarker
public class RouterVpcAssociationArgsBuilder internal constructor() {
    private var allowedPrefixes: Output<List<String>>? = null

    private var associationRegionId: Output<String>? = null

    private var ecrId: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vpcOwnerId: Output<Int>? = null

    /**
     * @param value List of allowed route prefixes.
     */
    @JvmName("rldyqeibgtncopjd")
    public suspend fun allowedPrefixes(`value`: Output<List<String>>) {
        this.allowedPrefixes = value
    }

    @JvmName("kumbmhchuilsmiga")
    public suspend fun allowedPrefixes(vararg values: Output<String>) {
        this.allowedPrefixes = Output.all(values.asList())
    }

    /**
     * @param values List of allowed route prefixes.
     */
    @JvmName("sunushmmfcjnixjh")
    public suspend fun allowedPrefixes(values: List<Output<String>>) {
        this.allowedPrefixes = Output.all(values)
    }

    /**
     * @param value The region to which the VPC or TR belongs.
     */
    @JvmName("wavwjlwwinnpbpre")
    public suspend fun associationRegionId(`value`: Output<String>) {
        this.associationRegionId = value
    }

    /**
     * @param value The ID of the leased line gateway instance.
     */
    @JvmName("bwvmlxfnddjydhab")
    public suspend fun ecrId(`value`: Output<String>) {
        this.ecrId = value
    }

    /**
     * @param value The ID of the VPC instance.
     */
    @JvmName("hvkielguwiwfvmjf")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the Alibaba Cloud account to which the VPC belongs.
     */
    @JvmName("xpmauxbfbnswovbn")
    public suspend fun vpcOwnerId(`value`: Output<Int>) {
        this.vpcOwnerId = value
    }

    /**
     * @param value List of allowed route prefixes.
     */
    @JvmName("lyklholrydsjvkps")
    public suspend fun allowedPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedPrefixes = mapped
    }

    /**
     * @param values List of allowed route prefixes.
     */
    @JvmName("ypotyspqvmgqowow")
    public suspend fun allowedPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedPrefixes = mapped
    }

    /**
     * @param value The region to which the VPC or TR belongs.
     */
    @JvmName("qludjchnodpegqfl")
    public suspend fun associationRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associationRegionId = mapped
    }

    /**
     * @param value The ID of the leased line gateway instance.
     */
    @JvmName("nrhnqovpbvoubmcv")
    public suspend fun ecrId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecrId = mapped
    }

    /**
     * @param value The ID of the VPC instance.
     */
    @JvmName("ajwwqqnwcnofmaal")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of the Alibaba Cloud account to which the VPC belongs.
     */
    @JvmName("bxxoasvthulspusj")
    public suspend fun vpcOwnerId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcOwnerId = mapped
    }

    internal fun build(): RouterVpcAssociationArgs = RouterVpcAssociationArgs(
        allowedPrefixes = allowedPrefixes,
        associationRegionId = associationRegionId,
        ecrId = ecrId,
        vpcId = vpcId,
        vpcOwnerId = vpcOwnerId,
    )
}
