@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TrafficQos].
 */
@PulumiTagMarker
public class TrafficQosResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrafficQosArgs = TrafficQosArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrafficQosArgsBuilder.() -> Unit) {
        val builder = TrafficQosArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TrafficQos {
        val builtJavaResource = com.pulumi.alicloud.expressconnect.TrafficQos(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrafficQos(builtJavaResource)
    }
}

/**
 * Provides a Express Connect Traffic Qos resource. Express Connect Traffic QoS Policy.
 * For information about Express Connect Traffic Qos and how to use it, see [What is Traffic Qos](https://next.api.alibabacloud.com/document/Vpc/2016-04-28/CreateExpressConnectTrafficQos).
 * > **NOTE:** Available since v1.224.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.expressconnect.getPhysicalConnections({
 *     nameRegex: "preserved-NODELETING",
 * });
 * const createQos = new alicloud.expressconnect.TrafficQos("createQos", {
 *     qosName: name,
 *     qosDescription: "terraform-example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.expressconnect.get_physical_connections(name_regex="preserved-NODELETING")
 * create_qos = alicloud.expressconnect.TrafficQos("createQos",
 *     qos_name=name,
 *     qos_description="terraform-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
 *     {
 *         NameRegex = "preserved-NODELETING",
 *     });
 *     var createQos = new AliCloud.ExpressConnect.TrafficQos("createQos", new()
 *     {
 *         QosName = name,
 *         QosDescription = "terraform-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
 * 			NameRegex: pulumi.StringRef("preserved-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewTrafficQos(ctx, "createQos", &expressconnect.TrafficQosArgs{
 * 			QosName:        pulumi.String(name),
 * 			QosDescription: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
 * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsArgs;
 * import com.pulumi.alicloud.expressconnect.TrafficQos;
 * import com.pulumi.alicloud.expressconnect.TrafficQosArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
 *             .nameRegex("preserved-NODELETING")
 *             .build());
 *         var createQos = new TrafficQos("createQos", TrafficQosArgs.builder()
 *             .qosName(name)
 *             .qosDescription("terraform-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   createQos:
 *     type: alicloud:expressconnect:TrafficQos
 *     properties:
 *       qosName: ${name}
 *       qosDescription: terraform-example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:expressconnect:getPhysicalConnections
 *       Arguments:
 *         nameRegex: preserved-NODELETING
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Traffic Qos can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/trafficQos:TrafficQos example <id>
 * ```
 */
public class TrafficQos internal constructor(
    override val javaResource: com.pulumi.alicloud.expressconnect.TrafficQos,
) : KotlinCustomResource(javaResource, TrafficQosMapper) {
    /**
     * The description of the QoS policy.  The length is **0** to **256** characters and cannot start with 'http:// 'or 'https.
     */
    public val qosDescription: Output<String>?
        get() = javaResource.qosDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the QoS policy.  The length is **0** to **128** characters and cannot start with 'http:// 'or 'https.
     */
    public val qosName: Output<String>?
        get() = javaResource.qosName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of the QoS policy. Value:
     * > **NOTE:**  QoS in the configuration state will restrict the creation, update, and deletion of most QoS policies, QoS queues, and QoS rules.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object TrafficQosMapper : ResourceMapper<TrafficQos> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.expressconnect.TrafficQos::class == javaResource::class

    override fun map(javaResource: Resource): TrafficQos = TrafficQos(
        javaResource as
            com.pulumi.alicloud.expressconnect.TrafficQos,
    )
}

/**
 * @see [TrafficQos].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrafficQos].
 */
public suspend fun trafficQos(name: String, block: suspend TrafficQosResourceBuilder.() -> Unit): TrafficQos {
    val builder = TrafficQosResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrafficQos].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trafficQos(name: String): TrafficQos {
    val builder = TrafficQosResourceBuilder()
    builder.name(name)
    return builder.build()
}
