@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.alicloud.expressconnect.TrafficQosArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Express Connect Traffic Qos resource. Express Connect Traffic QoS Policy.
 * For information about Express Connect Traffic Qos and how to use it, see [What is Traffic Qos](https://next.api.alibabacloud.com/document/Vpc/2016-04-28/CreateExpressConnectTrafficQos).
 * > **NOTE:** Available since v1.224.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.expressconnect.getPhysicalConnections({
 *     nameRegex: "preserved-NODELETING",
 * });
 * const createQos = new alicloud.expressconnect.TrafficQos("createQos", {
 *     qosName: name,
 *     qosDescription: "terraform-example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.expressconnect.get_physical_connections(name_regex="preserved-NODELETING")
 * create_qos = alicloud.expressconnect.TrafficQos("createQos",
 *     qos_name=name,
 *     qos_description="terraform-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
 *     {
 *         NameRegex = "preserved-NODELETING",
 *     });
 *     var createQos = new AliCloud.ExpressConnect.TrafficQos("createQos", new()
 *     {
 *         QosName = name,
 *         QosDescription = "terraform-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
 * 			NameRegex: pulumi.StringRef("preserved-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewTrafficQos(ctx, "createQos", &expressconnect.TrafficQosArgs{
 * 			QosName:        pulumi.String(name),
 * 			QosDescription: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
 * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsArgs;
 * import com.pulumi.alicloud.expressconnect.TrafficQos;
 * import com.pulumi.alicloud.expressconnect.TrafficQosArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
 *             .nameRegex("preserved-NODELETING")
 *             .build());
 *         var createQos = new TrafficQos("createQos", TrafficQosArgs.builder()
 *             .qosName(name)
 *             .qosDescription("terraform-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   createQos:
 *     type: alicloud:expressconnect:TrafficQos
 *     properties:
 *       qosName: ${name}
 *       qosDescription: terraform-example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:expressconnect:getPhysicalConnections
 *       Arguments:
 *         nameRegex: preserved-NODELETING
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Traffic Qos can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/trafficQos:TrafficQos example <id>
 * ```
 * @property qosDescription The description of the QoS policy.  The length is **0** to **256** characters and cannot start with 'http:// 'or 'https.
 * @property qosName The name of the QoS policy.  The length is **0** to **128** characters and cannot start with 'http:// 'or 'https.
 */
public data class TrafficQosArgs(
    public val qosDescription: Output<String>? = null,
    public val qosName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.TrafficQosArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.TrafficQosArgs =
        com.pulumi.alicloud.expressconnect.TrafficQosArgs.builder()
            .qosDescription(qosDescription?.applyValue({ args0 -> args0 }))
            .qosName(qosName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrafficQosArgs].
 */
@PulumiTagMarker
public class TrafficQosArgsBuilder internal constructor() {
    private var qosDescription: Output<String>? = null

    private var qosName: Output<String>? = null

    /**
     * @param value The description of the QoS policy.  The length is **0** to **256** characters and cannot start with 'http:// 'or 'https.
     */
    @JvmName("rkenyojdvudmjqbj")
    public suspend fun qosDescription(`value`: Output<String>) {
        this.qosDescription = value
    }

    /**
     * @param value The name of the QoS policy.  The length is **0** to **128** characters and cannot start with 'http:// 'or 'https.
     */
    @JvmName("aivaunlheumpcmpj")
    public suspend fun qosName(`value`: Output<String>) {
        this.qosName = value
    }

    /**
     * @param value The description of the QoS policy.  The length is **0** to **256** characters and cannot start with 'http:// 'or 'https.
     */
    @JvmName("trrxpegiiliigoqn")
    public suspend fun qosDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qosDescription = mapped
    }

    /**
     * @param value The name of the QoS policy.  The length is **0** to **128** characters and cannot start with 'http:// 'or 'https.
     */
    @JvmName("gstmrbtkuaklsokd")
    public suspend fun qosName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qosName = mapped
    }

    internal fun build(): TrafficQosArgs = TrafficQosArgs(
        qosDescription = qosDescription,
        qosName = qosName,
    )
}
