@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.alicloud.expressconnect.TrafficQosAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Express Connect Traffic Qos Association resource. Express Connect QoS associated resources.
 * For information about Express Connect Traffic Qos Association and how to use it, see [What is Traffic Qos Association](https://next.api.alibabacloud.com/document/Vpc/2016-04-28/ModifyExpressConnectTrafficQos).
 * > **NOTE:** Available since v1.224.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.expressconnect.getPhysicalConnections({
 *     nameRegex: "preserved-NODELETING",
 * });
 * const createQos = new alicloud.expressconnect.TrafficQos("createQos", {
 *     qosName: name,
 *     qosDescription: "terraform-example",
 * });
 * const associateQos = new alicloud.expressconnect.TrafficQosAssociation("associateQos", {
 *     instanceId: _default.then(_default => _default.ids?.[1]),
 *     qosId: createQos.id,
 *     instanceType: "PHYSICALCONNECTION",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.expressconnect.get_physical_connections(name_regex="preserved-NODELETING")
 * create_qos = alicloud.expressconnect.TrafficQos("createQos",
 *     qos_name=name,
 *     qos_description="terraform-example")
 * associate_qos = alicloud.expressconnect.TrafficQosAssociation("associateQos",
 *     instance_id=default.ids[1],
 *     qos_id=create_qos.id,
 *     instance_type="PHYSICALCONNECTION")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
 *     {
 *         NameRegex = "preserved-NODELETING",
 *     });
 *     var createQos = new AliCloud.ExpressConnect.TrafficQos("createQos", new()
 *     {
 *         QosName = name,
 *         QosDescription = "terraform-example",
 *     });
 *     var associateQos = new AliCloud.ExpressConnect.TrafficQosAssociation("associateQos", new()
 *     {
 *         InstanceId = @default.Apply(@default => @default.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Ids[1])),
 *         QosId = createQos.Id,
 *         InstanceType = "PHYSICALCONNECTION",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
 * 			NameRegex: pulumi.StringRef("preserved-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		createQos, err := expressconnect.NewTrafficQos(ctx, "createQos", &expressconnect.TrafficQosArgs{
 * 			QosName:        pulumi.String(name),
 * 			QosDescription: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewTrafficQosAssociation(ctx, "associateQos", &expressconnect.TrafficQosAssociationArgs{
 * 			InstanceId:   pulumi.String(_default.Ids[1]),
 * 			QosId:        createQos.ID(),
 * 			InstanceType: pulumi.String("PHYSICALCONNECTION"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
 * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsArgs;
 * import com.pulumi.alicloud.expressconnect.TrafficQos;
 * import com.pulumi.alicloud.expressconnect.TrafficQosArgs;
 * import com.pulumi.alicloud.expressconnect.TrafficQosAssociation;
 * import com.pulumi.alicloud.expressconnect.TrafficQosAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
 *             .nameRegex("preserved-NODELETING")
 *             .build());
 *         var createQos = new TrafficQos("createQos", TrafficQosArgs.builder()
 *             .qosName(name)
 *             .qosDescription("terraform-example")
 *             .build());
 *         var associateQos = new TrafficQosAssociation("associateQos", TrafficQosAssociationArgs.builder()
 *             .instanceId(default_.ids()[1])
 *             .qosId(createQos.id())
 *             .instanceType("PHYSICALCONNECTION")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   createQos:
 *     type: alicloud:expressconnect:TrafficQos
 *     properties:
 *       qosName: ${name}
 *       qosDescription: terraform-example
 *   associateQos:
 *     type: alicloud:expressconnect:TrafficQosAssociation
 *     properties:
 *       instanceId: ${default.ids[1]}
 *       qosId: ${createQos.id}
 *       instanceType: PHYSICALCONNECTION
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:expressconnect:getPhysicalConnections
 *       Arguments:
 *         nameRegex: preserved-NODELETING
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Traffic Qos Association can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/trafficQosAssociation:TrafficQosAssociation example <qos_id>:<instance_id>:<instance_type>
 * ```
 * @property instanceId The ID of the associated instance.
 * @property instanceType The type of the associated instance. Value: **physical connection** physical connection.
 * @property qosId The QoS policy ID.
 */
public data class TrafficQosAssociationArgs(
    public val instanceId: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val qosId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.TrafficQosAssociationArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.TrafficQosAssociationArgs =
        com.pulumi.alicloud.expressconnect.TrafficQosAssociationArgs.builder()
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .qosId(qosId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrafficQosAssociationArgs].
 */
@PulumiTagMarker
public class TrafficQosAssociationArgsBuilder internal constructor() {
    private var instanceId: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var qosId: Output<String>? = null

    /**
     * @param value The ID of the associated instance.
     */
    @JvmName("xfjhoiwbawwltnol")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The type of the associated instance. Value: **physical connection** physical connection.
     */
    @JvmName("pfkvitexvhgcsquq")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The QoS policy ID.
     */
    @JvmName("dwffbtunejodnble")
    public suspend fun qosId(`value`: Output<String>) {
        this.qosId = value
    }

    /**
     * @param value The ID of the associated instance.
     */
    @JvmName("yomrmgylmianaaeq")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The type of the associated instance. Value: **physical connection** physical connection.
     */
    @JvmName("tdvofddgfvbkdkye")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The QoS policy ID.
     */
    @JvmName("ybvnfovaeqyudxxm")
    public suspend fun qosId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qosId = mapped
    }

    internal fun build(): TrafficQosAssociationArgs = TrafficQosAssociationArgs(
        instanceId = instanceId,
        instanceType = instanceType,
        qosId = qosId,
    )
}
