@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VbrPconnAssociation].
 */
@PulumiTagMarker
public class VbrPconnAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VbrPconnAssociationArgs = VbrPconnAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VbrPconnAssociationArgsBuilder.() -> Unit) {
        val builder = VbrPconnAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VbrPconnAssociation {
        val builtJavaResource =
            com.pulumi.alicloud.expressconnect.VbrPconnAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VbrPconnAssociation(builtJavaResource)
    }
}

/**
 * Provides a Express Connect Vbr Pconn Association resource.
 * For information about Express Connect Vbr Pconn Association and how to use it, see [What is Vbr Pconn Association](https://www.alibabacloud.com/help/en/express-connect/latest/associatephysicalconnectiontovirtualborderrouter#doc-api-Vpc-AssociatePhysicalConnectionToVirtualBorderRouter).
 * > **NOTE:** Available since v1.196.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = alicloud.expressconnect.getPhysicalConnections({
 *     nameRegex: "^preserved-NODELETING",
 * });
 * const _default = new alicloud.expressconnect.VirtualBorderRouter("default", {
 *     localGatewayIp: "10.0.0.1",
 *     peerGatewayIp: "10.0.0.2",
 *     peeringSubnetMask: "255.255.255.252",
 *     physicalConnectionId: example.then(example => example.connections?.[0]?.id),
 *     virtualBorderRouterName: name,
 *     vlanId: 110,
 *     minRxInterval: 1000,
 *     minTxInterval: 1000,
 *     detectMultiplier: 10,
 *     enableIpv6: true,
 *     localIpv6GatewayIp: "2408:4004:cc:400::1",
 *     peerIpv6GatewayIp: "2408:4004:cc:400::2",
 *     peeringIpv6SubnetMask: "2408:4004:cc:400::/56",
 * });
 * const exampleVbrPconnAssociation = new alicloud.expressconnect.VbrPconnAssociation("example", {
 *     peerGatewayIp: "10.0.0.6",
 *     localGatewayIp: "10.0.0.5",
 *     physicalConnectionId: example.then(example => example.connections?.[2]?.id),
 *     vbrId: _default.id,
 *     peeringSubnetMask: "255.255.255.252",
 *     vlanId: 1122,
 *     enableIpv6: true,
 *     localIpv6GatewayIp: "2408:4004:cc::3",
 *     peerIpv6GatewayIp: "2408:4004:cc::4",
 *     peeringIpv6SubnetMask: "2408:4004:cc::/56",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
 * default = alicloud.expressconnect.VirtualBorderRouter("default",
 *     local_gateway_ip="10.0.0.1",
 *     peer_gateway_ip="10.0.0.2",
 *     peering_subnet_mask="255.255.255.252",
 *     physical_connection_id=example.connections[0].id,
 *     virtual_border_router_name=name,
 *     vlan_id=110,
 *     min_rx_interval=1000,
 *     min_tx_interval=1000,
 *     detect_multiplier=10,
 *     enable_ipv6=True,
 *     local_ipv6_gateway_ip="2408:4004:cc:400::1",
 *     peer_ipv6_gateway_ip="2408:4004:cc:400::2",
 *     peering_ipv6_subnet_mask="2408:4004:cc:400::/56")
 * example_vbr_pconn_association = alicloud.expressconnect.VbrPconnAssociation("example",
 *     peer_gateway_ip="10.0.0.6",
 *     local_gateway_ip="10.0.0.5",
 *     physical_connection_id=example.connections[2].id,
 *     vbr_id=default.id,
 *     peering_subnet_mask="255.255.255.252",
 *     vlan_id=1122,
 *     enable_ipv6=True,
 *     local_ipv6_gateway_ip="2408:4004:cc::3",
 *     peer_ipv6_gateway_ip="2408:4004:cc::4",
 *     peering_ipv6_subnet_mask="2408:4004:cc::/56")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
 *     {
 *         NameRegex = "^preserved-NODELETING",
 *     });
 *     var @default = new AliCloud.ExpressConnect.VirtualBorderRouter("default", new()
 *     {
 *         LocalGatewayIp = "10.0.0.1",
 *         PeerGatewayIp = "10.0.0.2",
 *         PeeringSubnetMask = "255.255.255.252",
 *         PhysicalConnectionId = example.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Connections[0]?.Id),
 *         VirtualBorderRouterName = name,
 *         VlanId = 110,
 *         MinRxInterval = 1000,
 *         MinTxInterval = 1000,
 *         DetectMultiplier = 10,
 *         EnableIpv6 = true,
 *         LocalIpv6GatewayIp = "2408:4004:cc:400::1",
 *         PeerIpv6GatewayIp = "2408:4004:cc:400::2",
 *         PeeringIpv6SubnetMask = "2408:4004:cc:400::/56",
 *     });
 *     var exampleVbrPconnAssociation = new AliCloud.ExpressConnect.VbrPconnAssociation("example", new()
 *     {
 *         PeerGatewayIp = "10.0.0.6",
 *         LocalGatewayIp = "10.0.0.5",
 *         PhysicalConnectionId = example.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Connections[2]?.Id),
 *         VbrId = @default.Id,
 *         PeeringSubnetMask = "255.255.255.252",
 *         VlanId = 1122,
 *         EnableIpv6 = true,
 *         LocalIpv6GatewayIp = "2408:4004:cc::3",
 *         PeerIpv6GatewayIp = "2408:4004:cc::4",
 *         PeeringIpv6SubnetMask = "2408:4004:cc::/56",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
 * 			NameRegex: pulumi.StringRef("^preserved-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewVirtualBorderRouter(ctx, "default", &expressconnect.VirtualBorderRouterArgs{
 * 			LocalGatewayIp:          pulumi.String("10.0.0.1"),
 * 			PeerGatewayIp:           pulumi.String("10.0.0.2"),
 * 			PeeringSubnetMask:       pulumi.String("255.255.255.252"),
 * 			PhysicalConnectionId:    pulumi.String(example.Connections[0].Id),
 * 			VirtualBorderRouterName: pulumi.String(name),
 * 			VlanId:                  pulumi.Int(110),
 * 			MinRxInterval:           pulumi.Int(1000),
 * 			MinTxInterval:           pulumi.Int(1000),
 * 			DetectMultiplier:        pulumi.Int(10),
 * 			EnableIpv6:              pulumi.Bool(true),
 * 			LocalIpv6GatewayIp:      pulumi.String("2408:4004:cc:400::1"),
 * 			PeerIpv6GatewayIp:       pulumi.String("2408:4004:cc:400::2"),
 * 			PeeringIpv6SubnetMask:   pulumi.String("2408:4004:cc:400::/56"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewVbrPconnAssociation(ctx, "example", &expressconnect.VbrPconnAssociationArgs{
 * 			PeerGatewayIp:         pulumi.String("10.0.0.6"),
 * 			LocalGatewayIp:        pulumi.String("10.0.0.5"),
 * 			PhysicalConnectionId:  pulumi.String(example.Connections[2].Id),
 * 			VbrId:                 _default.ID(),
 * 			PeeringSubnetMask:     pulumi.String("255.255.255.252"),
 * 			VlanId:                pulumi.Int(1122),
 * 			EnableIpv6:            pulumi.Bool(true),
 * 			LocalIpv6GatewayIp:    pulumi.String("2408:4004:cc::3"),
 * 			PeerIpv6GatewayIp:     pulumi.String("2408:4004:cc::4"),
 * 			PeeringIpv6SubnetMask: pulumi.String("2408:4004:cc::/56"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
 * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsArgs;
 * import com.pulumi.alicloud.expressconnect.VirtualBorderRouter;
 * import com.pulumi.alicloud.expressconnect.VirtualBorderRouterArgs;
 * import com.pulumi.alicloud.expressconnect.VbrPconnAssociation;
 * import com.pulumi.alicloud.expressconnect.VbrPconnAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var example = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
 *             .nameRegex("^preserved-NODELETING")
 *             .build());
 *         var default_ = new VirtualBorderRouter("default", VirtualBorderRouterArgs.builder()
 *             .localGatewayIp("10.0.0.1")
 *             .peerGatewayIp("10.0.0.2")
 *             .peeringSubnetMask("255.255.255.252")
 *             .physicalConnectionId(example.applyValue(getPhysicalConnectionsResult -> getPhysicalConnectionsResult.connections()[0].id()))
 *             .virtualBorderRouterName(name)
 *             .vlanId(110)
 *             .minRxInterval(1000)
 *             .minTxInterval(1000)
 *             .detectMultiplier(10)
 *             .enableIpv6(true)
 *             .localIpv6GatewayIp("2408:4004:cc:400::1")
 *             .peerIpv6GatewayIp("2408:4004:cc:400::2")
 *             .peeringIpv6SubnetMask("2408:4004:cc:400::/56")
 *             .build());
 *         var exampleVbrPconnAssociation = new VbrPconnAssociation("exampleVbrPconnAssociation", VbrPconnAssociationArgs.builder()
 *             .peerGatewayIp("10.0.0.6")
 *             .localGatewayIp("10.0.0.5")
 *             .physicalConnectionId(example.applyValue(getPhysicalConnectionsResult -> getPhysicalConnectionsResult.connections()[2].id()))
 *             .vbrId(default_.id())
 *             .peeringSubnetMask("255.255.255.252")
 *             .vlanId("1122")
 *             .enableIpv6(true)
 *             .localIpv6GatewayIp("2408:4004:cc::3")
 *             .peerIpv6GatewayIp("2408:4004:cc::4")
 *             .peeringIpv6SubnetMask("2408:4004:cc::/56")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:expressconnect:VirtualBorderRouter
 *     properties:
 *       localGatewayIp: 10.0.0.1
 *       peerGatewayIp: 10.0.0.2
 *       peeringSubnetMask: 255.255.255.252
 *       physicalConnectionId: ${example.connections[0].id}
 *       virtualBorderRouterName: ${name}
 *       vlanId: 110
 *       minRxInterval: 1000
 *       minTxInterval: 1000
 *       detectMultiplier: 10
 *       enableIpv6: true
 *       localIpv6GatewayIp: 2408:4004:cc:400::1
 *       peerIpv6GatewayIp: 2408:4004:cc:400::2
 *       peeringIpv6SubnetMask: 2408:4004:cc:400::/56
 *   exampleVbrPconnAssociation:
 *     type: alicloud:expressconnect:VbrPconnAssociation
 *     name: example
 *     properties:
 *       peerGatewayIp: 10.0.0.6
 *       localGatewayIp: 10.0.0.5
 *       physicalConnectionId: ${example.connections[2].id}
 *       vbrId: ${default.id}
 *       peeringSubnetMask: 255.255.255.252
 *       vlanId: '1122'
 *       enableIpv6: true
 *       localIpv6GatewayIp: 2408:4004:cc::3
 *       peerIpv6GatewayIp: 2408:4004:cc::4
 *       peeringIpv6SubnetMask: 2408:4004:cc::/56
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:expressconnect:getPhysicalConnections
 *       Arguments:
 *         nameRegex: ^preserved-NODELETING
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Vbr Pconn Association can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/vbrPconnAssociation:VbrPconnAssociation example <VbrId>:<PhysicalConnectionId>
 * ```
 */
public class VbrPconnAssociation internal constructor(
    override val javaResource: com.pulumi.alicloud.expressconnect.VbrPconnAssociation,
) : KotlinCustomResource(javaResource, VbrPconnAssociationMapper) {
    /**
     * The circuit code provided by the operator for the physical connection.
     */
    public val circuitCode: Output<String>
        get() = javaResource.circuitCode().applyValue({ args0 -> args0 })

    /**
     * Whether IPv6 is enabled. Value:
     * - **true**: on.
     * - **false** (default): Off.
     */
    public val enableIpv6: Output<Boolean>
        get() = javaResource.enableIpv6().applyValue({ args0 -> args0 })

    /**
     * The Alibaba cloud IP address of the VBR instance.
     */
    public val localGatewayIp: Output<String>?
        get() = javaResource.localGatewayIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IPv6 address on the Alibaba Cloud side of the VBR instance.
     */
    public val localIpv6GatewayIp: Output<String>?
        get() = javaResource.localIpv6GatewayIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The client IP address of the VBR instance. This attribute only allows the VBR owner to specify or modify. **NOTE:** Required when creating a VBR instance for the physical connection owner.
     */
    public val peerGatewayIp: Output<String>?
        get() = javaResource.peerGatewayIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IPv6 address of the client side of the VBR instance. This attribute only allows the VBR owner to specify or modify. **NOTE:** Required when creating a VBR instance for the physical connection owner.
     */
    public val peerIpv6GatewayIp: Output<String>?
        get() = javaResource.peerIpv6GatewayIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The subnet mask of the Alibaba Cloud side and the client side of the VBR instance.Two IPv6 addresses must be in the same subnet.
     */
    public val peeringIpv6SubnetMask: Output<String>?
        get() = javaResource.peeringIpv6SubnetMask().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The subnet mask of the Alibaba Cloud side and the client side of the VBR instance.The two IP addresses must be in the same subnet.
     */
    public val peeringSubnetMask: Output<String>?
        get() = javaResource.peeringSubnetMask().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the leased line instance.
     */
    public val physicalConnectionId: Output<String>
        get() = javaResource.physicalConnectionId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The ID of the VBR instance.
     */
    public val vbrId: Output<String>
        get() = javaResource.vbrId().applyValue({ args0 -> args0 })

    /**
     * VLAN ID of the VBR. Valid values: **0 to 2999**. **NOTE:** only the owner of the physical connection can specify this parameter. The VLAN ID of two VBRs under the same physical connection cannot be the same.
     */
    public val vlanId: Output<Int>
        get() = javaResource.vlanId().applyValue({ args0 -> args0 })
}

public object VbrPconnAssociationMapper : ResourceMapper<VbrPconnAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.expressconnect.VbrPconnAssociation::class == javaResource::class

    override fun map(javaResource: Resource): VbrPconnAssociation = VbrPconnAssociation(
        javaResource
            as com.pulumi.alicloud.expressconnect.VbrPconnAssociation,
    )
}

/**
 * @see [VbrPconnAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VbrPconnAssociation].
 */
public suspend fun vbrPconnAssociation(
    name: String,
    block: suspend VbrPconnAssociationResourceBuilder.() -> Unit,
): VbrPconnAssociation {
    val builder = VbrPconnAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VbrPconnAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vbrPconnAssociation(name: String): VbrPconnAssociation {
    val builder = VbrPconnAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
